#!/bin/sh
# Act a filter on an RPM spec file.
# read line by line and replace the Summary: and Description: lines
# by merging the file Summary and Description
while read line
do
	if [ "$line" = "Summary:" ] ; then
		if [ -f Summary ] ; then
			echo -n $line 
			cat Summary
		else
			echo Missing Summary file 1>&2
		fi
		if [ -f ../Vendor ] ; then
			echo Vendor: `cat ../Vendor`
		fi
		if [ -f ../Distribution ] ; then
			echo Distribution: `cat ../Distribution`
		fi
	elif [ "$line" = "URL:" ] ; then
		if [ -f Url ] ; then
			echo $line `cat Url`
		fi

	elif [ "$line" = "Copyright:" ] ; then
		if [ -f Copyright ] ; then
			echo $line `cat Copyright`
		else
			echo $line GPL
			echo 1>&2
			echo "     " Package under GPL license by default 1>&2
			echo "     " Create a Copyright file with a single line 1>&2
			echo "     " if this is not what you want 1>&2
			echo 1>&2
			sleep 3
		fi
	elif [ "$line" = "%description" ] ; then
		if [ -f Description ] ; then
			echo $line
			cat Description
		else
			echo Missing Description file 1>&2
		fi
	else
		echo "$line"
	fi
done

