/*
 * $Id: unistr.h,v 1.7 2001/06/09 00:25:55 antona Exp $
 *
 * unistr.h - Exports for unicode string handling. Part of the Linux-NTFS
 *	      project.
 *
 * Copyright (c) 2000,2001 Anton Altaparmakov.
 *
 * This program/include file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program/include file is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in the main directory of the Linux-NTFS 
 * distribution in the file COPYING); if not, write to the Free Software
 * Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef UNISTR_H
#define UNISTR_H

#include "types.h"
#include "endians.h"
#include "support.h"

extern const __u8 legal_ansi_char_array[0x40];

/*
 * These are just to make the code more readable...
 */
typedef enum {
	CASE_SENSITIVE = 0,
	IGNORE_CASE = 1,
} IGNORE_CASE_BOOL;

BOOL ntfs_are_names_equal(const uchar_t *s1, size_t s1_len,
			  const uchar_t *s2, size_t s2_len,
			  const IGNORE_CASE_BOOL ic,
			  const uchar_t *upcase, const __u32 upcase_size);

int ntfs_collate_names(const uchar_t *name1, const __u32 name1_len,
		const uchar_t *name2, const __u32 name2_len,
		const int err_val, const IGNORE_CASE_BOOL ic,
		const uchar_t *upcase, const __u32 upcase_len);

int ntfs_wcsncmp(const uchar_t *s1, const uchar_t *s2, size_t n);

int ntfs_wcsncasecmp(const uchar_t *s1, const uchar_t *s2, size_t n,
		     const uchar_t *upcase, const __u32 upcase_size);

void ntfs_upcase_name(uchar_t *name, __u32 name_len, const uchar_t *upcase,
		const __u32 upcase_len);

void ntfs_file_upcase_value(FILE_NAME_ATTR *file_name_attr,
		const uchar_t *upcase, const __u32 upcase_len);

int ntfs_file_compare_values(FILE_NAME_ATTR *file_name_attr1,
		FILE_NAME_ATTR *file_name_attr2,
		const int err_val, const IGNORE_CASE_BOOL ic,
		const uchar_t *upcase, const __u32 upcase_len);

#endif /* defined UNISTR_H */

