##  Copyright (C) 1998,1999  marduk <marduk@python.net>

##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.

##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.

##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: filelink.py,v 1.5 1999/03/12 04:56:07 marduk Exp $

# $Log: filelink.py,v $
# Revision 1.5  1999/03/12 04:56:07  marduk
# Added ability to warn of old versions of linbot/plugins
# Added patch to enable file:// to work with OS/2
#
# Revision 1.4  1999/03/11 04:51:32  marduk
# Added version module.
#
# Revision 1.3  1999/01/10 01:02:15  marduk
# Linbot 1.0b6
#
# Revision 1.2  1998/12/31 03:49:14  marduk
# This is linbot 1.0b5.  See CHANGES
#
# Revision 1.1.1.1  1998/12/20 23:17:13  marduk
# initial 1.0
#

"""This module defines the functions needed for creating Link objects for urls
using the file scheme"""

import urlparse
import os
import time
import mimetypes
import myUrlLib
import regsub

mimetypes.types_map['.shtml']='text/html'

def init(self, url, parent):
    self.URL = myUrlLib.basejoin(parent,url)
    parsed = urlparse.urlparse(self.URL,'file',0)
    filename = parsed[2]
    if os.name != 'posix':
	filename = regsub.sub("^/\(//\)?\([a-zA-Z]\)[|:]","\\2:",filename)
    try:
	stats = os.stat(filename)
    except os.error:
	self.set_bad_link(self.URL, "No such file or directory")
	return

    self.size = stats[6]
    
    lastMod = stats[8]
    self.age = int((time.time()-lastMod)/myUrlLib.SECS_PER_DAY)
    
    self.type = mimetypes.guess_type(url)[0]
    if self.type is None: self.type = 'application/octet-stream' # good enough?

def get_document(url):
    parsed = urlparse.urlparse(url,'file',0)
    filename = parsed[2]
    if os.name != 'posix':
	filename = regsub.sub("^/\(//\)?\([a-zA-Z]\)[|:]","\\2:",filename)
    
    return open(filename,'r').read()
    
