#! /bin/sh

#
# This script is used as the startup script in "make test".
# This file is NOT intended to be executed by the user!
#

# fd 5 is used as the messaging channel.

### Functions

ECHONE () {
    echo -ne "$*" >&5
}

ECHO () {
    echo "$*" >&5
}

CMD () {
    echo ">$* " >&5
    echo "$*"
}

waitforfile () {
    while test -e /tmp/$1 ; do
	sleep 1
    done
}

waiting () {
    COUNT=$1
    while test "$COUNT" -gt 0; do
	ECHONE "  Waiting $COUNT...   \r"
	sleep 1
	COUNT=$[ $COUNT - 1 ]
    done
    ECHO "  Waiting 0...   "
}

### Main piece

ECHO "  I'm here..."
touch /tmp/ledd-test-first

waitforfile ledd-test-first
ECHO "  Aye-aye, sir!"


#####


ECHO
ECHO "  First a simple one... Caps Lock BLINKING, Scroll Lock ON"
ECHO

CMD set s on
CMD set c blink 500

waiting 7
CMD set ncs off


#####


ECHO
ECHO "  Now the DUTYCYCLE sequence. Ranges from 0 to 10 on a Scroll Lock near you."
ECHO

COUNT=-1
while test "$COUNT" -le 11; do
    CMD set s dutycycle 1000 0 10 $COUNT
    sleep 5
    COUNT=$[ $COUNT + 2 ]
done
ECHO
CMD set ncs off


#####


ECHO
ECHO "  And the similar, but slightly different FREQUENCY."
ECHO

COUNT=-1
while test "$COUNT" -le 11; do
    CMD set s frequency 0 1000 10 100 $COUNT
    sleep 5
    COUNT=$[ $COUNT + 2 ]
done
ECHO
CMD set ncs off


#####


ECHO
ECHO "  And then ANIMATION! The LEDs should first one at a time go"
ECHO "  on and off, then start flashing with a beam moving over them."
ECHO

sleep 2

CMD anim 1000 N 1000 nC 1000 cS 1000 s 1000 loop N 100 C 100 n 100 S 100 c 100 s 100 S 100 C 100 s 100 N 100 c 100 n 100

waiting 15

ECHO
CMD anim

#####


ECHO
ECHO "  ...and a little tune. Imagine Scroll Lock to be the highest tone."
ECHO

sleep 2

CMD anim scn 1000 S 500 sC 500 cN 500 n 500 S 500 sC 500 cN 500 n 500 N 100 n 100 N 100 n 100 N 100 n 100 N 100 n 100 C 100 c 100 C 100 c 100 C 100 c 100 C 100 c 100 S 500 sC 500 cN 500 n 500 S 500 sC 500 cN 500 n 500 S 500 sC 500 cN 500 n 500 N 100 n 100 N 100 n 100 N 100 n 100 N 100 n 100 C 100 c 100 C 100 c 100 C 100 c 100 C 100 c 100 S 500 sC 500 cN 500 n 1000

waiting 18


#####


ECHO
ECHO "  Thats all from me... now back to your host!"
ECHO

touch /tmp/ledd-test-second

