/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	RBD
 *
 *	Function:	- receives a message at the datalink sublayer
 *			- do not overwrite the header, only change the
 *			  nh_length and nh_type fields and the data pouch
 */

#include <string.h>

#include <net.h>
#include <typical.h>

int
drecv(nhead)

struct nmsg		*nhead;

{
	struct nmsg	incoming;	/* received network message header */
/*
 * Receive the message in a separate header.
 */
	memcpy((char *) &incoming, (char *) nhead, sizeof(struct nmsg));

	if (frecv(&incoming)) return(LAMERROR);
/*
 * Copy the received nh_type and nh_length fields and the data pouch.
 */
	nhead->nh_type = incoming.nh_type;
	nhead->nh_length = LAM_min(incoming.nh_length, nhead->nh_length);
	memcpy((char *) nhead->nh_data, (char *) incoming.nh_data,
			NHDSIZE * sizeof(int4));

	return(0);
}

/*
 *	dtry_recv
 *
 *	Function:	- non-blocking drecv()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_recv(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = drecv(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
