/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: lamreceive.c,v 1.2 1999/11/12 05:19:30 jsquyres Exp $
 *
 *	Function:	- internal version of receives
 */

#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 *	lam_recv
 *
 *	Function:	- internal receive
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- source
 *			- tag
 *			- communicator
 *			- status (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */
int
lam_recv(buf, count, dtype, src, tag, comm, stat)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			src;
int			tag;
MPI_Comm		comm;
MPI_Status		*stat;

{
	int		err;
	struct _req	req_storage;
	MPI_Request	req;

	LAM_ZERO_ME(req_storage);
	req = &req_storage;
	err = _mpi_req_build(buf, count, dtype, 
				src, tag, comm, LAM_RQIRECV, &req);
	if (err != MPI_SUCCESS) return(err);

	req->rq_marks |= (LAM_RQFBLKTYPE | LAM_RQFMAND);

	err = _mpi_req_start(req);
	if (err != MPI_SUCCESS) return(err);

	_mpi_req_add_m(req);
	_mpi_req_blkclr_m();
	_mpi_req_blkset_m(req);

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(err);
	
	_mpi_req_rem_m(req);

	err = _mpi_req_end(req);
	if (err != MPI_SUCCESS) return(err);

	*stat = req->rq_status;

	err = _mpi_req_destroy(&req);
	if (err != MPI_SUCCESS) return(err);

	if (stat->MPI_ERROR != MPI_SUCCESS) {
		return(stat->MPI_ERROR);
	}

	return(MPI_SUCCESS);
}

/*
 *	lam_irecv
 *
 *	Function:	- internal immediate receive
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- source
 *			- tag
 *			- communicator
 *			- request (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */
int
lam_irecv(buf, count, dtype, src, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			src;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;			/* error code */

	*req = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, src, tag, comm,
			LAM_RQIRECV, req);
	if (err != MPI_SUCCESS) return(err);

	(*req)->rq_marks |= LAM_RQFMAND;

	err = _mpi_req_start(*req);
	if (err != MPI_SUCCESS) return(err);

	_mpi_req_add(*req);
	_mpi_req_blkclr();

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(err);

	return(MPI_SUCCESS);
}
