/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: gunion.c,v 6.3 1999/05/25 22:07:59 kmeyer1 Exp $
 *
 *	Function:	- form the union of two groups
 *	Accepts:	- first group
 *			- second group
 *			- ptr union group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>

int
MPI_Group_union(g1, g2, pgu)

MPI_Group		g1;
MPI_Group		g2;
MPI_Group		*pgu;

{
	int		i, j;			/* favourite indices */
	int		nproc;			/* # procs in union */
	struct _proc	**pi, **pj;		/* favourite pointers */
	MPI_Group	gu;			/* union group */

	lam_initerr_m();
	lam_setfunc_m(BLKMPIGROUPUNION);
/*
 * Check the arguments.
 */
	if ((g1 == MPI_GROUP_NULL) || (g2 == MPI_GROUP_NULL)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPUNION, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (pgu == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPUNION, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (g1->g_nprocs == 0) {
		*pgu = g2;
		g2->g_refcount++;
		lam_resetfunc_m(BLKMPIGROUPUNION);
		return(MPI_SUCCESS);
	}

	if (g2->g_nprocs == 0) {
		*pgu = g1;
		g1->g_refcount++;
		lam_resetfunc_m(BLKMPIGROUPUNION);
		return(MPI_SUCCESS);
	}
/*
 * Get the # of processes in the union.
 * Flag the duplicate processes in second group.
 */
	nproc = g1->g_nprocs + g2->g_nprocs;

	for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {

		for (j = 0, pj = g1->g_procs; j < g1->g_nprocs; ++j, ++pj) {

			if (*pi == *pj) {
				(*pi)->p_mode |= LAM_PFLAG;
				--nproc;
				break;
			}
		}
	}
/*
 * Allocate a new group.
 */
	gu = (MPI_Group) malloc((unsigned) sizeof(struct _group) +
					(nproc * sizeof(struct _proc *)));
	if (gu == 0) {
		for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		}

		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGROUPUNION,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pgu = gu;
	gu->g_myrank = MPI_UNDEFINED;
	gu->g_nprocs = nproc;
	gu->g_refcount = 1;
	gu->g_f77handle = -1;
	gu->g_procs = (struct _proc **) ((char *) gu + sizeof(struct _group));
/*
 * Fill the new group processes.
 */
	memcpy((char *) gu->g_procs, (char *) g1->g_procs,
				g1->g_nprocs * sizeof(struct _proc *));

	pj = gu->g_procs + g1->g_nprocs;

	for (i = 0, pi = g2->g_procs; i < g2->g_nprocs; ++i, ++pi) {

		if ((*pi)->p_mode & LAM_PFLAG) {
			(*pi)->p_mode &= ~LAM_PFLAG;
		} else {
			*pj = *pi;
			++pj;
		}
	}

	for (i = 0, pi = gu->g_procs; i < gu->g_nprocs; ++i, ++pi) {
		(*pi)->p_refcount++;
		if (*pi == lam_myproc) {
			gu->g_myrank = i;
		}
	}

	lam_resetfunc_m(BLKMPIGROUPUNION);
	return(MPI_SUCCESS);
}
