/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: sendrecv_f.c,v 6.4 1999/09/02 01:34:29 prijks Exp $
 *
 *	Function:	- MPI_Sendrecv F77 wrapper
 */

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_sendrecv_(sb, sc, st, d, stag, rb, rc, rt, s, rtag, c, fst, ierr)

char	*sb, *rb;
int	*sc, *st, *d, *stag;
int	*rc, *rt, *s, *rtag, *c, *fst, *ierr;

{
	MPI_Status	*stat;

	if ((void *) fst == lam_F_status_ignore) {
		stat = MPI_STATUS_IGNORE;
	} else if ((void *) fst == lam_F_statuses_ignore) {
		lam_setfunc(BLKMPISENDRECV);
		*ierr = lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0,
					"MPI_STATUSES_IGNORE");
		return;
	} else {
		stat = (MPI_Status *) fst;
	}

	*ierr = MPI_Sendrecv(BUF(sb), *sc, GETHDL(*st), *d, *stag,
			BUF(rb), *rc, GETHDL(*rt), *s, *rtag, GETHDL(*c), stat);
}
