//LabPlot : MainWin.cc

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include <qprinter.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qinputdialog.h>
#include <qimage.h>
#include <qcursor.h>
#include <qmessagebox.h>

#include <kpopupmenu.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kmessagebox.h>
#include <khelpmenu.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <kstatusbar.h>
#include <klibloader.h>
#include <ktrader.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kedittoolbar.h>
#include <kconfig.h>
#include <ktempfile.h>
#include <kdebug.h>
#include <kimageio.h>
#include <kfilterdev.h>
#include <kfilterbase.h>
#include <kmimetype.h>
#include <kshortcut.h>

#include "MainWin.h"
#include "GraphListDialog.h"
#include "ListPlotDialog.h"
#include "AxesDialog.h"
#include "TitleDialog.h"
#include "ExplorerDialog.h"
#include "FunctionDialog.h"
#include "LegendDialog.h"
#include "ObjectDialog.h"
#include "PlotSettingsDialog.h"
#include "ImportDialog.h"
#include "DataDialog.h"
#include "WorksheetDialog.h"
#include "OperationsListDialog.h"
#include "SmoothListDialog.h"

#include "AverageListDialog.h"
#include "PruneListDialog.h"
#include "CompressListDialog.h"
#include "PeriodicListDialog.h"
#include "SeasonalListDialog.h"
#include "HistListDialog.h"
#include "PeakListDialog.h"
#include "InterpolationListDialog.h"
#include "DifferencesListDialog.h"
#include "IntegrationListDialog.h"
#include "CapabilityListDialog.h"
#include "SummaryRListDialog.h"
#include "TestsRListDialog.h"
#include "RegressionListDialog.h"
#include "FFTListDialog.h"
#include "LaplaceTransformListDialog.h"
#include "ConvolutionListDialog.h"
#include "WaveletListDialog.h"
#include "HankelListDialog.h"
#include "FitListDialog.h"
#include "FilterListDialog.h"
#include "NoiseListDialog.h"
#include "CorrelationListDialog.h"
#include "ImageListDialog.h"

#include "ConfigureDialog.h"
#include "PstoEditDialog.h"
#include "ImageMagickDialog.h"
#include "ProjectDialog.h"
#include "ExplorerDialog.h"
#include "ArrangePlotDialog.h"
#include "OverlayPlotDialog.h"
#include "LabPlotDialog.h"

#include "ImportOPJ.h"

#ifdef HAVE_GL
#include "qwt3d_io.h"
#endif

#ifdef HAVE_QSA_FAC
#include "ModuleFactory.h"
#include "WrapperFactory.h"
#include <qsinputdialogfactory.h>
#endif

#include "parser_extern.h"
#include "pixmaps/pixmap.h"

using namespace std;

/*! This is the main window which controls all the dialogs */
MainWin::MainWin(const char *name, const char *filen, bool is_part)
	: KParts::MainWindow(0,name)
{
	kdDebug()<<"MainWin()"<<endl;
	project = new Project();
	QString fn(filen);
	if(fn.contains(".lml") || fn.contains(".xml"))
		project->setFilename(fn);
	else
		project->setFilename("");

	setCaption("LabPlot "LVERSION+i18n(" : ")+project->Filename());

	// register KImageIO formats for QImage and QPixmap
	KImageIO::registerFormats();

	config = KGlobal::config();
	applyMainWindowSettings(config,"LabPlotMainWindow");
	recent=0;	// needed for early closing

	QObject::disconnect(this,0,0,0);
	this->setMouseTracking(false);

#ifdef HAVE_R
	if(QString(getenv("R_HOME")).length()<1) {
		int ret = KMessageBox::warningContinueCancel( this,
			i18n("LabPlot was compiled with R but R_HOME is not defined! Disabling R interface."),i18n("Warning"));
		if (ret==KMessageBox::Cancel)
			exit();
		rif=0;
	}
	else
		rif = new RInterface();
#endif
	ws = new QWorkspace( this );	// LabPlot
	// Do we need this?  YES : changing from worksheet to spreadsheet !
	connect(ws,SIGNAL(windowActivated(QWidget *)),this,SLOT(windowActivated()));

	history = new History();

	setAcceptDrops(true);
	setupActions();
	statusBar()->message(i18n("Welcome to LabPlot ")+LVERSION);
	createGUI(0);

	// spreadsheet menu
	spreadsheetpopup = (QPopupMenu *) (factory()->container("Spreadsheet",this));
	connect(spreadsheetpopup , SIGNAL(aboutToShow()), this, SLOT(SpreadsheetMenu()) );

	setCentralWidget(ws);
	explorer_dialog = 0;
	legend_dialog = 0;
	title_dialog = 0;
	axes_dialog = 0;
	plotsettings_dialog = 0;
	worksheet_dialog = 0;
	object_dialog = 0;
	test_dialog = 0;

	// auto save
	autosaveTimer = new QTimer();
	connect(autosaveTimer,SIGNAL(timeout()),this,SLOT(autoSave()));

	// apply user settings (config)
	readConfig();

	New();
	if(!is_part)
		show();	// show MainWindow before evaluating script !

	// missing-menu-warning
	if(KGlobal::dirs()->findResource( "appdata", "LabPlotui.rc" ).isEmpty() && !is_part ) {
		int ret = KMessageBox::warningContinueCancel( this,
			i18n( "Could not build menus from config file!\n Please check your installation." ),i18n("Warning"));
		if (ret==KMessageBox::Cancel)
			exit();
	}

	// specified file not found
	if(!fn.isEmpty() && !QFile::exists(fn)) {
		int ret = KMessageBox::warningContinueCancel( this,
			i18n( "Could not open file \'%1\'!").arg(fn),i18n("Warning"));
		if (ret==KMessageBox::Cancel)
			exit();
	}

	// QSA
#ifdef HAVE_QSA
	qsproject = new QSProject(this);
#ifdef HAVE_QSA_FAC
	// add factories
	QSInterpreter *interpreter = qsproject->interpreter();
	kdDebug()<<"adding factories for scripting"<<endl;
	ModuleFactory *mfactory = new ModuleFactory(this,ws);
	WrapperFactory *wfactory = new WrapperFactory(this,ws);
	interpreter->addObjectFactory( mfactory );
	interpreter->addWrapperFactory( wfactory );

	interpreter->addObjectFactory(new QSInputDialogFactory);
#endif

#ifdef HAVE_QSA_IDE
	QMimeSourceFactory *fac =  QMimeSourceFactory::defaultFactory();
	QStringList filepath = fac->filePath();

	// workbench icons
	fac->setFilePath(locate("data","LabPlot/qsa-icons/"));

	ide = new QSWorkbench( qsproject, this );
#endif

	if(QFile::exists(fn) && fn.contains(".qs"))
		readScript(fn);
#endif

	if(QFile::exists(fn) && fn.contains(".lpl"))
		openLPL(fn);
	else if(QFile::exists(fn) && ( fn.contains(".lml") || fn.contains(".xml") ))
		openXML(fn);

	modified = false;
	is_fullscreen=false;

	sm = new QSignalMapper(this);
	connect(sm,SIGNAL(mapped(int)),this,SLOT(setActiveSheet(int)));
	smg = new QSignalMapper(this);
	connect(smg,SIGNAL(mapped(int)),this,SLOT(changeGraph(int)));

}

MainWin::~MainWin() {
	delete project;
	delete ws;
	delete history;

#ifdef HAVE_QSA
	delete qsproject;
#ifdef HAVE_QSA_IDE
	delete ide;
#endif
#endif

	delete sm;
	delete smg;
}

void MainWin::setupActions() {
	QPixmap saveAsIcon = QPixmap(saveAs_xpm);
	QPixmap projectIcon = QPixmap(project_xpm);
	QPixmap explorerIcon = QPixmap(explorer_xpm);
	QPixmap importIcon = QPixmap(import_xpm);
	QPixmap importopjIcon = KGlobal::iconLoader()->loadIcon("fileimport", KIcon::Toolbar);
	QPixmap exportIcon = QPixmap(export_xpm);
	QPixmap exportPsIcon = QPixmap(exportps_xpm);
	QPixmap exportIMIcon = QPixmap(exportim_xpm);
	QPixmap printpreviewIcon = KGlobal::iconLoader()->loadIcon("filequickprint", KIcon::Toolbar);
	QPixmap cloneIcon = QPixmap(clone_xpm);
	QPixmap spreadsheetIcon = QPixmap(spreadsheet_xpm);
	QPixmap worksheetIcon = QPixmap(worksheet_xpm);
	QPixmap plot2dIcon = QPixmap(plot2d_xpm);
	QPixmap plot3dIcon = QPixmap(plot3d_xpm);
	QPixmap plotQWT3DIcon = QPixmap(plotqwt3d_xpm);
	QPixmap plotsurfaceIcon = QPixmap(plotsurface_xpm);
	QPixmap plotpieIcon = QPixmap(plotpie_xpm);
	QPixmap plotpolarIcon = QPixmap(plotpolar_xpm);
	QPixmap plotternaryIcon = QPixmap(plotternary_xpm);
	QPixmap deletePlotIcon = QPixmap(deletePlot_xpm);
	QPixmap clearIcon = QPixmap(clear_xpm);
	QPixmap graphsIcon = QPixmap(list_graphs_xpm);
	QPixmap plotsIcon = QPixmap(list_plots_xpm);

	QPixmap newFunctionIcon = QPixmap(newFunction_xpm);
	QPixmap new3DFunctionIcon = QPixmap(new3DFunction_xpm);
	QPixmap newDataIcon = QPixmap(newData_xpm);
	QPixmap new3DDataIcon = QPixmap(new3DData_xpm);

	QPixmap evaluateIcon = QPixmap(evaluate_xpm);
	QPixmap operationsIcon = QPixmap(operations_xpm);
	QPixmap smoothIcon = QPixmap(smooth_xpm);
	QPixmap averageIcon = QPixmap(average_xpm);
	QPixmap compressIcon = QPixmap(compress_xpm);
	QPixmap pruneIcon = QPixmap(prune_xpm);
	QPixmap periodicIcon = QPixmap(periodic_xpm);
	QPixmap seasonalIcon = QPixmap(seasonal_xpm);
	QPixmap histIcon = QPixmap(histogram_xpm);
	QPixmap peakIcon = QPixmap(peak_xpm);
	QPixmap interpolationIcon = QPixmap(interpolation_xpm);
	QPixmap differencesIcon = QPixmap(differences_xpm);
	QPixmap integrationIcon = QPixmap(integration_xpm);
	QPixmap capabilityIcon = QPixmap(capability_xpm);
	QPixmap summaryIcon = QPixmap(rowstat_xpm);
	QPixmap testsIcon = QPixmap(tests_xpm);
	QPixmap regressionIcon = QPixmap(regression_xpm);
	QPixmap fftIcon = QPixmap(fft_xpm);
	QPixmap laplaceIcon = QPixmap(laplace_xpm);
	QPixmap convolutionIcon = QPixmap(convolution_xpm);
	QPixmap waveletIcon = QPixmap(wavelet_xpm);
	QPixmap hankelIcon = QPixmap(hankel_xpm);
	QPixmap fitIcon = QPixmap(fit_xpm);
	QPixmap filterIcon = KGlobal::iconLoader()->loadIcon("filter", KIcon::Toolbar);
	QPixmap correlationIcon = QPixmap(correlation_xpm);
	QPixmap noiseIcon = QPixmap(noise_xpm);
	QPixmap imageproIcon = QPixmap(imagepro_xpm);

	QPixmap graphIcon = QPixmap(graph_xpm);
	QPixmap arrangeIcon = QPixmap(arrange_xpm);
	QPixmap overlayIcon = QPixmap(overlay_xpm);
	QPixmap axesIcon = QPixmap(axes_xpm);
	QPixmap titleIcon = QPixmap(title_xpm);
	QPixmap legendIcon = QPixmap(legend_xpm);
	QPixmap objectIcon = QPixmap(object_xpm);

	QPixmap autoScaleXIcon = QPixmap(autoscalex_xpm);
	QPixmap autoScaleYIcon = QPixmap(autoscaley_xpm);
	QPixmap autoScaleZIcon = QPixmap(autoscalez_xpm);
	QPixmap autoScaleAllIcon = QPixmap(autoscaleall_xpm);
	QPixmap magLensIcon = QPixmap(mag_glass_xpm);
	QPixmap panZoomIcon = QPixmap(mousepan_xpm);
	QPixmap leftIcon = QPixmap(left_xpm);
	QPixmap rightIcon = QPixmap(right_xpm);
	QPixmap upIcon = QPixmap(up_xpm);
	QPixmap downIcon = QPixmap(down_xpm);
	QPixmap helpIcon = QPixmap(help_xpm);
	QPixmap examplesIcon = QPixmap(examples_xpm);

	QPixmap scriptIcon = QPixmap(script_xpm);
	QPixmap qsaIcon = QPixmap(qsa_xpm);
#if KDE_VERSION <= 0x030104
	QPixmap fullscreenIcon = KGlobal::iconLoader()->loadIcon("fullscreen", KIcon::Toolbar);
#endif
	QPixmap scaleXUpIcon = QPixmap(scalexup_xpm);
	QPixmap scaleXDownIcon = QPixmap(scalexdown_xpm);
	QPixmap scaleYUpIcon = QPixmap(scaleyup_xpm);
	QPixmap scaleYDownIcon = QPixmap(scaleydown_xpm);
	QPixmap scaleZUpIcon = QPixmap(scalezup_xpm);
	QPixmap scaleZDownIcon = QPixmap(scalezdown_xpm);
	QPixmap zoominIcon = QPixmap(zoomin_xpm);
	QPixmap zoomoutIcon = QPixmap(zoomout_xpm);
	QPixmap datamodeIcon = QPixmap(crosshair_xpm);
	QPixmap maskplotIcon = QPixmap(plotmask_xpm);

	QPixmap regionIcon = QPixmap(region_xpm);
	QPixmap baselineIcon = QPixmap(baseline_xpm);
	QPixmap lineIcon = QPixmap(line_xpm);
	QPixmap labelIcon = QPixmap(label_xpm);
	QPixmap rectIcon = QPixmap(rect_xpm);
	QPixmap ellipseIcon = QPixmap(ellipse_xpm);
	QPixmap imageIcon = QPixmap(image_xpm);

	QPixmap undoIcon = QPixmap(undo_xpm);
	QPixmap redoIcon = QPixmap(redo_xpm);

	// Action !
	KAction *tmp=0;	// for WhatsThis help

	KStdAction::open(this, SLOT(open()),actionCollection());
	KStdAction::openNew(this, SLOT(New()),actionCollection());
	recent = KStdAction::openRecent(this, SLOT(open(const KURL&)), actionCollection(), "openRecent");
	recent->loadEntries(config);
	recent->setMaxItems(config->readNumEntry("NrRecentFiles",10));

	save_action = KStdAction::save(this, SLOT(saveXML()),actionCollection());
	save_as = new KAction (i18n("S&ave As"), QIconSet(saveAsIcon),KShortcut(CTRL+SHIFT+Key_S), this,
		SLOT (saveAs()), actionCollection(),"saveAs");
	openLPL_action = new KAction (i18n("Open LPL"), QIconSet(importopjIcon),0, this,
		SLOT (openLPL()), actionCollection(),"openLPL");
	saveLPL_action = new KAction (i18n("S&ave As LPL"), QIconSet(saveAsIcon),0, this,
		SLOT (saveLPL()), actionCollection(),"saveLPL");
	project_action = new KAction (i18n("Project &Infos"), QIconSet(projectIcon),
			KShortcut(ALT+Key_V), this, SLOT (projectInfo()), actionCollection(),"project");
	explorer_action = new KAction (i18n("Pro&ject Explorer"), QIconSet(explorerIcon),
			KShortcut(CTRL+Key_Less), this, SLOT (projectExplorer()), actionCollection(),"explorer");

	import_action = new KAction (i18n("&Import ..."), QIconSet(importIcon),KShortcut(CTRL+SHIFT+Key_L), this,
		SLOT (importDialog()), actionCollection(),"import");

	importopj_action = new KAction (i18n("Import &OPJ project ..."), QIconSet(importopjIcon),KShortcut(CTRL+SHIFT+Key_J), this,
		SLOT (importOPJ()), actionCollection(),"importopj");

	export_image = new KAction (i18n("&Export to Image ..."), QIconSet(exportIcon),KShortcut(CTRL+Key_R), this,
		SLOT (exportPlot()), actionCollection(),"export");
	export_ps = new KAction (i18n("Postscript (PS)"), QIconSet(exportIcon),0, this,
		SLOT (exportPS()), actionCollection(),"export_ps");
	export_eps = new KAction (i18n("Encapsulated Postscript (EPS)"), QIconSet(exportIcon),0, this,
		SLOT (exportEPS()), actionCollection(),"export_eps");
	export_pdf = new KAction (i18n("Portable Document Format (PDF)"), QIconSet(exportIcon),0, this,
		SLOT (exportPDF()), actionCollection(),"export_pdf");
	export_svg = new KAction (i18n("scalable vector graphics (SVG)"), QIconSet(exportIcon),0, this,
		SLOT (exportSVG()), actionCollection(),"export_svg");
	export_pic = new KAction (i18n("native QPicture format (PIC)"), QIconSet(exportIcon),0, this,
		SLOT (exportPIC()), actionCollection(),"export_pic");

	export_pstoedit = new KAction (i18n("E&xport via pstoedit ..."), QIconSet(exportPsIcon),KShortcut(ALT+Key_E), this,
		SLOT (exportPstoEditDialog()), actionCollection(),"export_pstoedit");
	export_ImageMagick = new KAction (i18n("Export via Image&Magick ..."), QIconSet(exportIMIcon),
		KShortcut(CTRL+SHIFT+Key_I), this,SLOT (exportImageMagickDialog()), actionCollection(),"export_ImageMagick");

	print_action = KStdAction::print(this, SLOT(print()),actionCollection(),"print");
	printpreview = new KToggleAction(i18n("Pri&nt Preview"), QIconSet(printpreviewIcon),KShortcut(ALT+Key_P),
		this, SLOT(printPreview()),actionCollection(),"print_preview");
	printpreviewchecked=false;
	KStdAction::quit(this, SLOT(close()),actionCollection());

	tmp = new KAction (i18n("&New 2D Plot"), QIconSet(plot2dIcon),
			KShortcut(CTRL+SHIFT+Key_N), this, SLOT (new2DPlot()), actionCollection(),"new2DPlot");
	tmp->setWhatsThis(i18n("This adds an empty 2 dimensional plot"));
	tmp = new KAction (i18n("New &Surface Plot"), QIconSet(plotsurfaceIcon),
			KShortcut(ALT+Key_Z), this, SLOT (newSurfacePlot()), actionCollection(),"newSurfacePlot");
	tmp->setWhatsThis(i18n("This adds an empty surface plot"));
	tmp = new KAction (i18n("N&ew 3D Plot"), QIconSet(plot3dIcon),
			KShortcut(CTRL+Key_0), this, SLOT (new3DPlot()), actionCollection(),"new3DPlot");
	qwt3d_plot = new KAction (i18n("New &QWT 3D Plot"), QIconSet(plotQWT3DIcon),
			KShortcut(CTRL+SHIFT+Key_Q), this, SLOT (newQWT3DPlot()), actionCollection(),"newQWT3DPlot");
	qwt3d_plot->setWhatsThis(i18n("This adds an empty 3 dimensional qwt plot"));
	tmp->setWhatsThis(i18n("This adds an empty 3 dimensional plot"));
	tmp = new KAction (i18n("Ne&w Pie Plot"), QIconSet(plotpieIcon),
			KShortcut(ALT+Key_Period), this, SLOT (newPiePlot()), actionCollection(),"newPiePlot");
	tmp->setWhatsThis(i18n("This adds an empty pie plot"));
	tmp = new KAction (i18n("New Polar Plot"), QIconSet(plotpolarIcon),
			KShortcut(CTRL+SHIFT+Key_O), this, SLOT (newPolarPlot()), actionCollection(),"newPolarPlot");
	tmp->setWhatsThis(i18n("This adds an empty polar plot"));
	tmp = new KAction (i18n("New Ternary Plot"), QIconSet(plotternaryIcon),
			KShortcut(CTRL+SHIFT+Key_T), this, SLOT (newTernaryPlot()), actionCollection(),"newTernaryPlot");
	tmp->setWhatsThis(i18n("This adds an empty ternary plot"));
	deleteplot = new KAction (i18n("&Delete Active Plot"), QIconSet(deletePlotIcon),
			KShortcut(ALT+Key_Q), this, SLOT (deletePlot()), actionCollection(),"deletePlot");
	tmp = new KAction (i18n("Clone Active Sheet"), QIconSet(cloneIcon),
			KShortcut(ALT+Key_Greater), this, SLOT (cloneActiveSheet()), actionCollection(),"cloneSheet");
	tmp = new KAction (i18n("New S&preadsheet"), QIconSet(spreadsheetIcon),
			KShortcut(CTRL+Key_Equal), this, SLOT (newSpreadsheet()), actionCollection(),"newSpreadsheet");
	tmp->setWhatsThis(i18n("This opens a new spreadsheet"));
	tmp = new KAction (i18n("New W&orksheet"), QIconSet(worksheetIcon),
			KShortcut(ALT+Key_X), this, SLOT (newWorksheet()), actionCollection(),"newWorksheet");
	tmp->setWhatsThis(i18n("This opens a new empty 2 dimensional worksheet"));
	deleteplot->setWhatsThis(i18n("This deletes the active plot"));
	tilesheets = new KAction (i18n("Arrange Sheets (Tile)"), QIconSet(worksheetIcon),
			0, this, SLOT (tileSheets()), actionCollection(),"tileSheets");
	cascadesheets = new KAction (i18n("Arrange Sheets (Cascade)"), QIconSet(worksheetIcon),
			0, this, SLOT (cascadeSheets()), actionCollection(),"cascadeSheets");
	tileworksheets = new KAction (i18n("Arrange Worksheets (Tile)"), QIconSet(worksheetIcon),
			0, this, SLOT (tileWorksheets()), actionCollection(),"tileWorksheets");
	cascadeworksheets = new KAction (i18n("Arrange Worksheets (Cascade)"), QIconSet(worksheetIcon),
			0, this, SLOT (cascadeWorksheets()), actionCollection(),"cascadeWorksheets");

	clear_action = new KAction (i18n("Clea&r"), QIconSet(clearIcon),
			KShortcut(CTRL+Key_X), this, SLOT (clear()), actionCollection(),"clear");
	clear_action->setWhatsThis(i18n("This clears the active worksheet"));
	close_action = KStdAction::close(this, SLOT(closeWin()),actionCollection(),"my_close");
	close_action->setWhatsThis(i18n("This closes the active worksheet or the print preview"));

	graph_list = new KAction (i18n("&Graph List"), QIconSet(graphsIcon),
			KShortcut(CTRL+Key_G), this, SLOT (graphDialog()), actionCollection(),"graphs");
	graph_list->setWhatsThis(i18n("This opens a list of all graphs in the active worksheet"));
	plot_list = new KAction (i18n("&Plot List"), QIconSet(plotsIcon),
			KShortcut(CTRL+SHIFT+Key_Period), this, SLOT (plotDialog()),actionCollection(),"plots");
	tmp = new KAction (i18n("2D &Function"), QIconSet(newFunctionIcon),
			KShortcut(CTRL+Key_E), this, SLOT (new2DFunction()), actionCollection(),"newFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new 2 dimensional function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D &Surface Function"), QIconSet(plotsurfaceIcon),
			KShortcut(CTRL+Key_U), this, SLOT (newSFunction()), actionCollection(),"newSFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new surface function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D Polar Function"), QIconSet(plotpolarIcon),
			KShortcut(ALT+Key_Less), this, SLOT (newPolarFunction()), actionCollection(),"newPolarFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new polar function in the active worksheet or in a new worksheet"));
	qwt3d_func = new KAction (i18n("3D QWT Function"), QIconSet(plotQWT3DIcon),
			KShortcut(ALT+Key_Equal), this, SLOT (newQWT3DFunction()), actionCollection(),"newQWT3DFunction");
	qwt3d_func->setWhatsThis(i18n("This lets you insert a new 3d qwt function in the active worksheet or in a new worksheet"));

	tmp = new KAction (i18n("2D &Data"), QIconSet(newDataIcon),
			KShortcut(CTRL+Key_D), this, SLOT (new2DData()),actionCollection(),"newData" );
	tmp->setWhatsThis(i18n("This lets you insert new 2 dimensional data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D S&urface Data"), QIconSet(plotsurfaceIcon),
			KShortcut(ALT+Key_Minus), this, SLOT (newSData()), actionCollection(),"newSData");
	tmp->setWhatsThis(i18n("This lets you insert a new surface graph from data in the active plot"));
	tmp = new KAction (i18n("&Pie Data"), QIconSet(plotpieIcon),
			KShortcut(ALT+Key_Comma), this, SLOT (newPieData()),actionCollection(),"newPieData" );
	tmp->setWhatsThis(i18n("This lets you insert a new pie graph from data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("Polar Data"), QIconSet(plotpolarIcon),
			KShortcut(CTRL+Key_Comma), this, SLOT (newPolarData()),actionCollection(),"newPolarData" );
	tmp->setWhatsThis(i18n("This lets you insert a new polar graph from data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("Ternary Data"), QIconSet(plotternaryIcon),
			KShortcut(CTRL+SHIFT+Key_Y), this, SLOT (newTernaryData()),actionCollection(),"newTernaryData" );
	tmp->setWhatsThis(i18n("This lets you insert a new ternary graph from data in the active worksheet or in a new worksheet"));

	tmp = new KAction (i18n("3D F&unction"), QIconSet(new3DFunctionIcon),
			KShortcut(CTRL+Key_F), this, SLOT (new3DFunction()),actionCollection(),"new3DFunction" );
	tmp->setWhatsThis(i18n("This lets you insert a new 3 dimensional function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("3D D&ata"), QIconSet(new3DDataIcon),
			KShortcut(CTRL+Key_I), this, SLOT (new3DData()), actionCollection(),"new3DData");
	tmp->setWhatsThis(i18n("This lets you insert new 3 dimensional data in the active worksheet or in a new worksheet"));
	qwt3d_data = new KAction (i18n("&QWT 3D Data"), QIconSet(plotQWT3DIcon),
			KShortcut(CTRL+SHIFT+Key_B), this, SLOT (newQWT3DData()),actionCollection(),"newQWT3DData");
	qwt3d_data->setWhatsThis(i18n("This lets you insert new 3 dimensional data in the active QWT plot"));

	togglespeedmode = KStdAction::showToolbar(this,SLOT(toggleSpeedMode()),actionCollection(),"toggleSpeedMode");
	togglespeedmode->setText(i18n("Speed Plot Mode"));

	evaluate =  new KAction (i18n("&Evaluate equation"), QIconSet(evaluateIcon),
			KShortcut(CTRL+Key_NumberSign), this, SLOT (evaluateDialog()),actionCollection(),"evaluate");
	operations = new KAction (i18n("&Data set operations"), QIconSet(operationsIcon),
			KShortcut(CTRL+SHIFT+Key_D), this, SLOT (operationsDialog()),actionCollection(),"operations");
	smooth = new KAction (i18n("&Smooth"), QIconSet(smoothIcon),
			KShortcut(ALT+Key_S), this, SLOT (smoothDialog()),actionCollection(),"smooth");
	prune = new KAction (i18n("&Prune"), QIconSet(pruneIcon),
			KShortcut(ALT+Key_R), this, SLOT (pruneDialog()),actionCollection(),"prune");
	average = new KAction (i18n("&Average"), QIconSet(averageIcon),
			KShortcut(ALT+Key_A), this, SLOT (averageDialog()),actionCollection(),"average");
	compress = new KAction (i18n("&Compress"), QIconSet(compressIcon),
			KShortcut(CTRL+SHIFT+Key_H), this, SLOT(compressDialog()),actionCollection(),"compress");
	periodic = new KAction (i18n("&Periodic Functions"), QIconSet(periodicIcon),
			KShortcut(CTRL+SHIFT+Key_K), this, SLOT(periodicDialog()),actionCollection(),"periodic");
	seasonal = new KAction (i18n("&Seasonal"), QIconSet(seasonalIcon),
			KShortcut(CTRL+SHIFT+Key_U), this, SLOT (seasonalDialog()),actionCollection(),"seasonal");
	hist = new KAction (i18n("&Histogram"), QIconSet(histIcon),
			KShortcut(ALT+Key_H), this, SLOT (histDialog()),actionCollection(),"histogram");
	peak = new KAction (i18n("&Peak find"), QIconSet(peakIcon),
			KShortcut(CTRL+SHIFT+Key_X), this, SLOT (peakDialog()),actionCollection(),"peak");
	interpolation = new KAction (i18n("In&terpolation"), QIconSet(interpolationIcon),
			KShortcut(ALT+Key_I), this, SLOT (interpolationDialog()),actionCollection(),"interpolation");
	differences = new KAction (i18n("&Differences"), QIconSet(differencesIcon),
			KShortcut(ALT+Key_D), this, SLOT (differencesDialog()),actionCollection(),"differences");
	integration = new KAction (i18n("&Integration"), QIconSet(integrationIcon),
			KShortcut(ALT+Key_N), this, SLOT (integrationDialog()),actionCollection(),"integration");
	regression = new KAction (i18n("&Regression"), QIconSet(regressionIcon),
			KShortcut(ALT+Key_L), this, SLOT (regressionDialog()),actionCollection(),"regression");
	fft = new KAction (i18n("&Fourier Transform"), QIconSet(fftIcon),
			KShortcut(ALT+Key_F), this, SLOT (fftDialog()),actionCollection(),"fft");
	laplace = new KAction (i18n("&Laplace Transform"), QIconSet(laplaceIcon),
			KShortcut(CTRL+SHIFT+Key_Semicolon), this, SLOT (laplaceDialog()),actionCollection(),"laplace");
	convolution = new KAction (i18n("&Convolution / Deconvolution"), QIconSet(convolutionIcon),
			KShortcut(ALT+Key_C), this, SLOT (convolutionDialog()),actionCollection(),"convolution");
	wavelet = new KAction (i18n("&Wavelet Transform"), QIconSet(waveletIcon),
			KShortcut(CTRL+SHIFT+Key_Less), this, SLOT (waveletDialog()),actionCollection(),"wavelet");
	hankel = new KAction (i18n("&Hankel Transform"), QIconSet(hankelIcon),
			KShortcut(CTRL+SHIFT+Key_Greater), this, SLOT (hankelDialog()),actionCollection(),"hankel");
	fit = new KAction (i18n("&Nonlinear Fit"), QIconSet(fitIcon),
			KShortcut(ALT+Key_T), this, SLOT (fitDialog()),actionCollection(),"fit");
	filter = new KAction (i18n("&Signal Filter"), QIconSet(filterIcon),
			KShortcut(ALT+Key_NumberSign), this, SLOT (filterDialog()),actionCollection(),"filter");
	noise = new KAction (i18n("&Noise Addition"), QIconSet(noiseIcon),
			KShortcut(ALT+Key_Plus), this, SLOT (noiseDialog()),actionCollection(),"noise");
	correl = new KAction (i18n("&Auto- / Crosscorrelation"), QIconSet(correlationIcon),
			KShortcut(CTRL+Key_Plus), this, SLOT (correlDialog()),actionCollection(),"correlation");
	imagepro = new KAction (i18n("Ima&ge Manipulation"), QIconSet(imageproIcon),
			KShortcut(CTRL+SHIFT+Key_G), this, SLOT (imageDialog()),actionCollection(),"imagepro");
	capability = new KAction (i18n("&Capability Analysis"), QIconSet(capabilityIcon),
			KShortcut(ALT+Key_Semicolon), this, SLOT (capabilityDialog()),actionCollection(),"capability");
	summary = new KAction (i18n("&Summary"), QIconSet(summaryIcon),
			0, this, SLOT (summaryDialog()),actionCollection(),"summary");
	tests = new KAction (i18n("&Tests"),QIconSet(testsIcon),
			0, this, SLOT (testsDialog()),actionCollection(),"tests");

	arrange = new KAction (i18n("&Arrange Plots"), QIconSet(arrangeIcon),
			KShortcut(ALT+Key_Y), this, SLOT (arrangeDialog()),actionCollection(),"arrange");
	arrange->setWhatsThis(i18n("This lets you arrange the plots of the active worksheet"));
	overlay = new KAction (i18n("&Overlay Plots"), QIconSet(overlayIcon),
			KShortcut(CTRL+Key_Minus), this, SLOT (overlayDialog()),actionCollection(),"overlay");
	arrange->setWhatsThis(i18n("This lets you arrange the plots of the active worksheet"));
	worksheet_action = new KAction (i18n("&Worksheet Settings"), QIconSet(worksheetIcon),
			KShortcut(ALT+Key_W), this, SLOT (worksheetDialog()),actionCollection(),"worksheet");
	worksheet_action->setWhatsThis(i18n("This lets you change the settings of the active worksheet"));
	plot_action = new KAction (i18n("&Plot Settings"), QIconSet(graphIcon),
			KShortcut(CTRL+Key_J), this, SLOT (plotSettingsDialog()),actionCollection(),"plot");
	plot_action->setWhatsThis(i18n("This lets you change the settings of the active plot"));
	axes = new KAction (i18n("&Axes Settings"), QIconSet(axesIcon),
			KShortcut(CTRL+Key_B), this, SLOT (axesDialog()),actionCollection(),"axes");
	title_action = new KAction (i18n("&Title Settings"), QIconSet(titleIcon),
			KShortcut(CTRL+Key_T), this, SLOT (titleDialog()), actionCollection(),"title");
	legend = new KAction (i18n("&Legend Settings"), QIconSet(legendIcon),
			KShortcut(CTRL+Key_L), this, SLOT (legendDialog()),actionCollection(),"legend");
	objects = new KAction (i18n("&Drawing Objects"), QIconSet(objectIcon),
			KShortcut(ALT+Key_O), this, SLOT (objectDialog()),actionCollection(),"objects");

#if KDE_VERSION > 0x030104
	tmp = KStdAction::fullScreen(this, SLOT( toggleFullScreen() ), actionCollection(),this, "fullscreen");
#else
	tmp = new KToggleAction( i18n( "Full Screen" ), fullscreenIcon, KShortcut(CTRL+SHIFT+Key_F),
	    this, SLOT( toggleFullScreen() ), actionCollection(), "fullscreen" );
#endif
	tmp->setToolTip( i18n( "View this document full-screen." ) );
	tmp->setWhatsThis( i18n( "View this document full-screen." ) );

	menubar = KStdAction::showMenubar(this, SLOT(toggleMenuBar()), actionCollection(),"showMenuBar");
	toolbar = KStdAction::showToolbar(this, SLOT(toggleToolBar()), actionCollection(),"showToolBar");
	sidetoolbar = KStdAction::showToolbar(this, SLOT(toggleSideToolBar()), actionCollection(),"showSideToolBar");
	sidetoolbar->setText(i18n("Show S&ide Toolbar"));
	analysistoolbar = KStdAction::showToolbar(this,
		SLOT(toggleAnalysisToolBar()),actionCollection(),"showAnalysisToolBar");
	analysistoolbar->setText(i18n("Show A&nalysis Toolbar"));
	drawingtoolbar = KStdAction::showToolbar(this,
		SLOT(toggleDrawingToolBar()),actionCollection(),"showDrawingToolBar");
	drawingtoolbar->setText(i18n("Show &Drawing Toolbar"));
	statusbar = KStdAction::showStatusbar(this, SLOT(toggleStatusBar()), actionCollection(),"showStatusBar");

	KStdAction::keyBindings(this, SLOT(configureKeys()), actionCollection(),"configureKeys");
	KStdAction::configureToolbars(this, SLOT(configureToolbars()), actionCollection(),"configureToolbars");
	configureAction = KStdAction::preferences(this, SLOT(configure()), actionCollection(),"configure");

	new KAction (i18n("&Save Settings"), QIconSet(legendIcon),
			KShortcut(CTRL+Key_Period), this, SLOT (saveSettings()),actionCollection(),"saveSettings");

	scriptAction = new KAction (i18n("&Load Script ..."), QIconSet(scriptIcon),
			KShortcut(CTRL+SHIFT+Key_C), this, SLOT (loadScript()),actionCollection(),"loadScript");
	ideAction = new KAction (i18n("&QSA Workbench ..."), QIconSet(qsaIcon),
			KShortcut(CTRL+SHIFT+Key_W), this, SLOT (openIDE()),actionCollection(),"openIDE");

	// Help menu
	const KAboutData *aboutData = KGlobal::instance()->aboutData();
	KHelpMenu *help_menu = new KHelpMenu( this, aboutData);
	(void) new KAction(i18n("LabPlot Handbook"),"contents",0 , this, SLOT(appHelpActivated()), actionCollection(),"handbook" );
	(void) KStdAction::whatsThis(help_menu, SLOT(contextHelpActivated()), actionCollection(),"whatsthis");
	(void) KStdAction::aboutKDE(help_menu, SLOT(aboutKDE()), actionCollection(),"aboutKDE");
	(void) KStdAction::aboutApp(help_menu, SLOT(aboutApplication()), actionCollection(),"aboutLabPlot");
	(void) KStdAction::reportBug(help_menu, SLOT(reportBug()), actionCollection(),"reportBug");
	new KAction (i18n("&LabPlot Environment"), QIconSet(projectIcon),
			KShortcut(CTRL+SHIFT+Key_E), this, SLOT (Environment()),actionCollection(),"environment");
	setHelpMenuEnabled(false);

	new KAction (i18n("&Axes Label"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAxesLabel()),actionCollection(),"axeslabel");
	new KAction (i18n("&Analysis"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAnalysis()),actionCollection(),"analysis");
	new KAction (i18n("&Surface"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleSurface()),actionCollection(),"surface");
	new KAction (i18n("&3 d"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (example3d()),actionCollection(),"3d");
	new KAction (i18n("&Rydberg spectra"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleRydberg()),actionCollection(),"rydberg");
	new KAction (i18n("&Log axis scale"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleLog()),actionCollection(),"log");
	new KAction (i18n("&simple FFT"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleFFT()),actionCollection(),"simple_fft");
	new KAction (i18n("&Drawing objects"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleObjects()),actionCollection(),"objects_example");
	new KAction (i18n("&Histogram"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleHist()),actionCollection(),"hist_example");
	new KAction (i18n("&Nonlinear fitting"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleFit()),actionCollection(),"fit_example");
	new KAction (i18n("&Reading images"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleImage()),actionCollection(),"image_example");
	new KAction (i18n("&Pie Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (examplePie()),actionCollection(),"pie_example");
	new KAction (i18n("P&olar Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (examplePolar()),actionCollection(),"polar_example");
	new KAction (i18n("&Ternary Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleTernary()),actionCollection(),"ternary_example");
	new KAction (i18n("&Exponential Fit"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleExponentialFit()),actionCollection(),"exponential_fit_example");
	new KAction (i18n("&Multiple Plots"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleMultiplot()),actionCollection(),"multiplot_example");
	new KAction (i18n("&Another Surface Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleSurface2()),actionCollection(),"surface2_example");
	new KAction (i18n("&Reading Audio data"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAudio()),actionCollection(),"audio_example");
	new KAction (i18n("&QWT 3D plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleQWT()),actionCollection(),"qwt_example");
	new KAction (i18n("&Bar plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleBar()),actionCollection(),"bar_example");
	new KAction (i18n("&Log fit"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleLogfit()),actionCollection(),"logfit_example");
	new KAction (i18n("&Marker"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleMarker()),actionCollection(),"marker_example");
	new KAction (i18n("&Surface Styles"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleSurfaceStyle()),actionCollection(),"surfacestyle_example");
	new KAction (i18n("&TeX Label"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleTeXLabel()),actionCollection(),"texlabel_example");

	asx = new KAction (i18n("autoscale &x"), QIconSet(autoScaleXIcon),
			KShortcut(CTRL+Key_Greater), this, SLOT (autoScaleX()), actionCollection(),"autoscaleX");
	asy = new KAction (i18n("autoscale &y"), QIconSet(autoScaleYIcon),
			KShortcut(CTRL+Key_Y), this, SLOT (autoScaleY()), actionCollection(),"autoscaleY");
	asz = new KAction (i18n("autoscale &z"), QIconSet(autoScaleZIcon),
			0, this, SLOT (autoScaleZ()), actionCollection(),"autoscaleZ");
	asall = new KAction (i18n("autoscale &all"), QIconSet(autoScaleAllIcon),
			KShortcut(CTRL+SHIFT+Key_A), this, SLOT (autoScaleAll()), actionCollection(),"autoscaleAll");
	maglens = new KAction (i18n("&magnify lens"), QIconSet(magLensIcon),
			KShortcut(CTRL+SHIFT+Key_M), this, SLOT (magLens()), actionCollection(),"magLens");
	panzoom = new KAction (i18n("&pan zoom"), QIconSet(panZoomIcon),
			KShortcut(CTRL+SHIFT+Key_P), this, SLOT (panZoom()), actionCollection(),"panZoom");
	maskplot = new KAction (i18n("&mask data"), QIconSet(maskplotIcon),
			KShortcut(CTRL+SHIFT+Key_NumberSign), this, SLOT (maskPlot()), actionCollection(),"maskPlot");

	sl = new KAction (i18n("shift &left"), QIconSet(leftIcon),
			KShortcut(Key_Left), this, SLOT (shiftLeft()), actionCollection(),"shiftleft");
	sr = new KAction (i18n("shift &right"), QIconSet(rightIcon),
			KShortcut(Key_Right), this, SLOT (shiftRight()), actionCollection(),"shiftright");

	su = new KAction (i18n("shift &up"), QIconSet(upIcon),
			KShortcut(Key_Up), this, SLOT (shiftUp()), actionCollection(),"shiftup");
	sd = new KAction (i18n("shift &down"), QIconSet(downIcon),
			KShortcut(Key_Down), this, SLOT (shiftDown()),actionCollection(),"shiftdown" );
	sxu = new KAction (i18n("scale x u&p"), QIconSet(scaleXUpIcon),
			KShortcut(Key_Plus), this, SLOT (scaleXUp()), actionCollection(),"scalexup");
	sxd = new KAction (i18n("scale x d&own"), QIconSet(scaleXDownIcon),
			KShortcut(Key_Minus), this, SLOT (scaleXDown()), actionCollection(),"scalexdown");
	syu = new KAction (i18n("&scale y up"), QIconSet(scaleYUpIcon),
			KShortcut(CTRL+Key_Plus), this, SLOT (scaleYUp()),actionCollection(),"scaleyup" );
	syd = new KAction (i18n("s&cale y down"), QIconSet(scaleYDownIcon),
			KShortcut(CTRL+Key_Minus), this, SLOT (scaleYDown()),actionCollection(),"scaleydown" );
	szu = new KAction (i18n("sc&ale z up"), QIconSet(scaleZUpIcon),
			KShortcut(ALT+Key_Plus), this, SLOT (scaleZUp()), actionCollection(),"scalezup");
	szd = new KAction (i18n("sca&le z down"), QIconSet(scaleZDownIcon),
			KShortcut(ALT+Key_Minus), this, SLOT (scaleZDown()), actionCollection(),"scalezdown");
	zoomin = new KAction (i18n("zoom in"), QIconSet(zoominIcon),
			KShortcut(CTRL+SHIFT+Key_Plus), this, SLOT (zoomIn()),actionCollection(),"zoomin");
	zoomout = new KAction (i18n("zoom out"), QIconSet(zoomoutIcon),
			KShortcut(CTRL+SHIFT+Key_Minus), this, SLOT (zoomOut()),actionCollection(),"zoomout");
	toggledatamode = new KToggleAction(i18n("&Data mode"), QIconSet(datamodeIcon),KShortcut(CTRL+SHIFT+Key_V),
		this, SLOT(toggleDataMode()),actionCollection(),"datamode");
	datamode=false;

	baseline = new KAction (i18n("Create &Baseline"), QIconSet(baselineIcon),
			KShortcut(ALT+Key_B), this, SLOT (defineBaseline()), actionCollection(),"baseline");
	region = new KAction (i18n("Create &Region"), QIconSet(regionIcon),
			KShortcut(ALT+Key_G), this, SLOT (defineRegion()), actionCollection(),"region");
	line = new KAction (i18n("Create &Line"), QIconSet(lineIcon),
			KShortcut(ALT+Key_J), this, SLOT (defineLine()), actionCollection(),"line");
	label = new KAction (i18n("Create L&abel"), QIconSet(labelIcon),
			KShortcut(ALT+Key_K), this, SLOT (defineLabel()), actionCollection(),"label");
	rect = new KAction (i18n("Create Re&ctangle"), QIconSet(rectIcon),
			KShortcut(CTRL+SHIFT+Key_R), this, SLOT (defineRect()), actionCollection(),"rect");
	ellipse = new KAction (i18n("Create &Ellipse"), QIconSet(ellipseIcon),
			KShortcut(ALT+Key_U), this, SLOT (defineEllipse()), actionCollection(),"ellipse");
	image = new KAction (i18n("Create &Image"), QIconSet(imageIcon),
			KShortcut(ALT+Key_M), this, SLOT (defineImage()), actionCollection(),"image");

	nextwindow_action = new KAction (i18n("Next Window"),QIconSet(worksheetIcon),KShortcut(Key_F6), ws,
		SLOT (activateNextWindow()), actionCollection(),"nextwindow");
	prevwindow_action = new KAction (i18n("Previous Window"),QIconSet(worksheetIcon),KShortcut(Key_F5), ws,
		SLOT (activatePrevWindow()), actionCollection(),"prevwindow");
	// TODO : icons+shortcuts
	undo_action = new KAction (i18n("Undo"),QIconSet(undoIcon),KShortcut(CTRL+Key_Z), this,
		SLOT (undoAction()), actionCollection(),"undo");
	redo_action = new KAction (i18n("Redo"),QIconSet(redoIcon),KShortcut(CTRL+SHIFT+Key_Z), this,
		SLOT (redoAction()), actionCollection(),"redo");

}


// return 1 if canceled
bool MainWin::warnModified() {
	QWidgetList list = ws->windowList();

	if(int(list.count()) > 0 && modified) {
		int want_save = KMessageBox::warningYesNoCancel( this,
			i18n("The current project has been modified.\nDo you want to save it?"),
			i18n("Save Project"));
		switch (want_save) {
		case KMessageBox::Yes:
			saveXML();
			break;
		case KMessageBox::No:
			break;
		case KMessageBox::Cancel:
			return 1;
			break;
		}
	}

	modified=false;
	return 0;
}

void MainWin::closeEvent(QCloseEvent *e) {
	kdDebug()<<"MainWin::closeEvent()"<<endl;
	if(config != 0 && recent != 0) recent->saveEntries(config);

	if (warnModified()) return;

	// HACK : delete all LabPlot temp files
	KStandardDirs *stddirs = KGlobal::dirs();
	QStringList files = stddirs->findAllResources("tmp",QString("LabPlot*"));
	for ( QStringList::Iterator it = files.begin(); it != files.end(); ++it ) {
		QFile file(*it);
		QFileInfo fileinfo(file);
		QString ext = fileinfo.extension();
		if (ext != "lml.gz" || file.size()==0) file.remove();	// do not remove project files (backup)
	}

	kdDebug()<<"	accept()"<<endl;
	e->accept();
	kdDebug()<<"MainWin::closeEvent() DONE"<<endl;
}

void MainWin::mouseDoubleClickEvent(QMouseEvent *) {
	if(!menuBar()->isVisible())
		menuBar()->show();
	else
		newSpreadsheet();
}

void MainWin::readScript(QString fn) {
	kdDebug()<<"MainWin::readScript() : filename="<<fn<<endl;
#ifdef HAVE_QSA
	QSInterpreter *interpreter = qsproject->interpreter();

	if(QFile::exists(fn) && fn.contains(".qs")) {
		QFile file(fn);
		if(!file.open(IO_ReadOnly)) {
			kdDebug()<<"Error reading script file "<<fn<<endl;
		}
		QTextStream str(&file);
		QString code = str.read();

		kdDebug()<<"	INTERPRETER clear()"<<endl;
		if(interpreter == 0)
			kdDebug()<<"INTERPRETER == 0 !!!"<<endl;
		interpreter->clear();

		// remove spreadsheet object (needed to use Spreadsheet in script :-()
		QObject *sobject=0;
		if (( sobject = this->child("Spreadsheet","QObject",true)) != 0)
			removeChild(sobject);

		// evaluate init script with enum definitions
		QString initfn = KGlobal::dirs()->findResource( "appdata", "labplot.qs" );
		if(initfn==0) {
			kdDebug()<<"	no labplot.qs found !"<<endl;
		}
		else {
			QFile initfile(initfn);
			if(!initfile.open(IO_ReadOnly)) {
				kdDebug()<<"Error reading init script file "<<initfn<<endl;
			}
			else {
				QTextStream initstr(&initfile);
				QString initcode = initstr.read();
				kdDebug()<<"	INTERPRETER evaluate() init script "<<initfn<<endl;
				interpreter->evaluate(initcode,this,initfn);
			}
		}

		kdDebug()<<"	INTERPRETER evaluate() script "<<fn<<endl;
		interpreter->evaluate(code,this,fn);

		// print out all values
		kdDebug()<<"	Functions :"<<endl;
		QStringList funcs =  interpreter->functions("MainWin",QSInterpreter::IncludeMemberFunctions);
		for ( QStringList::Iterator it = funcs.begin(); it != funcs.end(); ++it ) {
			kdDebug() << *it <<endl;
		}

		kdDebug()<<"	Classes :"<<endl;
		QStringList classes =  interpreter->classes("MainWin");
		for ( QStringList::Iterator it = classes.begin(); it != classes.end(); ++it ) {
			kdDebug() << *it <<endl;
		}

		kdDebug()<<"	Variables :"<<endl;
		QStringList vars =  interpreter->variables();
		for ( QStringList::Iterator it = vars.begin(); it != vars.end(); ++it ) {
			kdDebug() << *it <<endl;
		}
	}
#endif
}

void MainWin::readConfig() {
	kdDebug()<<"MainWin::readConfig()"<<endl;
	config->setGroup( "General Options" );
	resize(config->readNumEntry("Width",780),config->readNumEntry("Height",540));

	if (! config->readBoolEntry("MenubarEnabled",true))
		menuBar()->hide();
	menubar->setChecked(config->readBoolEntry("MenubarEnabled", true));

	if (! config->readBoolEntry("ToolbarEnabled",true))
		toolBar()->hide();
	toolbar->setChecked(config->readBoolEntry("ToolbarEnabled", true));

	if (! config->readBoolEntry("SideToolbarEnabled",true))
		toolBar("actions")->hide();
	sidetoolbar->setChecked(config->readBoolEntry("SideToolbarEnabled", true));

	toolBar("analysis")->hide();
	if (config->readBoolEntry("AnalysisToolbarEnabled",false))
		toolBar("analysis")->show();
	analysistoolbar->setChecked(config->readBoolEntry("AnalysisToolbarEnabled", false));

	toolBar("drawing")->hide();
	if (config->readBoolEntry("DrawingToolbarEnabled",false))
		toolBar("drawing")->show();
	drawingtoolbar->setChecked(config->readBoolEntry("DrawingToolbarEnabled", false));

	if (! config->readBoolEntry("StatusbarEnabled",true))
		statusBar()->hide();
	statusbar->setChecked(config->readBoolEntry("StatusbarEnabled", true));

	autosave=config->readBoolEntry("Autosave",true);
	autosaveinterval=config->readLongNumEntry("AutosaveInterval",600000);
	enableAutosave(autosave);
	setAutosaveInterval(autosaveinterval);

	speedmode = config->readBoolEntry("SpeedMode",false);
	togglespeedmode->setChecked(speedmode);
	speedmodevalue = config->readLongNumEntry("SpeedModeValue",1000);

	defaultfont = config->readFontEntry("DefaultFont",new QFont("Adobe Times",22));
	datamodecolor = config->readColorEntry("DataModeColor",&Qt::red);
}

//! save all settings
void MainWin::saveSettings() {
	kdDebug()<<"MainWin::saveSettings()"<<endl;
	config->setGroup( "General Options" );
	config->writeEntry("Width",width());
	config->writeEntry("Height",height());
	config->writeEntry("Autosave",autosave);
	config->writeEntry("AutosaveInterval",autosaveinterval);
	config->writeEntry("SpeedMode",speedmode);
	config->writeEntry("SpeedModeValue",speedmodevalue);
	config->writeEntry("DefaultFont",defaultfont);
	config->writeEntry("DataModeColor",datamodecolor);

	config->writeEntry("MenubarEnabled",menuBar()->isVisible());
	config->writeEntry("ToolbarEnabled",toolBar()->isVisible());
	config->writeEntry("SideToolbarEnabled",toolBar("actions")->isVisible());
	config->writeEntry("AnalysisToolbarEnabled",toolBar("analysis")->isVisible());
	config->writeEntry("DrawingToolbarEnabled",toolBar("drawing")->isVisible());
	config->writeEntry("StatusbarEnabled",statusBar()->isVisible());

	kdDebug()<<"MainWin::saveSettings() DONE"<<endl;
}

void MainWin::enableAutosave(bool as) {
	autosave=as;
	if (as) autosaveTimer->start(autosaveinterval);
	else autosaveTimer->stop();
}

void MainWin::toggleFullScreen() {
#if KDE_VERSION > 0x030004
	kdDebug()<<"	toggleFullScreen() : "<<is_fullscreen<<endl;
	if (is_fullscreen)
		this->showNormal();
	else
		this->showFullScreen();
	is_fullscreen = !is_fullscreen;
#else
	KMessageBox::error(this,i18n("Sorry. Fullscreen not supported in KDE 3.0!"));
#endif
}

//! Open the configure dialog
void MainWin::configure() {
	ConfigureDialog *cfgdlg = new ConfigureDialog(this,config);

	if(cfgdlg->exec())
		readConfig();

	delete cfgdlg;
}

void MainWin::toggleMenuBar() {
	if(menuBar()->isVisible())
		menuBar()->hide();
	else
		menuBar()->show();
}

void MainWin::toggleToolBar() {
	if(toolBar()->isVisible())
		toolBar()->hide();
	else
		toolBar()->show();
}

void MainWin::toggleSideToolBar() {
	if(toolBar("actions")->isVisible())
		toolBar("actions")->hide();
	else
		toolBar("actions")->show();
}

void MainWin::toggleAnalysisToolBar() {
	if(toolBar("analysis")->isVisible())
		toolBar("analysis")->hide();
	else
		toolBar("analysis")->show();
}

void MainWin::toggleDrawingToolBar() {
	if(toolBar("drawing")->isVisible())
		toolBar("drawing")->hide();
	else
		toolBar("drawing")->show();
}

void MainWin::toggleStatusBar() {
	if(statusBar()->isVisible())
		statusBar()->hide();
	else
		statusBar()->show();
}

void MainWin::toggleSpeedMode() {
	if (speedmode)
		speedmode = false;
	else
		speedmode = true;
	if(Worksheet *p = activeWorksheet())
		p->updatePixmap();
}

void MainWin::configureToolbars() {
	saveMainWindowSettings(config, QString("LabPlotMainWindow") );
	KEditToolbar dlg(factory());
	if ( dlg.exec() )
		applyMainWindowSettings(config, QString("LabPlotMainWindow") );
}

void MainWin::loadScript(QString fn) {
	kdDebug()<<"MainWin::loadScript("<<fn<<")"<<endl;
#ifdef HAVE_QSA
	if(fn.isEmpty())
		fn = QFileDialog::getOpenFileName(QString::null,i18n("Scripts (*.qs *.QS)"),this);

	readScript(fn);
#else
	KMessageBox::error(this, i18n("Sorry. Your system has no scripting support!"));
#endif
	kdDebug()<<"MainWin::loadScript() DONE"<<endl;
}

void MainWin::openIDE() {
#ifdef HAVE_QSA
#ifdef HAVE_QSA_IDE
	// open the QSA Workbench
	QSInterpreter *interpreter = qsproject->interpreter();
	interpreter->evaluate("",this);	// set context
	kdDebug()<<" CONTEXT of INTERPRETER : "<<interpreter->currentContext()<<endl;

/*	// set factory
#ifdef HAVE_QSA_FAC
	// add module factory
	ModuleFactory factory(this,ws);
	interpreter->addObjectFactory( &factory );
#endif
*/
	ide->open();
#else
	QMessageBox::information( this, i18n("Disabled feature"),
		i18n("QSA Workbench has been disabled. Reconfigure to enable."),QMessageBox::Ok );
#endif
#endif
}

void MainWin::aboutKDE() {
	KHelpMenu *helpmenu = new KHelpMenu();
	helpmenu->aboutKDE();

	delete helpmenu;
}

void MainWin::reportBug() {
	KHelpMenu *helpmenu = new KHelpMenu();
	helpmenu->reportBug();

	delete helpmenu;
}

void MainWin::Environment() { (new LabPlotDialog(this,0))->show(); }

void MainWin::dropEvent(QDropEvent *e) {
	kdDebug()<<"MainWin::dropEvent()"<<endl;

	QString fn;

	// TODO : handle *.dat files ?
	if ( QTextDrag::decode(e, fn) ) {
		// fn = "file:/usr/dir/file.lpl"
		fn = fn.right(fn.length()-5);

		kdDebug()<<"got file : \""<<fn<<"\""<<endl;

		if(QFile::exists(fn) && fn.contains(".lpl"))
			openLPL(fn);
		else if(QFile::exists(fn) && ( fn.contains(".lml") || fn.contains(".xml")))
			openXML(fn);
		else if(QFile::exists(fn) && fn.contains(".qs")) {
#ifdef HAVE_QSA
			readScript(fn);
#else
			KMessageBox::error(this,i18n("LabPlot not compiled with scripting support!"));
#endif
		}
		else
			KMessageBox::error(this,i18n("Can not handle unknown file format!"));
    	}
}

//! adding new plot
Plot *MainWin::newPlot(PType type) {
	kdDebug()<<"MainWin::newPlot() : type="<<type<<endl;
	Worksheet *w = activeWorksheet();

	Plot *plot=0;
	if (w==0) {
		kdDebug()<<"	OPENING new worksheet (no found)"<<endl;
		w = newWorksheet();
	}
	else {
		plot = w->getPlot(w->API());
	}

	if ( plot != 0 && plot->Type() == PQWT3D ) {
		kdDebug()<<"	OPENING new worksheet (active is qwt 3d)"<<endl;
		w = newWorksheet();
	}
	else if (type == PQWT3D && (plot != 0 && plot->Type() != PQWT3D)) {
		kdDebug()<<"	OPENING new worksheet (qwt 3d wanted but active isn't)"<<endl;
		w = newWorksheet();
	}

	// add new plot of type type
	return w->newPlot(type);
}

void MainWin::cloneWorksheet(Worksheet *w) {
	Worksheet *nw = new Worksheet( ws, this, 0);
	nw->setTitle(w->Title()+" "+i18n("Clone"));

	nw->setTitleEnabled(w->TitleEnabled());
	nw->setTimeStamp(w->TimeStamp());
	nw->setTimeStampEnabled(w->TimeStampEnabled());
	nw->setBackground(nw->Background());

	// copy plots
	for(unsigned int i=0; i < w->NrPlots(); i++) {
		nw->setPlot(i,w->getPlot(i));
	}
	nw->setNrPlots(w->NrPlots());

	// TEST
	history->addUndo("cloneWorksheet();");

	nw->updatePixmap();
}

void MainWin::cloneSpreadsheet(Spreadsheet *s) {
	Spreadsheet *ns = new Spreadsheet( ws, this, 0);

	QTable *table = s->Table(), *ntable = ns->Table();
	int cols = table->numCols(), rows = table->numRows();
	ntable->setNumRows(rows);
	ntable->setNumCols(cols);

	for(int j=0; j < cols; j++) {
		ntable->horizontalHeader()->setLabel( j, table->horizontalHeader()->label(j));

		for(int i=0; i < rows; i++)
			ntable->setText(i,j,table->text(i,j));
	}
	ns->setTitle(s->Title()+" "+i18n("Clone"));
}

void MainWin::cloneActiveSheet() {
	if(Worksheet *w = activeWorksheet())
		cloneWorksheet(w);
	else if(Spreadsheet *s = activeSpreadsheet())
		cloneSpreadsheet(s);
}

Spreadsheet* MainWin::newSpreadsheet() {
	kdDebug()<<"MainWin::newSpreadsheet()"<<endl;
	Spreadsheet *s = new Spreadsheet( ws, this, 0);
	kdDebug()<<"MainWin::newSpreadsheet() : nr_s+nr_w = "<<nr_s<<'+'<<nr_w<<endl;
	setActiveSheet(nr_s+nr_w-1);

	return s;
}

Worksheet* MainWin::newWorksheet() {
	kdDebug()<<"MainWin::newWorksheet()"<<endl;
	Worksheet* w = new Worksheet( ws, this, 0);
	kdDebug()<<"MainWin::newWorksheet() : nr_s+nr_w = "<<nr_s<<'+'<<nr_w<<endl;
	kdDebug()<<"	title = "<<w->Title()<<endl;

	return w;
}

void MainWin::tileWorksheets() {
	// hide all spreadsheets
	QWidgetList list = ws->windowList();
	for ( int i = 0; i < int(list.count()); i++) {
		Worksheet *w = (Worksheet *) list.at(i);
		if(w->getWidgetType() != WWORKSHEET)
			list.at(i)->hide();
	}

	ws->tile();

	// show and minimize all spreadsheets
	for ( int i = 0; i < int(list.count()); i++) {
		Worksheet *w = (Worksheet *) list.at(i);
		if(w->getWidgetType() != WWORKSHEET) {
			list.at(i)->showMinimized();
			//list.at(i)->();
		}
	}
}

void MainWin::cascadeWorksheets() {
	// hide all spreadsheets
	QWidgetList list = ws->windowList();
	for ( int i = 0; i < int(list.count()); i++) {
		Worksheet *w = (Worksheet *) list.at(i);
		if(w->getWidgetType() != WWORKSHEET)
			list.at(i)->hide();
	}

	ws->cascade();

	// show and minimize all spreadsheets
	for ( int i = 0; i < int(list.count()); i++) {
		Worksheet *w = (Worksheet *) list.at(i);
		if(w->getWidgetType() != WWORKSHEET)
			list.at(i)->showMinimized();
	}
}

void MainWin::deleteActiveSheet() {
	kdDebug()<<"deleteActiveSheet()"<<endl;
	if(Worksheet *w = activeWorksheet()) {
		delete w;
		setModified();
	}
	else if(Spreadsheet *s = activeSpreadsheet()) {
		delete s;
		setModified();
	}
}

void MainWin::deletePlot() {
	if(Worksheet *w = activeWorksheet())
		w->deleteActivePlot();
}

Worksheet *MainWin::activeWorksheet() {
//	kdDebug()<<"MainWin::activeWorksheet()"<<endl;
	Worksheet *w = (Worksheet *) ws->activeWindow();
	if(w && w->getWidgetType() == WWORKSHEET)
		return w;
	else
		return 0;
}

Spreadsheet *MainWin::activeSpreadsheet() {
//	kdDebug()<<"MainWin::activeSpreadsheet()"<<endl;
	Spreadsheet *w = (Spreadsheet *) ws->activeWindow();
	if(w && w->getWidgetType() == WSPREADSHEET)
		return w;
	else
		return 0;
}

Spreadsheet* MainWin::getSpreadsheet(QString title) {
	QWidgetList list = ws->windowList();
	for(unsigned int i=0;i<list.count();i++) {
		Spreadsheet *w = (Spreadsheet *) list.at(i);
		if (w && list.at(i)->caption() == title && w->getWidgetType() == WSPREADSHEET) {
			kdDebug()<<"	sheet index : "<<i<<endl;
			return w;
		}
	}

	return 0;
}

int MainWin::activeSheetIndex() {
	QString title;
	Worksheet *w = (Worksheet *) ws->activeWindow();
	if(w && w->getWidgetType() == WWORKSHEET)
		title = w->Title();
	else {
		Spreadsheet *s = (Spreadsheet *) ws->activeWindow();
		if(s) title = s->Title();
	}

	QWidgetList list = ws->windowList();
	for(unsigned int i=0;i<list.count();i++) {
		if (list.at(i)->caption() == title) {
			kdDebug()<<"	ASI : "<<i<<endl;
			return i;
		}
	}

	return 0;
}

//! initialize the Main Window; open new project
void MainWin::New() {
	kdDebug()<<"MainWin::New()"<<endl;
	if(warnModified()) return;

	// close all Plots
	QWidgetList list = ws->windowList();
	for ( int i = int(list.count())-1; i >= 0; i-- ) {
		if(((Worksheet *)list.at(i))->getWidgetType() == WWORKSHEET) {
			Worksheet *pw = ((Worksheet *) list.at(i));
			pw->close();
		}
		else if(((Spreadsheet *)list.at(i))->getWidgetType() == WSPREADSHEET) {
			Spreadsheet *s = ((Spreadsheet *) list.at(i));
			s->close();
		}
	}
	updateSheetList();

	gvpart=0;
	defining_region=0;
	defining_line=0;
	defining_rect=0;
	defining_ellipse=0;
	defining_label=false;
	defining_image=false;
	defining_baseline=false;
	defining_maglens=0;
	defining_panzoom=0;
	project = new Project();
}

void MainWin::setActiveSheet(int i) {
	kdDebug()<<"MainWin::setActiveSheet() : "<<i<<endl;
	if(ws && ws->windowList().at(i))
		ws->windowList().at(i)->setFocus();
}

void MainWin::changeGraph(int i) {
	kdDebug()<<"MainWin::changeGraph() : "<<i<<endl;
	Worksheet *p = activeWorksheet();
	if(p==0) return;
	Plot *plot = p->getPlot(p->API());
	if(plot==0) return;
	PType type = plot->Type();
	Graph *g = plot->getGraphList()->getGraph(i);
	QString name = g->Name();

	if(g->Source()==SDATA)		// data
		(new DataDialog(this,name,0,i,type))->show();
	else		// function
		(new FunctionDialog(this,name,0,i,type))->show();
}

// update menu of Graphs
void MainWin::windowActivated() {
	updateTitleDialog();
	updateLegendDialog();
	updateAxesDialog();
	updatePlotSettingsDialog();
	updateSheetList();
	updateWorksheetDialog();
	updateObjectDialog();
}

void MainWin::undoAction() {
/*#ifdef HAVE_UNDO
	Worksheet *p = activeWorksheet();
	Spreadsheet *s = 0;
	UNDO *undo;
	if(p!=0)
		undo = p->getUndo();
	else {
		s = activeSpreadsheet();
		if(s!=0)
			undo = s->getUndo();
		else
			return;
	}

	int res = undo_undo(undo);
	kdDebug()<<"UNDO : "<<undo_strerror(res)<<endl;
	if(s != 0) {
		kdDebug()<<" s->Title() = "<<s->Title()<<endl;
		s->update();
	}
#endif*/
}

void MainWin::redoAction() {
//#ifdef HAVE_UNDO
	// TODO
//	int res = undo_redo(undo);
//	kdDebug()<<"REDO : "<<undo_strerror(res)<<endl;
//#endif
}

// update menu of Graphs
void MainWin::updateGraphList() {
	kdDebug()<<"MainWin::updateGraphList()"<<endl;
	QPtrList<KAction> graphActions;

	// check for LabPlotui.rc
	bool menu_ok =true;
	if(KGlobal::dirs()->findResource( "appdata", "LabPlotui.rc" ).isEmpty()) {
		menu_ok=false;
		kdDebug()<<"	no menu found ! disabling signal mapping."<<endl;
	}
#if QT_VERSION == 0x030304		// avoid crashes on SuSE 9.3, SuSE 10.0, FC 4, X 3.0
	menu_ok=false;
#endif

	unplugActionList(QString("graphlist"));
	Worksheet *p = activeWorksheet();
	if(p==0 || p->NrPlots()==0) return;
	Plot *plot = p->getPlot(p->API());
	TESTPTR(plot);
	GraphList *gl = plot->getGraphList();
	TESTPTR(gl);
	kdDebug()<<"	number of graph : "<<gl->Number()<<endl;
	for ( unsigned int i = 0; i < gl->Number(); i++) {
		kdDebug()<<"MainWin::updateGraphList() graph "<<i+1<<endl;
		Graph *graph = gl->getGraph(i);
		TESTPTR(graph);

		kdDebug()<<"	setting title"<<endl;	// crashes without this ?
		QString title;
		if(graph->getLabel())
			title = graph->getLabel()->simpleTitle();
		kdDebug()<<"	got title"<<endl;	// crashes without this ?
		KKey key = KKey( "CTRL+ALT+" + QString::number(i+1) );	 // 1,2,3, ...
		QPixmap icon = QPixmap(list_graphs_xpm);

		KAction *action;
		if(menu_ok)
			action = new KAction(title,icon,KShortcut(),smg,SLOT(map()),actionCollection());
		else
			action = new KAction(title,icon,KShortcut(),0,0,actionCollection());

		action->setShortcut(KShortcut(key));	// prevent warnings for unnamed actions
		if(menu_ok && smg)
			smg->setMapping(action,i);
		graphActions.append(action);
		kdDebug()<<"	graph"<<i+1<<" DONE"<<endl;	// crashes without this ?
	}

	plugActionList(QString("graphlist"), graphActions);
	kdDebug()<<"MainWin::updateGraphList() DONE"<<endl;
}

void MainWin::SpreadsheetMenu() {
	kdDebug()<<"SpreadsheetMenu()"<<endl;
	if(activeSpreadsheet())
		activeSpreadsheet()->Menu(spreadsheetpopup);
	else {
		spreadsheetpopup->clear();
		// "New Spreadsheet" item
		QPixmap spreadsheetIcon = QPixmap(spreadsheet_xpm);
		spreadsheetpopup->insertItem(QIconSet(spreadsheetIcon),i18n("New S&preadsheet"),
			this,SLOT (newSpreadsheet()),KShortcut(CTRL+Key_Equal));
	}
}

// update menu of sheets
void MainWin::updateSheetList() {
	kdDebug()<<"MainWin::updateSheetList()"<<endl;

	updateGraphList();
	QPtrList<KAction> sheetsActions;

	// check for LabPlotui.rc
	bool menu_ok=true;
	if(KGlobal::dirs()->findResource( "appdata", "LabPlotui.rc" ).isEmpty()) {
		menu_ok=false;
		kdDebug()<<"	no menu found ! disabling signal mapping."<<endl;
	}
#if QT_VERSION == 0x030304		// avoid crashes on SuSE 9.3, SuSE 10.0, FC 4, X 3.0
	menu_ok=false;
#endif

	QWidgetList list = ws->windowList();
	nr_w=0, nr_s=0;
	kdDebug()<<"	number of windows = "<<list.count()<<endl;
	for ( int i = 0; i < int(list.count()); i++) {
		KKey key=0;
		QPixmap icon;
		KAction *action;
		Worksheet *w = (Worksheet *) list.at(i);
		QString title;
		if(w->getWidgetType() == WWORKSHEET) {
			kdDebug()<<"Worksheet "<<nr_w+1<<endl;
			key = KKey( "CTRL+" + QString::number(++nr_w) );	 // 1,2,3, ...
			icon = KGlobal::iconLoader()->loadIcon(QString("LabPlot"), KIcon::Desktop);
			title=w->Title();

			kdDebug()<<"	creating action"<<endl;
			if(menu_ok)
				action = new KAction(title,icon,KShortcut(),sm,SLOT(map()),actionCollection());
			else
				action = new KAction(title,icon,KShortcut(),0,0,actionCollection());
			kdDebug()<<"	creating action : DONE"<<endl;
		}
		else {
			kdDebug()<<"Spreadsheet "<<nr_s+1<<endl;
			key = KKey( "ALT+" + QString::number(++nr_s) ); 	// 1,2,3, ...
			icon = QPixmap(spreadsheet_xpm);
			title = ((Spreadsheet *) list.at(i))->Title();

			kdDebug()<<"creating action"<<endl;
			if(menu_ok)
				action = new KAction(title,icon,KShortcut(),sm,SLOT(map()),actionCollection());
			else
				action = new KAction(title,icon,KShortcut(),0,0,actionCollection());
		}
		action->setShortcut(KShortcut(key));	// prevent warnings for unnamed actions
		kdDebug()<<"Set mapping"<<endl;
		if(menu_ok && sm)
			sm->setMapping(action,i);
		sheetsActions.append(action);
		kdDebug()<<"	set mapping : DONE"<<endl;
	}
	unplugActionList(QString("sheets"));
	plugActionList(QString("sheets"), sheetsActions);

	// no windows, active not worksheet, active worksheet has no plots, active plot has no graph
	Worksheet *work = activeWorksheet();
	if ((int)(list.count()) == 0 || work==0 || (work->NrPlots()==0) || work->getPlot(work->API())==0 ||
		work->getPlot(work->API())->getGraphList()->Number()==0) {
		kdDebug()<<"	NO SHEET/PLOT"<<endl;
		save_action->setEnabled(false);
		save_as->setEnabled(false);
		project_action->setEnabled(false);
		explorer_action->setEnabled(false);
		export_image->setEnabled(false);
		export_ps->setEnabled(false);
		export_eps->setEnabled(false);
		export_pdf->setEnabled(false);
		export_svg->setEnabled(false);
		export_pic->setEnabled(false);
		export_pstoedit->setEnabled(false);
		export_ImageMagick->setEnabled(false);
		print_action->setEnabled(false);
		printpreview->setEnabled(false);
		graph_list->setEnabled(false);
		plot_list->setEnabled(false);
		clear_action->setEnabled(false);
		close_action->setEnabled(false);
		deleteplot->setEnabled(false);
		operations->setEnabled(false);
		smooth->setEnabled(false);
		prune->setEnabled(false);
		average->setEnabled(false);
		compress->setEnabled(false);
		periodic->setEnabled(false);
		seasonal->setEnabled(false);
		hist->setEnabled(false);
		peak->setEnabled(false);
		interpolation->setEnabled(false);
		differences->setEnabled(false);
		integration->setEnabled(false);
		capability->setEnabled(false);
		summary->setEnabled(false);
		tests->setEnabled(false);
		regression->setEnabled(false);
		wavelet->setEnabled(false);
		hankel->setEnabled(false);
		fft->setEnabled(false);
		laplace->setEnabled(false);
		convolution->setEnabled(false);
		fit->setEnabled(false);
		filter->setEnabled(false);
		noise->setEnabled(false);
		correl->setEnabled(false);
		imagepro->setEnabled(false);
		arrange->setEnabled(false);
		overlay->setEnabled(false);
		plot_action->setEnabled(false);
		axes->setEnabled(false);
		title_action->setEnabled(false);
		legend->setEnabled(false);
		objects->setEnabled(false);
		asx->setEnabled(false);
		asy->setEnabled(false);
		asz->setEnabled(false);
		asall->setEnabled(false);
		zoomin->setEnabled(false);
		zoomout->setEnabled(false);
		panzoom->setEnabled(false);
		maglens->setEnabled(false);
		maskplot->setEnabled(false);
		sl->setEnabled(false);
		sr->setEnabled(false);
		sd->setEnabled(false);
		su->setEnabled(false);
		sxu->setEnabled(false);
		sxd->setEnabled(false);
		syu->setEnabled(false);
		syd->setEnabled(false);
		szu->setEnabled(false);
		szd->setEnabled(false);
		toggledatamode->setEnabled(false);
		region->setEnabled(false);
		baseline->setEnabled(false);
		line->setEnabled(false);
		label->setEnabled(false);
		rect->setEnabled(false);
		ellipse->setEnabled(false);
		image->setEnabled(false);
	}
	else {
		convolution->setEnabled(true);
		operations->setEnabled(true);
		save_action->setEnabled(true);
		save_as->setEnabled(true);
		project_action->setEnabled(true);
		explorer_action->setEnabled(true);
		export_image->setEnabled(true);
		export_ps->setEnabled(true);
		export_eps->setEnabled(true);
		export_pdf->setEnabled(true);
		export_svg->setEnabled(true);
		export_pic->setEnabled(true);
		export_pstoedit->setEnabled(true);
#ifdef HAVE_MAGICK
		export_ImageMagick->setEnabled(true);
#endif
		print_action->setEnabled(true);
		printpreview->setEnabled(true);
		graph_list->setEnabled(true);
		plot_list->setEnabled(true);
		clear_action->setEnabled(true);
		close_action->setEnabled(true);
		deleteplot->setEnabled(true);
		smooth->setEnabled(true);
		prune->setEnabled(true);
		average->setEnabled(true);
		periodic->setEnabled(true);
		compress->setEnabled(true);
		seasonal->setEnabled(true);
		peak->setEnabled(true);
		differences->setEnabled(true);
		integration->setEnabled(true);
#ifdef HAVE_GSL
		hist->setEnabled(true);
		interpolation->setEnabled(true);
		regression->setEnabled(true);
		fft->setEnabled(true);
		laplace->setEnabled(true);
		fit->setEnabled(true);
		filter->setEnabled(true);
		noise->setEnabled(true);
		correl->setEnabled(true);
		hankel->setEnabled(true);
		capability->setEnabled(true);
#endif
#ifdef HAVE_GSL16
		wavelet->setEnabled(true);
#endif
#if defined(HAVE_FFTW3) || defined(HAVE_FFTW)
		fft->setEnabled(true);
#endif
#ifdef HAVE_R
		summary->setEnabled(true);
		// not yet on worksheets
		// tests->setEnabled(true);
#endif
		arrange->setEnabled(true);
		plot_action->setEnabled(true);
		axes->setEnabled(true);
		title_action->setEnabled(true);
		legend->setEnabled(true);
		objects->setEnabled(true);
		asx->setEnabled(true);
		asy->setEnabled(true);
		asz->setEnabled(true);
		asall->setEnabled(true);
		zoomin->setEnabled(true);
		zoomout->setEnabled(true);
		panzoom->setEnabled(true);
		maglens->setEnabled(true);
		maskplot->setEnabled(true);
		sl->setEnabled(true);
		sr->setEnabled(true);
		sd->setEnabled(true);
		su->setEnabled(true);
		sxu->setEnabled(true);
		sxd->setEnabled(true);
		syu->setEnabled(true);
		syd->setEnabled(true);
		szu->setEnabled(true);
		szd->setEnabled(true);
		toggledatamode->setEnabled(true);
		region->setEnabled(true);
		baseline->setEnabled(true);
		line->setEnabled(true);
		label->setEnabled(true);
		rect->setEnabled(true);
		ellipse->setEnabled(true);
		image->setEnabled(true);
	}

	// extra stuff
/*#ifndef HAVE_UNDO
	undo_action->setEnabled(false);
	redo_action->setEnabled(false);
#endif*/

	Worksheet *p = activeWorksheet();
	Spreadsheet *s = activeSpreadsheet();

	// active Spreadsheet
	if(s) {
		kdDebug()<<"	HAVE SPREADSHEET"<<endl;
		save_action->setEnabled(true);
		save_as->setEnabled(true);
		project_action->setEnabled(true);
		explorer_action->setEnabled(true);
		clear_action->setEnabled(true);
		close_action->setEnabled(true);

		graph_list->setEnabled(false);
		plot_list->setEnabled(false);

		operations->setEnabled(true);
		average->setEnabled(true);
		compress->setEnabled(true);
		periodic->setEnabled(true);
		seasonal->setEnabled(true);
		smooth->setEnabled(true);
		prune->setEnabled(true);
		peak->setEnabled(true);
		differences->setEnabled(true);
		integration->setEnabled(true);
		fit->setEnabled(true);
#ifdef HAVE_GSL
		hist->setEnabled(true);
		interpolation->setEnabled(true);
		hankel->setEnabled(true);
		capability->setEnabled(true);
#endif
#ifdef HAVE_GSL16
		wavelet->setEnabled(true);
#endif
#ifdef HAVE_R
		summary->setEnabled(true);
		tests->setEnabled(true);
#endif
	}

	// Worksheet
	if (p) {
		explorer_action->setEnabled(true);
		worksheet_action->setEnabled(true);

		// save/save as/close empty worksheet
		save_action->setEnabled(true);
		save_as->setEnabled(true);
		close_action->setEnabled(true);

		Plot *plot = p->getPlot(p->API());
		if (plot) {
			// arrange, settings empty plot
			arrange->setEnabled(true);
			plot_action->setEnabled(true);

			GraphList *gl = plot->getGraphList();
			PType type = plot->Type();

			if (gl->Number()<2) {
				convolution->setEnabled(false);
				operations->setEnabled(false);
			}
			if (type == PSURFACE || type == P3D || type == PQWT3D) {
				smooth->setEnabled(false);
				prune->setEnabled(false);
				differences->setEnabled(false);
				integration->setEnabled(false);
				regression->setEnabled(false);
				capability->setEnabled(false);
				fit->setEnabled(false);
				filter->setEnabled(false);
				noise->setEnabled(false);
				correl->setEnabled(false);

				region->setEnabled(false);
				baseline->setEnabled(false);
				
				toggledatamode->setEnabled(false);
			}
			if ( type == PQWT3D) {
				arrange->setEnabled(false);
				overlay->setEnabled(false);
				average->setEnabled(false);
				compress->setEnabled(false);
				periodic->setEnabled(false);
				seasonal->setEnabled(false);
				peak->setEnabled(false);
				interpolation->setEnabled(false);
				hist->setEnabled(false);
				fft->setEnabled(false);
				laplace->setEnabled(false);
				hankel->setEnabled(false);
			}
			if(type == PSURFACE && gl->Number()>0)
				imagepro->setEnabled(true);
		}

		if(p->NrPlots()>1)
			overlay->setEnabled(true);
	}
	else {
		worksheet_action->setEnabled(false);
	}

#ifndef HAVE_GL
	qwt3d_plot->setEnabled(false);
	qwt3d_func->setEnabled(false);
	qwt3d_data->setEnabled(false);
#endif

	setModified();

	updateExplorerDialog();
	kdDebug()<<"MainWin::updateSheetList() DONE"<<endl;
}

// dialog update wrapper
void MainWin::updateExplorerDialog(){ if(explorer_dialog != 0) explorer_dialog->updateDialog(); }
void MainWin::updateLegendDialog(){ if(legend_dialog != 0) legend_dialog->updateDialog(); }
void MainWin::updateTitleDialog(){ if(title_dialog != 0) title_dialog->updateDialog(); }
void MainWin::updateAxesDialog(int i){ if(axes_dialog != 0) axes_dialog->updateDialog(i); }
void MainWin::updatePlotSettingsDialog(){ if(plotsettings_dialog != 0) plotsettings_dialog->updateDialog(); }
void MainWin::updateWorksheetDialog(){ if(worksheet_dialog != 0) worksheet_dialog->updateDialog(); }
void MainWin::updateObjectDialog(){ if(object_dialog != 0) object_dialog->updateDialog(); }
void MainWin::updateTestDialog(){ if(test_dialog != 0) test_dialog->updateDialog(); }

void MainWin::clear() {
	Worksheet *p = activeWorksheet();
	Spreadsheet *s = activeSpreadsheet();
	if (p) p->New();
	if (s) s->Clear();

	updateSheetList();
}

void MainWin::open(QString fn) {
	kdDebug()<<"MainWin::open()"<<endl;

	if(warnModified()) return;

	if (fn.isEmpty())
		fn = QFileDialog::getOpenFileName(QString::null,
			i18n("LabPlot Projects (*.lml *.lml.gz *.lml.bz2 *.LML *.LML.GZ *.LML.BZ2)"),this);

	if(!fn.isEmpty())
		openXML(fn);
}

//! Open a LabPlot project file (*.lml/*.lpl) from recent url
void MainWin::open(const KURL& url) {
#if KDE_VERSION > 0x030400
	kdDebug()<<"MainWin::open() : "<<url<<endl;
#endif

	if(warnModified()) return;

#if KDE_VERSION > 0x030400
	QString fn = url.pathOrURL();
#else
	QString fn = url.path();
#endif
	if (fn.contains("lml") || fn.contains("LML") || fn.contains("xml") || fn.contains("XML"))
		openXML(fn);
	else if (fn.contains("lpl") || fn.contains("LPL"))
		openLPL(fn);
}

/*! Open the project file fn ("filename" is global ) */
void MainWin::openLPL(QString fn) {
	if(warnModified()) return;

	if (fn.isEmpty())
		fn = QFileDialog::getOpenFileName(QString::null,
			i18n("LabPlot Projects (*.lpl *.lpl.gz *.lpl.bz2 *.LPL *.LPL.GZ *.LPL.BZ2)"),this);

	kdDebug()<<"MainWin::openLPL() : "<<fn<<endl;
	if (!fn.isEmpty()) {
		New();	// clear ws and all other stuff

		recent->addURL(fn);
		project->setFilename(fn);

		setCaption("LabPlot "LVERSION+i18n(" : ")+fn);

		// create io device (if filterdev not found "no mime type for text/plain" generic methods are used)
		// force to return 0 if no filter is found
		QIODevice *file = KFilterDev::deviceForFile(fn,QString::null,true);
		if (file==0) file = new QFile(fn);

		if ( file->open( IO_ReadOnly )) {
			QTextStream t(file);
			QString name, v;
			int version, tmpint;

			t>>name>>v>>name>>version;
			if (version>PROJECT_VERSION) {
				KMessageBox::error(this, i18n("Sorry. You need a newer version of LabPlot to open this project file!"));
				return;
			}
			project->setFilename(fn);
			project->setLabPlot(v);
			project->setVersion(version);
			if(version>8) {
				t.readLine();
				name=t.readLine();
				project->setTitle(name);
				name=t.readLine();
				project->setAuthor(name);
				if(version>14) {
					QDateTime dt;
					t>>tmpint;
					dt.setTime_t(tmpint);
					project->setCreated(dt);
					t>>tmpint;
					dt.setTime_t(tmpint);
					project->setModified(dt);
					t.readLine();
				}
				else {
					name=t.readLine();
					project->setCreated(QDateTime::fromString(name));
					name=t.readLine();
					project->setModified(QDateTime::fromString(name));
				}
				name=t.readLine();
				project->setNotes(name);
				if(version>18) {
					int s;
					t>>s;
					speedmode=(bool)s;
				}
			}
			else { // old files
				project->setCreated(QDateTime::fromString(QString("Sun Jan 1 00:00:00 2000")));
				project->setModified(QDateTime::fromString(QString("Sun Jan 1 00:00:00 2000")));
			}
			kdDebug()<<"Reading file "<<fn<<endl;
			kdDebug()<<"Found LabPlot file version "<<version<<" ("<<v<<')'<<endl;

			while (!t.eof()) {
				QString tmp;
				int i=0, type;

				t>>tmp>>i>>type;

				kdDebug()<<tmp<<" ("<<i+1<<") Type : "<<type<<endl;

				// dont translate. project saved in english!
				if (tmp == QString("Worksheet") ){
					if(version > 4 && version < 6)	{ // old plot style conversion
						if(type == 1)
							type = P2D;
						else if(type == 2 || type == 3)
							type = PSURFACE;
						else if(type == 4)
							type = P3D;

						kdDebug()<<"TYPE now : "<<type<<endl;
					}
					Worksheet *p = newWorksheet();
					if(version > 21) {
						int px, py;
						t >>px>>py;
						p->parentWidget()->move(QPoint(px,py));
						if(px<0 || py<0) {	// fullscreen
							if(ws) ws->tile();
							p->showMaximized();
						}
					}
					p->open(&t,version,(PType)type);
				}
				else if (tmp == QString("Spreadsheet") ){
					Spreadsheet *s = newSpreadsheet();
					if(version > 21) {
						int px, py;
						t >>px>>py;
						s->parentWidget()->move(QPoint(px,py));
						if(px<0 || py<0) {	// fullscreen
							if(ws) ws->tile();
							s->showMaximized();
						}
					}
					s->open(&t,version);
				}
			}

			statusBar()->message(i18n("Opened ")+fn);
		}
		delete file;
	}

	modified=false;
}

void MainWin::autoSave() {
	kdDebug()<<"MainWin::autoSave()"<<endl;
	QString fn = project->Filename();

	config->setGroup( "General Options" );
	if(fn.isEmpty() || config->readBoolEntry("AutoOriginal",true) == false ) {
		KTempFile *tmpfile = new KTempFile(QString::null,".lml.gz");
		fn = tmpfile->name();
		delete tmpfile;
	}

	saveXML(fn);
}

void MainWin::openXML(QString fn) {
	kdDebug()<<"MainWin::openXML()"<<endl;

	if (fn.isEmpty())
		fn = QFileDialog::getOpenFileName(QString::null,
			i18n("LabPlot Projects (*.lml *.LML *.lml.gz *.LML.GZ *.lml.bz2 *.LML.BZ2)"),this);

	kdDebug()<<"MainWin::openXML() : "<<fn<<endl;
	recent->addURL(fn);

	New();	// clear ws and all other stuff
	project->setFilename(fn);

	setCaption("LabPlot "LVERSION+i18n(" : ")+fn);

	// create io device (if filterdev not found "no mime type for text/plain" generic methods are used)
	// force to return 0 if no filter is found
	QIODevice *file = KFilterDev::deviceForFile(fn,QString::null,true);
	//QIODevice *file = KFilterDev::deviceForFile(fn);
	if (file==0) file = new QFile(fn);

	if ( file->open( IO_ReadOnly ) == 0) {
		KMessageBox::error(this, i18n("Sorry. Could not open file for reading!"));
		kdDebug()<<"ERROR : Cannot open file!"<<endl;
		return;
	}

	kdDebug()<<"############ READING XML FILE ###########"<<endl;
	QDomDocument doc;
	kdDebug()<<"	checking ..."<<endl;
	doc.setContent(file);
	kdDebug()<<"	... OK"<<endl;
	file->close();

	QDomElement root = doc.documentElement();
	kdDebug()<<"ROOT TAG = "<<root.tagName()<<endl;
	kdDebug()<<"ROOT ATTR version = "<<root.attribute("version")<<endl;
	Q_ASSERT(root.tagName() == "LabPlot");

	//project->setFilename(fn);
	project->setLabPlot(root.attribute("version"));

	QDomNode node = root.firstChild();
	while(!node.isNull()) {
		QDomElement e = node.toElement();
//		kdDebug()<<"TAG = "<<e.tagName()<<endl;
//		kdDebug()<<"TEXT = "<<e.text()<<endl;

		if(e.tagName() == "SpeedMode")
			speedmode = (bool)e.text().toInt();
		else if(e.tagName() == "Project")
			project->openXML(e.firstChild());
		else if(e.tagName() == "Worksheet") {
			Worksheet *p = newWorksheet();
			p->openXML(e.firstChild());
		}
		else if(e.tagName() == "Spreadsheet") {
			Spreadsheet *s = newSpreadsheet();
			s->openXML(e.firstChild());
		}
		node = node.nextSibling();
	}

	modified=false;
}

void MainWin::saveXML(QString fn) {
	kdDebug()<<"MainWin::saveXML()"<<endl;
	if (fn.isEmpty() && project->Filename().isEmpty()) {	// need a project name
		saveAs();
		return;
	}
	if(fn.isEmpty() && !project->Filename().isEmpty())		// already saved
		fn = project->Filename();

	fn.replace("lpl","lml");
	fn.replace("LPL","LML");
	project->setFilename(fn);
	setCaption("LabPlot "LVERSION+i18n(" : ")+project->Filename());

	kdDebug()<<"	project filename = "<<fn<<endl;

	if (fn.isEmpty())
		return;

	kdDebug()<<"	file name = "<<fn<<endl;
	// force to return 0 if no filter is found
	QIODevice *xmlfile = KFilterDev::deviceForFile(fn,QString::null,true);
	//QIODevice *xmlfile = KFilterDev::deviceForFile(fn);
	if (xmlfile==0) xmlfile = new QFile(fn);

	QDomDocument doc("LabPlot");
	QString header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	QString doctype = "<!DOCTYPE LabPlotXML>\n";
	doc.setContent(header+doctype);

	QDomElement root = doc.createElement( "LabPlot" );
	root.setAttribute("version",QString(LVERSION));
	doc.appendChild( root );

	QDomElement tag = project->saveXML(doc);
    	root.appendChild( tag );
	tag = doc.createElement( "SpeedMode" );
	root.appendChild( tag );
	QDomText t = doc.createTextNode( QString::number(speedmode));
	tag.appendChild( t );

	QWidgetList list = ws->windowList();
	for (unsigned int i = 0; i < list.count(); i++ ) {
		kdDebug()<<"	Saving sheet "<<i<<endl;
		if(((Worksheet *)list.at(i))->getWidgetType() == WWORKSHEET) {
			Worksheet *w = ((Worksheet *) list.at(i));
			QDomElement wstag = w->saveXML(doc);
    			root.appendChild(wstag);
		}
		else if(((Spreadsheet *)list.at(i))->getWidgetType() == WSPREADSHEET) {
			Spreadsheet *s = ((Spreadsheet *) list.at(i));
			QDomElement sstag = s->saveXML(doc);
    			root.appendChild(sstag);
		}
	}

	if(xmlfile->open(IO_WriteOnly)) {
		QTextStream ts(xmlfile);
		doc.save(ts,4);
		ts<<endl;
		statusBar()->message(i18n("Saved ")+fn);
		xmlfile->close();

	//	delete xmlfile;
		modified = false;
	}
	else {
		KMessageBox::error(this, i18n("Sorry. Could not open file for writing!"));
	}
}

void MainWin::saveLPL(QString fn) {
	kdDebug()<<"MainWin::saveLPL("<<fn<<")"<<endl;

	if (fn.isEmpty() && project->Filename().isEmpty()) {	// need a project name
		fn = QFileDialog::getOpenFileName(QString::null,
			i18n("LabPlot Projects (*.lpl *.lpl.gz *.lpl.bz2 *.LPL *.LPL.GZ *.LPL.BZ2)"),this);
	}
	if(fn.isEmpty() && !project->Filename().isEmpty())		// already saved
		fn = project->Filename();

	setCaption("LabPlot "LVERSION+i18n(" : ")+project->Filename());
	kdDebug()<<"	project filename = "<<fn<<endl;

	QIODevice *file = KFilterDev::deviceForFile(fn,QString::null,true);
	if (file==0) file = new QFile(fn);

	if ( file->open( IO_WriteOnly )) {
		QTextStream t(file);
		t.precision(15);

		project->setFilename(fn);
		project->setVersion(PROJECT_VERSION);
		t<<"LabPlot " <<LVERSION <<" : "<<PROJECT_VERSION<<endl;
		t<<project->Title()<<endl;
		t<<project->Author()<<endl;
#if QT_VERSION > 0x030007
		t<<project->Created().toTime_t()<<endl;
		t<<QDateTime::currentDateTime().toTime_t()<<endl;
#else
		QDateTime stoneage(QDate(1970,1,1));
		t<<stoneage.secsTo(project->Created())<<endl;
		t<<stoneage.secsTo(QDateTime::currentDateTime())<<endl;
#endif
		project->setModified(QDateTime::currentDateTime());
		t<<project->Notes()<<endl;
		t<<speedmode<<endl;

		QWidgetList list = ws->windowList();
		int tmpw=0,tmps=0;
		for (unsigned int i = 0; i < list.count(); i++ ) {
			if(((Worksheet *)list.at(i))->getWidgetType() == WWORKSHEET) {
				Worksheet *w = ((Worksheet *) list.at(i));
				int type=0;
				if(w->NrPlots() > 0 )
					type = w->getPlot(w->API())->Type();
				t<<"Worksheet "<<tmpw++<<' '<<type<<endl;
				// save position
				t<<w->parentWidget()->pos().x()<<' '<<w->parentWidget()->pos().y()<<endl;
				w->save(&t);
			}
			else if(((Spreadsheet *)list.at(i))->getWidgetType() == WSPREADSHEET) {
				Spreadsheet *s = ((Spreadsheet *) list.at(i));
				t<<"Spreadsheet "<<tmps++<<' '<<"0"<<endl;
				// save position
				t<<s->parentWidget()->pos().x()<<' '<<s->parentWidget()->pos().y()<<endl;
				s->save(&t);
			}
		}
		statusBar()->message(i18n("Saved ")+fn);
	}
	else {
		KMessageBox::error(this, i18n("Sorry. Could not open project file for writing!"));
	}
	delete file;

	modified = false;
}

// wrapper functions for dialogs
void MainWin::importData(QString fn,int ifilter) {
	ImportDialog *id = new ImportDialog(this,fn,(InputFilter) ifilter,0);
	id->Apply();

	delete id;
}

void MainWin::exportPstoEdit(QString fn, int f, int s, double sc, double r) {
	kdDebug()<<"MainWin::exportPstoEdit()"<<endl;
	PstoEditDialog *dialog = new PstoEditDialog(this,fn,f,s,sc,r);
	dialog->Apply();

	delete dialog;
}
void MainWin::exportImageMagick(QString fn, int f, int sx, int sy, double r) {
	kdDebug()<<"MainWin::exportImageMagick()"<<endl;
	ImageMagickDialog *dialog = new ImageMagickDialog(this,fn,f,sx,sy,r);
	dialog->Apply();

	delete dialog;
}

void MainWin::graphDialog() { (new GraphListDialog(this))->show(); }
void MainWin::plotDialog() { (new ListPlotDialog(this,0))->show(); }
void MainWin::importDialog() { (new ImportDialog(this))->show(); }
void MainWin::importOPJ(QString fn) {
	if(fn.isEmpty()) {
		fn = QFileDialog::getOpenFileName(QString::null,i18n("Origin Projects (*.opj *.OPJ)"),this);
		if (fn.isEmpty())
			return;
	}

	ImportOPJ importer(this,fn);
	importer.import();
}
void MainWin::exportPstoEditDialog() { (new PstoEditDialog(this))->show();}
void MainWin::exportImageMagickDialog() { (new ImageMagickDialog(this))->show(); }


void MainWin::exportPlot(QString fn, QString format,int quality) {
	kdDebug()<<"MainWin::exportPlot() : "<<fn<<" ("<<format<<")"<<endl;
	QPopupMenu *exportpm = new QPopupMenu( 0 );
	QIntDict<QString> formats;
	formats.setAutoDelete( true );

	// get format
	if(format.isEmpty()) {
		Worksheet *w = activeWorksheet();
		// Qwt3D IO formats
		if(w && w->getPlot(w->API())->Type() == PQWT3D) {
#ifdef HAVE_GL
			QStringList l = Qwt3D::IO::outputFormatList();
			for ( QStringList::Iterator it = l.begin(); it != l.end(); ++it )
				formats.insert( exportpm->insertItem( QString( "%1..." ).arg( *it ) ), new QString( *it ) );
#endif
		}
		else {
			// QImageIO formats
			for ( unsigned int i = 0; i < QImageIO::outputFormats().count(); i++ ) {
				QString str = QString( QImageIO::outputFormats().at( i ) );
				formats.insert( exportpm->insertItem( QString( "%1..." ).arg( str ) ), new QString( str ) );
    			}
		}

		exportpm->setMouseTracking( true );
		int id = exportpm->exec(QCursor::pos());

		if(id == -1) return;

		if(format.isEmpty())
			format = *formats[ id ];
	}

	delete exportpm;

	if(fn.isEmpty()) {
		fn = QFileDialog::getSaveFileName(QString::null, QString( "*.%1" ).arg( format.lower() ), this );
		if(fn.isEmpty())	// "Cancel"
			return;
		if(fn.find(QRegExp(QString("\\.%1").arg(format.lower())))==-1)
			fn.append(QString(".%1").arg(format.lower()));
	}

	// check if image file exists
	if ( QFile::exists(fn) ) {
		int answer = KMessageBox::warningYesNoCancel( this, i18n( "Overwrite\n\'%1\'?" ).arg( fn ), i18n("Save Project"));
			if (answer != KMessageBox::Yes)
				return;
	}

	Worksheet *p = activeWorksheet();
	if (p && !fn.isEmpty() )
		p->Export(fn,format,quality);

	statusBar()->message(i18n("Plot Exported"));

}

//! export worksheet into file with svg format
void MainWin::exportSVG(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportSVG(fn);
	statusBar()->message(i18n("Exported File to svg format"));
}

//! export worksheet into file with pic format
void MainWin::exportPIC(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPIC(fn);
	statusBar()->message(i18n("Exported File to pic format"));
}

//! export worksheet into file via gs to PS
void MainWin::exportPS(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPS(fn);
	statusBar()->message(i18n("Exported File to postscript format"));
}

//! export worksheet into file via gs to EPS
void MainWin::exportEPS(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportEPS(fn);
	statusBar()->message(i18n("Exported File to eps format"));
}

//! export worksheet into file via gs to PDF
void MainWin::exportPDF(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPDF(fn);
	statusBar()->message(i18n("Exported File to pdf format"));
}

//! Save project as
void MainWin::saveAs(QString fn) {
	kdDebug()<<"MainWin::saveAs("<<fn<<")"<<endl;
	if(!fn.isEmpty())	// from script
		project->setFilename(fn);
	else {
		QString tmpfn = QFileDialog::getSaveFileName(QString::null,
			i18n("LabPlot Projects (*.lml *.lml.gz *.lml.bz2 *.LML *.LML.GZ *.LML.BZ2)"),this);
		if(tmpfn.isEmpty())	// "Cancel"
			return;
		else
			project->setFilename(tmpfn);
		if(project->Filename().find(QRegExp("\\.lml"))==-1)
			project->setFilename(project->Filename().append(".lml"));
	}

	QFile file(project->Filename());

	// check if project file exists
	if ( file.exists() ) {
		int answer = KMessageBox::warningYesNoCancel( this,
				i18n( "Overwrite\n\'%1\'?" ).arg(project->Filename()), i18n("Save Project"));
		if (answer == KMessageBox::Yes)
			saveXML();
	}
	else
		saveXML();

	setCaption("LabPlot "LVERSION+i18n(" : ")+project->Filename());
}

/*! edit project infos */
void MainWin::projectInfo() {
	(new ProjectDialog(this,0))->show();
	setModified();
}

//! project explorer
void MainWin::projectExplorer() { (explorer_dialog = new ExplorerDialog(this,0))->show(); }

//! Print active plot to Printer or File
void MainWin::print() {
	// TODO : make script interface
	if (Worksheet *p = activeWorksheet()) p->Print("out.ps");
	statusBar()->message(i18n("Plotted File"));
}

//! Print preview the activ plot
void MainWin::printPreview() {
	kdDebug()<<"MainWin::printPreview() : "<<printpreviewchecked<<endl;
	if (printpreviewchecked) {
		kdDebug()<<"	Leave print preview"<<endl;
		delete gvpart;
		gvpart=0;
		setCentralWidget(ws);
		printpreview->setChecked(false);
		printpreviewchecked=false;
		Worksheet *w = activeWorksheet();
		if(w) {
			Plot * p = w->getPlot(w->API());
#ifdef HAVE_GL
			if( p->Type() == PQWT3D)
				p->draw(0,w->width(),w->height());		// update QWt3D plot
#endif
		}
		// how to delete the gv part gui elements ?
	}
	else {
		kdDebug()<<"	Start print preview"<<endl;
		kdDebug()<<"	Trying factory \"libkghostview\""<<endl;
		KLibFactory *factory = KLibLoader::self()->factory( "libkghostview" );

		// if not found try this (KDE 3.1)
		if (!factory) {
			kdDebug()<<"	Not found! Trying factory \"libkghostviewpart\""<<endl;
			factory = KLibLoader::self()->factory( "libkghostviewpart" );
		}

		if (factory) {
			kdDebug()<<"	factory found."<<endl;
			gvpart = (KParts::ReadOnlyPart *)factory->create( this,"kgvpart","KParts::ReadOnlyPart" );

			Worksheet *p = activeWorksheet();

			KTempFile *tmpfile = new KTempFile(QString::null,".ps");
			tmpfile->setAutoDelete(true);
			QString fn = tmpfile->name();

//			kdDebug()<<"	Calling Print("<<project->Filename()<<")"<<endl;
			if (p)
				p->Print(fn);

			KURL url = KURL(fn);
			if(gvpart) {
				kdDebug()<<"   gvpart OK. filename = "<<fn<<endl;
				setCentralWidget( gvpart->widget() );
				gvpart->openURL(url);
				gvpart->widget()->show();
				//createGUI(gvpart);
			}
		}
		else
			KMessageBox::error(this, i18n("No libkghostview found !"));

		printpreview->setChecked(true);
		printpreviewchecked=true;
	}
}

/*! Close active Plot */
void MainWin::closeWin() {
	kdDebug()<<"MainWin::closeWin()"<<endl;
	kdDebug()<<"	close active sheet()"<<endl;
	// close the print preview if active
	if (gvpart) {
		delete gvpart;
		gvpart=0;
		setCentralWidget(ws);
		printpreview->setChecked(false);
		printpreviewchecked=false;
	}
	else {
		Worksheet *p = activeWorksheet();
		Spreadsheet *s = activeSpreadsheet();
		// delete p;	-> crashes LabPlot
		if (p)  p->close();
		if (s) s->close();
	}
	updateSheetList();
}

//! Open DataDialog (0) or FunctionDialog (1) for creating new <type> graph
void MainWin::newDialog(bool fdialog, PType ptype) {
	kdDebug()<<"MainWin::newDialog() : type="<<ptype<<endl;

	if (fdialog)
		(new FunctionDialog(this,0,0,-1,ptype))->show();
	else
		(new DataDialog(this,0,0,-1,ptype))->show();
}

void MainWin::evaluateDialog() {
	bool ok;
	QString text = QInputDialog::getText("LabPlot", i18n("Enter equation : "),
	 	QLineEdit::Normal,QString("sin(pi)"), &ok, this );
	if ( !ok || text.isEmpty() )
		return;

	// evaluate it
	double value = parse((char *) text.latin1());
	if(parse_errors()>0)
		KMessageBox::error(this, i18n("Parse error!\n Please check the given equation."));
	else
		KMessageBox::information(0,QString::number(value));
}

//! open functions
void MainWin::averageDialog() { (new AverageListDialog(this,0))->show();}
void MainWin::compressDialog() { (new CompressListDialog(this,0))->show();}
void MainWin::pruneDialog() { (new PruneListDialog(this,0))->show();  }
void MainWin::smoothDialog() { (new SmoothListDialog(this,0))->show();  }
void MainWin::periodicDialog() { (new PeriodicListDialog(this,0))->show();  }
void MainWin::seasonalDialog() { (new SeasonalListDialog(this,0))->show();}
void MainWin::operationsDialog() { (new OperationsListDialog(this,0))->show();  }
void MainWin::histDialog() { (new HistListDialog(this,0))->show();  }
void MainWin::peakDialog() { (new PeakListDialog(this,0))->show();}
void MainWin::interpolationDialog() { (new InterpolationListDialog(this,0))->show();  }
void MainWin::differencesDialog() { (new DifferencesListDialog(this,0))->show();  }
void MainWin::integrationDialog() { (new IntegrationListDialog(this,0))->show();  }
void MainWin::capabilityDialog() { (new CapabilityListDialog(this,0))->show();  }
void MainWin::summaryDialog() { (new SummaryRListDialog(this,0))->show();  }
void MainWin::testsDialog() {
	if(test_dialog == 0)
		test_dialog = (new TestsRListDialog(this,0));
	test_dialog->show();
}
void MainWin::regressionDialog() { (new RegressionListDialog(this,0))->show();  }
void MainWin::fftDialog() { (new FFTListDialog(this,0))->show();  }
void MainWin::laplaceDialog() { (new LaplaceTransformListDialog(this,0))->show();  }
void MainWin::convolutionDialog() { (new ConvolutionListDialog(this,0))->show();  }
void MainWin::waveletDialog() { (new WaveletListDialog(this,0))->show();  }
void MainWin::hankelDialog() { (new HankelListDialog(this,0))->show();  }
void MainWin::fitDialog() { (new FitListDialog(this,0))->show();  }
void MainWin::filterDialog() { (new FilterListDialog(this,0))->show();  }
void MainWin::noiseDialog() { (new NoiseListDialog(this,0))->show();  }
void MainWin::correlDialog() { (new CorrelationListDialog(this,0))->show();  }
void MainWin::imageDialog() { (new ImageListDialog(this,0))->show();  }

void MainWin::arrangeDialog() { (new ArrangePlotDialog(this,"ArrangeDialog"))->show(); }
void MainWin::overlayDialog() { (new OverlayPlotDialog(this,"OverlayDialog"))->show();}
void MainWin::worksheetDialog() {
	if(worksheet_dialog == 0)
		worksheet_dialog = (new WorksheetDialog(this,"WorksheetDialog"));
	worksheet_dialog->show();
}

void MainWin::plotSettingsDialog() {
	if(plotsettings_dialog == 0)
		plotsettings_dialog = new PlotSettingsDialog(this,"PlotSettingsDialog");
	plotsettings_dialog->show();
}
void MainWin::axesDialog() {
	if(axes_dialog == 0)
		axes_dialog = new AxesDialog(this,"AxesDialog",0);
	axes_dialog->show();
}
void MainWin::titleDialog() {
	if (title_dialog == 0)
		title_dialog = new TitleDialog(this,"TitleDialog");
	title_dialog->show();
}
void MainWin::legendDialog() {
	if (legend_dialog == 0)
		legend_dialog = new LegendDialog(this,"LegendDialog");
	legend_dialog->show();
}
void MainWin::objectDialog() {
	if(object_dialog == 0)
		object_dialog = (new ObjectDialog(this,"ObjectDialog",0,0));
	object_dialog->show();
}

// add Graph2D to any sheet in workspace, return new item in sheetlist (for multiple plots to new sheet)
int MainWin::addGraph2D(Graph2D *g, int item, PType type) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraph2D() : type = "<<type<<" | item : "<<item<<" of "<<list.count()<<endl;

	if(item == -3)
		activeWorksheet()->addGraph2D(g,type);
	else if(item == -4)
		activeSpreadsheet()->addGraph2D(g);

	// new sheet
	if(item<0) {
		if(item==-1)
			newWorksheet()->addGraph2D(g,type);
		if(item==-2)
			newSpreadsheet()->addGraph2D(g);
		return list.count();
	}
	if(item>=(int)list.count()) {	//old items (analyis)
		if(item==(int)list.count())
			newWorksheet()->addGraph2D(g,type);
		if(item==(int)list.count()+1)
			newSpreadsheet()->addGraph2D(g);
		return list.count();
	}
	else {
		if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
			((Worksheet *) list.at(item))->addGraph2D(g,type);
		else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
			((Spreadsheet *) list.at(item))->addGraph2D(g);
	}

	return item;
}

// add Graph3D to any sheet in workspace
int MainWin::addGraph3D(Graph3D *g, int item, PType type) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraph3D() : type = "<<type<<" | item : "<<item<<" of "<<list.count()<<endl;
	if(item<0) {
		if(item==-1)
			newWorksheet()->addGraph3D(g,type);
		if(item==-2)
			newSpreadsheet()->addGraph3D(g);
		return list.count();
	}
	if(item>=(int)list.count()) {	//old items (analyis)
		if(item==(int)list.count())
			newWorksheet()->addGraph3D(g,type);
		if(item==(int)list.count()+1)
			newSpreadsheet()->addGraph3D(g);
		return list.count();
	}

	if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
		((Worksheet *) list.at(item))->addGraph3D(g,type);
	else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
		((Spreadsheet *) list.at(item))->addGraph3D(g);
	return item;
}

// add Graph4D to any sheet in workspace
int MainWin::addGraph4D(Graph4D *g, int item) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraph4D() : item : "<<item<<" of "<<list.count()<<endl;
	if(item<0) {
		if(item==-1)
			newWorksheet()->addGraph4D(g);
		if(item==-2)
			newSpreadsheet()->addGraph4D(g);
		return list.count();
	}
	if(item>=(int)list.count()) {	//old items (analyis)
		if(item==(int)list.count())
			newWorksheet()->addGraph4D(g);
		if(item==(int)list.count()+1)
			newSpreadsheet()->addGraph4D(g);
		return list.count();
	}

	if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
		((Worksheet *) list.at(item))->addGraph4D(g);
	else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
		((Spreadsheet *) list.at(item))->addGraph4D(g);
	return item;
}

// add GraphM to any sheet in workspace
int MainWin::addGraphM(GraphM *g, int item, PType type) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraphM() : type = "<<type<<" | item : "<<item<<" of "<<list.count()<<endl;
	if(item<0) {
		if(item==-1)
			newWorksheet()->addGraphM(g,type);
		if(item==-2)
			newSpreadsheet()->addGraphM(g);
		return list.count();
	}
	if(item >= (int)list.count()) {			//old style
		if(item == (int)list.count())
			newWorksheet()->addGraphM(g,type);
		if(item == (int)list.count()+1)
			newSpreadsheet()->addGraphM(g);
		return list.count();
	}

	if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
		((Worksheet *) list.at(item))->addGraphM(g,type);
	else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
		((Spreadsheet *) list.at(item))->addGraphM(g);
//		always add new spreadsheet ?
//		newSpreadsheet()->addGraphM(g);

	kdDebug()<<"MainWin::addGraphM() DONE"<<endl;
	return item;
}

// add GraphIMAGE to any sheet in workspace
int MainWin::addGraphIMAGE(GraphIMAGE *g, int item) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraphIMAGE() : item : "<<item<<" of "<<list.count()<<endl;
	if(item<0) {	// new items	(spreadsheet)
		if(item==-1)
			newWorksheet()->addGraphIMAGE(g);
		if(item==-2)
			newSpreadsheet(); // TODO : new spreadsheet
		return list.count();
	}
	if(item>=(int)list.count()) {	//old items (analyis)
		if(item==(int)list.count())
			newWorksheet()->addGraphIMAGE(g);
		if(item==(int)list.count()+1)
			newSpreadsheet(); // TODO : new spreadsheet
		return list.count();
	}

	if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
		((Worksheet *) list.at(item))->addGraphIMAGE(g);
	else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
		;//TODO : spreadsheet
	return item;
}

// add GraphL to any sheet in workspace, return new item in sheetlist (for multiple plots to new sheet)
int MainWin::addGraphL(GraphL *g, int item, PType type) {
	QWidgetList list = ws->windowList();
	kdDebug()<<"MainWin::addGraphL() : type = "<<type<<" | item : "<<item<<" of "<<list.count()<<endl;

	if(item == -3)
		activeWorksheet()->addGraphL(g,type);
	else if(item == -4)
		activeSpreadsheet()->addGraphL(g);

	// new sheet
	if(item<0) {
		if(item==-1)
			newWorksheet()->addGraphL(g,type);
		if(item==-2)
			newSpreadsheet()->addGraphL(g);
		return list.count();
	}
	if(item>=(int)list.count()) {	//old items (analyis)
		if(item==(int)list.count())
			newWorksheet()->addGraphL(g,type);
		if(item==(int)list.count()+1)
			newSpreadsheet()->addGraphL(g);
		return list.count();
	}
	else {
		if(((Worksheet *)list.at(item))->getWidgetType()==WWORKSHEET)
			((Worksheet *) list.at(item))->addGraphL(g,type);
		else if(((Spreadsheet *)list.at(item))->getWidgetType()==WSPREADSHEET)
			((Spreadsheet *) list.at(item))->addGraphL(g);
	}

	return item;
}

Style* MainWin::defaultStyle() {
	config->setGroup( "Plot Simple Style" );

	Style *style = new Style(
		(StylesType)config->readNumEntry("Graph Style",0),
		config->readColorEntry("Style Color",&Qt::blue),
		config->readBoolEntry("Filled",false),
		config->readColorEntry("Fill Color",&Qt::green),
		config->readNumEntry("Style Width",1),
		config->readNumEntry("Pen Style",1),
		config->readNumEntry("Brush",0)
		);

	style->setBoxWidth(config->readNumEntry("Box Width",10));
	style->setAutoBoxWidth(config->readBoolEntry("Auto Box Width",false));

	return style;
}

Symbol* MainWin::defaultSymbol() {
	kdDebug()<<"defaultSymbol()"<<endl;
	config->setGroup( "Plot Simple Style" );

	return new Symbol(
		(SType) config->readNumEntry("Symbol Type",SNONE),
		config->readColorEntry("Symbol Color",&Qt::blue),
		config->readNumEntry("Symbol Size",5),
		(FType) config->readNumEntry("Symbol Fill",FNONE),
		config->readColorEntry("Symbol Fill Color",&Qt::red),
		config->readNumEntry("Symbol Brush",1));
}

void MainWin::autoScaleX() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->autoScaleX();
		p->updatePixmap();
	}
}

void MainWin::autoScaleY() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->autoScaleY();
		p->updatePixmap();
	}
}

void MainWin::autoScaleZ() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->autoScaleZ();
		p->updatePixmap();
	}
}

void MainWin::autoScaleAll() {
	autoScaleX();
	autoScaleY();
	autoScaleZ();
}

//! magnify selected range
void MainWin::magLens() {
	Worksheet *p = activeWorksheet();
	p->setCursor(QCursor(Qt::CrossCursor));

	defining_maglens=1;
}

//! pan zoom
void MainWin::panZoom() { defining_panzoom=1; }

//! mask plot data
void MainWin::maskPlot() {
	Worksheet *p = activeWorksheet();
	p->setCursor(QCursor(Qt::CrossCursor));

	defining_mask=1;
}

void MainWin::shiftLeft() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftLeft();
		p->updatePixmap();
	}
}

void MainWin::shiftRight() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftRight();
		p->updatePixmap();
	}
}

void MainWin::shiftUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftUp();
		p->updatePixmap();
	}
}

void MainWin::shiftDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftDown();
		p->updatePixmap();
	}
}

void MainWin::scaleXUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleXUp();
		p->updatePixmap();
	}
}

void MainWin::scaleXDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleXDown();
		p->updatePixmap();
	}
}

void MainWin::scaleYUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleYUp();
		p->updatePixmap();
	}
}

void MainWin::scaleYDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleYDown();
		p->updatePixmap();
	}
}

void MainWin::scaleZUp() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->scaleZUp();
		p->updatePixmap();
	}
}

void MainWin::scaleZDown() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->scaleZDown();
		p->updatePixmap();
	}
}

void MainWin::zoomIn() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->zoomIn();
		p->updatePixmap();
	}
}

void MainWin::zoomOut() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->zoomOut();
		p->updatePixmap();
	}
}

void MainWin::toggleDataMode() {
	if (datamode) {
		sl->setShortcut(Qt::Key_Left);
		sr->setShortcut(Qt::Key_Right);
		datamode = false;
	}
	else {
		// make keys free for keyboard-datamode
		config->setGroup( "General Options" );
		if(config->readBoolEntry("KeyboardDataMode",false)) {
			sl->setShortcut(0);
			sr->setShortcut(0);
		}
		datamode = true;
	}
	if(Worksheet *p = activeWorksheet())
		p->updatePixmap();
}

void MainWin::defineRegion() {
	statusBar()->message(i18n("Create Region : click on left position"));
	defining_region = 1;
}

void MainWin::defineBaseline() {
	statusBar()->message(i18n("Create Baseline : click on position"));
	defining_baseline=true;
}

void MainWin::defineLine() {
	statusBar()->message(i18n("Create Line : click on first position"));
	defining_line=1;
}

void MainWin::defineLabel() {
	statusBar()->message(i18n("Create Label : click on position"));
	defining_label=true;
}

void MainWin::defineRect() {
	statusBar()->message(i18n("Create Rectangle : click on upper left corner"));
	defining_rect=1;
}

void MainWin::defineEllipse() {
	statusBar()->message(i18n("Create Ellipse : click on upper left corner"));
	defining_ellipse=1;
}

void MainWin::defineImage() {
	statusBar()->message(i18n("Create Image : click on position"));
	defining_image=true;
}

double MainWin::formatLabel(QString value,int item) {
	double v;
	switch(item) {
	case 4: {		// datetime iso
		QDateTime datetime;
		datetime = datetime.fromString(value,Qt::ISODate);
//		kdDebug()<<"DATETIME : "<<datetime.toString()<<endl;
//		kdDebug()<<"\tsecsTo1970 : "<<-datetime.secsTo(QDate(1970,1,1))<<endl;
		v = -1.0*datetime.secsTo(QDate(1970,1,1));
		} break;
	case 3: {		// datetime text
		QDateTime datetime;
		datetime = datetime.fromString(value,Qt::TextDate);
//		kdDebug()<<"DATETIME : "<<datetime.toString()<<endl;
//		kdDebug()<<"\tsecsTo1970 : "<<-datetime.secsTo(QDate(1970,1,1))<<endl;
		v = -1.0*datetime.secsTo(QDate(1970,1,1));
		} break;
	case 2: {		// date
		QDate date;
		date = date.fromString(value,Qt::ISODate);		// must be YYYY-MM-DD
		//kdDebug()<<"DATE : "<<date.toString()<<endl;
		//kdDebug()<<"\tdaysTo1970 : "<<date.daysTo(QDate(1970,1,1))<<endl;
		v = -1.0*date.daysTo(QDate(1970,1,1));
		} break;
	case 1: {		// time
		QTime time;
		time = time.fromString(value);
		v = -1.0/1000.0*time.msecsTo(QTime()); // for reading msecs
		} break;
	default:
		value.replace(QChar(','),'.');
		bool ok;
		v=value.toDouble(&ok);
		if(ok == FALSE)
			kdDebug()<<"ERROR converting "<<value<<" to double"<<endl;

	}

	return v;
}

//! calculate ranges (GRAPH2D) for new create graphs (analysis)
void MainWin::calculateRanges2D(Point *a, int n, double *xmin, double *xmax,
	double *ymin, double *ymax) {

	*xmin=*xmax=a[0].X();
	*ymin=*ymax=a[0].Y();
	for (int i=1;i<n;i++) {
		a[i].X()<*xmin?*xmin=a[i].X():0;
		a[i].X()>*xmax?*xmax=a[i].X():0;
		a[i].Y()<*ymin?*ymin=a[i].Y():0;
		a[i].Y()>*ymax?*ymax=a[i].Y():0;
	}
}

//! calculate ranges (GRAPH3D) for new create graphs (analysis)
void MainWin::calculateRanges3D(Point3D *a, int n, double *xmin, double *xmax,
	double *ymin, double *ymax, double *zmin, double *zmax) {

	*xmin=*xmax=a[0].X();
	*ymin=*ymax=a[0].Y();
	*zmin=*zmax=a[0].Z();
	for (int i=1;i<n;i++) {
		a[i].X()<*xmin?*xmin=a[i].X():0;
		a[i].X()>*xmax?*xmax=a[i].X():0;
		a[i].Y()<*ymin?*ymin=a[i].Y():0;
		a[i].Y()>*ymax?*ymax=a[i].Y():0;
		a[i].Z()<*zmin?*zmin=a[i].Z():0;
		a[i].Z()>*zmax?*zmax=a[i].Z():0;
	}
}

//! calculate ranges (GRAPH4D) for new create graphs (analysis)
void MainWin::calculateRanges4D(Point4D *a, int n, double *xmin, double *xmax,
	double *ymin, double *ymax, double *zmin, double *zmax, double *tmin, double *tmax) {

	*xmin=*xmax=a[0].X();
	*ymin=*ymax=a[0].Y();
	*zmin=*zmax=a[0].Z();
	*tmin=*tmax=a[0].T();
	for (int i=1;i<n;i++) {
		a[i].X()<*xmin?*xmin=a[i].X():0;
		a[i].X()>*xmax?*xmax=a[i].X():0;
		a[i].Y()<*ymin?*ymin=a[i].Y():0;
		a[i].Y()>*ymax?*ymax=a[i].Y():0;
		a[i].Z()<*zmin?*zmin=a[i].Z():0;
		a[i].Z()>*zmax?*zmax=a[i].Z():0;
		a[i].T()<*tmin?*tmin=a[i].T():0;
		a[i].T()>*tmax?*tmax=a[i].T():0;
	}
}
