//LabPlot : NoiseListDialog.h

#ifndef NOISELISTDIALOG_H
#define NOISELISTDIALOG_H

#include "ListDialog.h"

class NoiseListDialog : public ListDialog
{
	Q_OBJECT
public:
	NoiseListDialog(MainWin *mw, const char *name);
public slots:
	int Type() { return typecb->currentItem(); }		//!< type of filter
	void setType(int t) { typecb->setCurrentItem(t); }	//!< set type of filter
	double Parameter1() { return par1le->text().toDouble(); }		//!< get first parameter
	void setParameter1(double p) { par1le->setText(QString::number(p)); }	//!< set first parameter
	double Parameter2() { return par2le->text().toDouble(); }		//!< get second parameter
	void setParameter2(double p) { par2le->setText(QString::number(p)); }	//!< set second parameter
	double Parameter3() { return par3le->text().toDouble(); }		//!< get third parameter
	void setParameter3(double p) { par3le->setText(QString::number(p)); }	//!< set third parameter
	int Apply() { return apply_clicked(); }
private:
	KComboBox *typecb;
	KLineEdit *par1le, *par2le, *par3le;
	QLabel *label1, *label2, *label3;
private slots:
	void saveSettings();
	int apply_clicked();
	void updateType(int);
};

#endif // NOISELISTDIALOG_H
