//LabPlot : DataDialog.h

#ifndef DATADIALOG_H
#define DATADIALOG_H

#include <qtoolbutton.h>
#include <qcheckbox.h>
#include "Dialog.h"
#include "GraphListDialog.h"
#include "FilterAUDIOFILE.h"

/*! Main class for Data Dialog*/
class DataDialog: public Dialog
{
	Q_OBJECT
public:
	DataDialog(Worksheet *p, const char *name,class ListDialog *l,int item,PType newtype);
public slots:
	void selectFile();
	void applyStyle();
	void setLabel(){ labelle->setText(filele->text()); }
private slots :
	void checkData();
	void updateRead();
	int addData();
	int agree();
	void ok_clicked() { if (!agree()) accept(); }
private:
	class MainWin *mw;
	double getValue(FilterAUDIOFILE auf,int var, int i,double *data, int startRow);
	PType type;
	QLabel *readx, *ready, *readz, *readt;
	KLineEdit *readxle, *readyle, *readzle, *readtle;
	KLineEdit *labelle;
	KComboBox *interpretxcb, *interpretycb, *interpretzcb, *interprettcb;
	KComboBox *cbi;	// Graph Type, Input
	QCheckBox *reread;
	KLineEdit *readsc, *commle, *startrow, *endrow;
	ListDialog *l;
	int item;
	Graph *graph;
};
#endif //DATADIALOG_H
