//LabPlot : AxesDialog.h

#ifndef AXESDIALOG_H
#define AXESDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>
#include <klistbox.h>
#include "MainWin.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class AxesDialog: public Dialog
{
	Q_OBJECT
public:
	AxesDialog(Worksheet *p, const char *name, int axesnr);
public slots:
	void selectTicsFont();
	void setTicsColor(const QColor &color) { tc = QColor(color); }
	void setTicsLabelColor(const QColor &color) { tlc = QColor(color); }
	void setGridColor(const QColor &color) { gc = QColor(color); }
	void setBorderColor(const QColor &color) { bc = QColor(color); }
	void updateAxis();
	void update_timeformat();
	void updateScale(int i);
	void axisEnabled(bool on);
	void ok_clicked();
	void apply_clicked();
private:
	Plot *plot;
	int type;
	RichTextWidget *rtw;
	KLineEdit *scaling, *shift, *ticsfont, *min, *max, *major, *minor, *tlple, *tlgle;
	KLineEdit *tlprefix, *tlsuffix, *timeformat, *tlrotation;
	KListBox *axeslb;
	QCheckBox *cb, *cb2, *cb3, *cb4, *cb5, *cb6;
	KColorButton *tcb, *tlcb, *gcb, *bcb;
	KComboBox *atlfcb, *ascb, *ticsposcb;
	QFont tf;
	QColor tc, tlc, gc, bc;
	Axis *axis[12];
};
#endif //AXESDIALOG_H
