//LabPlot : Arrow.cc

#include <math.h>
#include <iostream>
#include "Arrow.h"

using namespace std;

Arrow::Arrow(bool l,bool e,double le,double a,bool f,QColor fc)
	: location(l),enabled(e), length(le), angle(a),filled(f),fillcolor(fc)
{}

QStringList Arrow::Info() {
	QStringList s;

	s << QString::number(enabled) << QString::number(length);
	s << QString::number(angle);
	s << QString::number(filled);
	s << fillcolor.name();
	
	return s;
}

// draw the arrow on the worksheet
void Arrow::draw(QPainter *p, Point start, Point end,int X, int Y) {
	int sx = (int) (X*start.X()), sy = (int) (Y*start.Y());
	int ex = (int) (X*end.X()), ey = (int)(Y*end.Y());
	double dx = (ex-sx)*length;
	double dy = (ey-sy)*length;
	QPointArray a;
	
	if (enabled) {
		double l = length*sqrt(dx*dx+dy*dy);
		double a1 = M_PI*angle/180.0 + atan(dy/dx);
		double a2 = - M_PI*angle/180.0 + atan(dy/dx);
		if(location==0) {	//start
			int x1 = sx+(int) (l*cos(a1));
			int y1 = sy+(int) (l*sin(a1));
			int x2 = sx+(int) (l*cos(a2));
			int y2 = sy+(int) (l*sin(a2));
			if (filled) {
				p->setBrush(fillcolor);
	                        a.setPoints(3,sx,sy,x1,y1,x2,y2);
        	                p->drawPolygon(a);
			}
			else {
				p->drawLine(sx,sy,x1,y1);
				p->drawLine(sx,sy,x2,y2);
			}
		}
		else {		// end
			int x1 = ex-(int) (l*cos(a1));
			int y1 = ey-(int) (l*sin(a1));
			int x2 = ex-(int) (l*cos(a2));
			int y2 = ey-(int) (l*sin(a2));
			if (filled) {
				p->setBrush(fillcolor);
	                        a.setPoints(3,ex,ey,x1,y1,x2,y2);
        	                p->drawPolygon(a);
			}
			else {
				p->drawLine(ex,ey,x1,y1);
				p->drawLine(ex,ey,x2,y2);
			}
		}
	}
}

void Arrow::save(QTextStream *t){
	*t<<(int)location<<' '<<(int)enabled<<' '<<length<<' '<<angle<<' '<<(int)filled<<' '<<fillcolor.name()<<endl;
}

void Arrow::open(QTextStream *t,int version) {
	QString color;
	int l,e,f;

	*t>>l>>e>>length>>angle>>f>>color;
	location=l;
	enabled=e;
	filled=f;
	fillcolor=QColor(color);
}
