(* Copyright (C) 2000-2003, Luca Padovani <luca.padovani@cs.unibo.it>,
 *                          Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>.
 *
 * This file is part of lablgtkmathview, the Ocaml binding
 * for the GtkMathView widget.
 * 
 * lablgtkmathview is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * lablgtkmathview is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with lablgtkmathview; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

exception ErrorLoadingFile of string
exception ErrorWritingFile of string
exception ErrorLoadingDOM

class math_view_signals :
  ([> `gtk | `mathview_gmetadom | `widget] as 'b) Gtk.obj ->
  object ('a)
    inherit GObj.widget_signals
    val after: bool
    val obj: 'b Gtk.obj
    method click :
      callback:(Gdome.element option * int * int * int -> unit) -> GtkSignal.id
    method element_over :
      callback:(Gdome.element option * int * int * int -> unit) -> GtkSignal.id
    method select_begin :
      callback:(Gdome.element option * int * int * int -> unit) -> GtkSignal.id
    method select_over :
      callback:(Gdome.element option * int * int * int -> unit) -> GtkSignal.id
    method select_end :
      callback:(Gdome.element option * int * int * int -> unit) -> GtkSignal.id
    method select_abort :
      callback:(unit -> unit) -> GtkSignal.id
  end

class math_view_skel :
  (Gtk_mathview.math_view Gtk.obj as 'a)->
  object
    inherit GObj.widget
    method freeze : unit
    method thaw : unit
    method get_buffer : Gdk.pixmap
    method get_font_size : int
    method get_adjustments : GData.adjustment * GData.adjustment
    method get_size : int * int
    method get_log_verbosity : int
    method get_top : int * int
    method load_uri : filename:string -> unit
    method load_root : root:Gdome.element -> unit
    method set_adjustments : GData.adjustment -> GData.adjustment -> unit
    method set_font_size : int -> unit
    method set_log_verbosity : int -> unit
    method structure_changed : Gdome.element -> unit
    method attribute_changed : Gdome.element -> name:Gdome.domString -> unit
    method get_bounding_box : int * int * int
    method select : Gdome.element -> unit
    method unselect : Gdome.element -> unit
    method get_element_at : int -> int -> Gdome.element option
    method is_selected : Gdome.element -> bool
    method set_top : int -> int -> unit
    method unload : unit
    val obj : 'a
  end

class math_view :
  Gtk_mathview.math_view Gtk.obj ->
  object
    inherit math_view_skel
    method connect : math_view_signals
  end

val math_view :
  ?hadjustment:GData.adjustment ->
  ?vadjustment:GData.adjustment ->
  ?font_size:int ->
  ?log_verbosity:int ->
  ?width:int ->
  ?height:int ->
  ?packing:(GObj.widget -> unit) -> ?show:bool -> unit -> math_view
