/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KPROFILEWIDGET_H
#define KPROFILEWIDGET_H

#include <qwidget.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <qheader.h>
#include <qlabel.h>
#include <qstringlist.h>

#include <kiconloader.h>
#include <kinputdialog.h>
#include "kwavecontrol.h"

#include "wcardlib.h"

class WWidget;

class Profile
{
public:
	QString essid;
	double frequency;
	QString ip;
	QString gateway;
	int mode;
	int security;
	QString key;
	int keyIndex;
};

/**
@author Matthias Reif
*/
class KProfileWidget : public QWidget
{
Q_OBJECT
public:
	KProfileWidget( WWidget* wWidget, QWidget *parent = 0, const char *name = 0 );
	~KProfileWidget();
	void restoreProfiles();
protected:
	KListView* listView;
	KPushButton* loadButton;
	KPushButton* saveButton;
	KPushButton* removeButton;
	void resizeEvent ( QResizeEvent * );
	WWidget* wWidget;
	KConfig* config;
	
protected slots:
	void loadSlot();
	void saveSlot();
	void removeSlot();
	void selectionChangedSlot();
};

#endif
