#ifndef _KVI_SCRIPT_SOCKET_H_INCLUDED_
#define _KVI_SCRIPT_SOCKET_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_script_object.h"

class QSocketNotifier;

class KviScriptSocket : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptSocket(KviScriptObjectController *, KviScriptObject *, const char *name, KviScriptObjectClassDefinition *);
	~KviScriptSocket();
protected:
	int              m_sock;
	int              m_type;
	int              m_protocol;
	int              m_domain;
	int              m_error;
	int              m_iReadBufLen;
	char            *m_pReadBuffer;

	enum DataMode { Ascii, Hex };
	enum SockState { Ready, Connecting, Connected, Listening };

	DataMode         m_mode;
	SockState        m_state;
	KviStr           m_szHostIp;
	KviStr           m_szPort;
	QSocketNotifier *m_pRsn;
	QSocketNotifier *m_pTmpSn;
	int              m_incomingConnectionSock;
	KviStr           m_szIncomingConnectionPort;
	KviStr           m_szIncomingConnectionHostIp;
	KviStr           m_szLocalHostIp;
public:
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int        builtinFunction_MODE(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_SETDOMAIN(QPtrList<KviStr> *params, KviStr &buffer);
	int     builtinFunction_SETTYPE(QPtrList<KviStr> *params, KviStr &buffer);
	int     builtinFunction_SETMODE(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETPROTOCOL(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_WRITE(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_WRITEHEX(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_CLOSE(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_PROTOCOL(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_TYPE(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_HOST(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_PORT(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_STATE(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_DOMAIN(QPtrList<KviStr> *params, KviStr &buffer);
	int     builtinFunction_CONNECT(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_LISTEN(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_LASTERROR(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_ACCEPT(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_LOCALHOST(QPtrList<KviStr> *params, KviStr &buffer);
private:
	void setLocalHostIp();
	bool doListen(KviStr *szLocalAddr, KviStr *szPort);
	bool doConnect(KviStr *szHost, KviStr *szPort);
	void setErrorFromSystemError(int errorNum);
	void reset();
	void handleInvalidSocketRead(int readLength);
	int  writeData(char *buffer, int len);
	bool doAccept(const char *sockObjectId);
	bool hasPendingConnection();
private slots:
	void  writeNotifierFired(int fd);
	void listenNotifierFired(int fd);
	void        receivedData(int fd);
};

#endif // _KVI_SCRIPT_SOCKET_H_INCLUDED_
