#ifndef _KVI_SCRIPT_EDITORWIDGET_H_INCLUDED_
#define _KVI_SCRIPT_EDITORWIDGET_H_INCLUDED_

// =============================================================================
//
//      --- kvi_script_editorwidget.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qtextedit.h>

class QFontMetrics;

class KviCompletionBox;
class KviSyntaxHighlighter;

class KviScriptEditorWidget : public QTextEdit
{
	Q_OBJECT
public:
	KviScriptEditorWidget(QWidget *parent);
	~KviScriptEditorWidget();
signals:
	void cursorRowChanged(int row);
	void cursorColChanged(int col);
	void message(const QString &);
protected slots:
	void textChanged();
	void insertCompletion(const QString &);
protected:
	void completion();

	KviStr  getWordBeforeCursor();

	virtual void setFont(const QFont &font);
	virtual void keyPressEvent(QKeyEvent *);
private:
	KviCompletionBox     *m_pCompletionBox;
	KviSyntaxHighlighter *m_pHighlighter;
	QFontMetrics         *m_pFm;

	int m_currentParagraph;
	int m_currentIndex;
};

#endif // _KVI_SCRIPT_EDITORWIDGET_H_INCLUDED_
