// =============================================================================
//
//      --- kvi_codetester.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviCodeTester"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_codetester.h"
#include "kvi_console.h"
#include "kvi_frame.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"
#include "kvi_script_editor.h"
#include "kvi_string.h"
#include "kvi_userparser.h"
#include "kvi_window.h"

// TODO: Totally missing quick help!

KviStr g_szLastCodeTesterBuffer = "";

/*
	@quickhelp: KviCodeTester
	@widget: Script tester
		This tab allows you to test multiline code.<br>
		Since the commandline widget does not allow multiline code to be executed,
		you can enter it here and click "Execute".<br>
		You can specify a window for the command to be executed in.<br>
		If you do not specify a window, or if the target window does not exist,
		the command buffer will be executed in the first session's Console.<br>
		If you still do not understand what this tab does, type in the editor:<br>
		<example>
			<a href="echo.kvihelp">echo</a> "Hello in <a href="s_window.kvihelp">$window</a>!"
		</example>
		click "Execute" and watch the Console window.<br>
*/

/**
 *
 * CODE TESTER
 *
 * This widget allows testing of the script code
 *
 */
KviCodeTester::KviCodeTester(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	QGridLayout *g = new QGridLayout(this, 2, 3, 4, 2);

	m_pCodeEditor = new KviScriptEditor(this);
	g->addMultiCellWidget(m_pCodeEditor, 0, 0, 0, 2);
	m_pCodeEditor->setText(g_szLastCodeTesterBuffer.ptr());
	KviPushButton *pb = new KviPushButton(_i18n_("E&xecute"), this);
	g->addWidget(pb, 1, 2);
	KviLabel *lb = new KviLabel(_i18n_("Window:"), this);
	g->addWidget(lb, 1, 0);
	m_pWindowNameEdit = new KviLineEdit(this);
	g->addWidget(m_pWindowNameEdit, 1, 1);
	g->setColStretch(1, 1);
	g->setRowStretch(0, 1);
	connect(pb, SIGNAL(clicked()), this, SLOT(test()));
}

KviCodeTester::~KviCodeTester()
{
	// Nothing here
}

void KviCodeTester::test()
{
	KviStr tmp = m_pCodeEditor->text();

	KviStr szWnd = m_pWindowNameEdit->text();
	KviWindow *wnd = 0;
	KviFrame *theFrame = 0;
	if( szWnd.hasData() ) {
		for( KviFrame *f = g_pApp->m_pFrameList->first(); f; f = g_pApp->m_pFrameList->next() ) {
			wnd = f->findWindow(szWnd.ptr());
			if( wnd ) {
				theFrame = f;
				break;
			}
		}
	}
	if( !wnd ) {
		theFrame = g_pApp->m_pFrameList->first();
		wnd = theFrame->m_pConsole;
	}
	if( theFrame )
		theFrame->m_pUserParser->parseCommand(tmp.ptr(), wnd);
}

#include "m_kvi_codetester.moc"
