// =============================================================================
//
//      --- kvi_maskeditor.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMaskEditor"

#include <qlayout.h>

#include "kvi_banmask.h"
#include "kvi_label.h"
#include "kvi_listview.h"
#include "kvi_locale.h"
#include "kvi_maskeditor.h"
#include "kvi_pushbutton.h"

KviMaskEditor::KviMaskEditor(QWidget *parent)
	: QFrame(parent)
{
	setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	setFocusPolicy(ClickFocus);

	QGridLayout *g = new QGridLayout(this, 5, 1, 2, 2);

	m_pLabel = new KviLabel("", this);
	g->addWidget(m_pLabel, 0, 0);


	m_pMaskBox = new KviListView(this);
	m_pMaskBox->setFocusPolicy(ClickFocus);
	m_pMaskBox->setFocusProxy(this);
	m_pMaskBox->addColumn(_CHAR_2_QSTRING(_i18n_(" - Mask - List - ")));
	m_pMaskBox->addColumn(_CHAR_2_QSTRING(_i18n_("Set by")));
	m_pMaskBox->addColumn(_CHAR_2_QSTRING(_i18n_("Set at")));
	m_pMaskBox->setMultiSelection(true);
	g->addWidget(m_pMaskBox, 1, 0);

	m_pRemoveMask  = new KviPushButton(_i18n_("&Remove"), this);
	m_pRemoveMask->setFocusPolicy(ClickFocus);
	m_pRemoveMask->setFocusProxy(this);
	connect(m_pRemoveMask, SIGNAL(clicked()), this, SLOT(removeMaskClicked()));
	g->addWidget(m_pRemoveMask, 2, 0);

	m_pCommit = new KviPushButton(_i18n_("&OK"), this);
	m_pCommit->setFocusPolicy(ClickFocus);
	m_pCommit->setFocusProxy(this);
	connect(m_pCommit, SIGNAL(clicked()), this, SLOT(commitChanges()));
	g->addWidget(m_pCommit, 3, 0);

	KviPushButton *b = new KviPushButton(_i18n_("&Cancel"), this);
	b->setFocusPolicy(ClickFocus);
	b->setFocusProxy(this);
	connect(b, SIGNAL(clicked()), this, SLOT(cancelClicked()));
	g->addWidget(b, 4, 0);
}

KviMaskEditor::~KviMaskEditor()
{
	// Nothing here
}

void KviMaskEditor::doEdit(
	QObject *receiver, const char *slot, QPtrList<KviBanMask> *maskList, const char *masksLabel, bool canCommit)
{
	disconnect(this, SIGNAL(masksEditCompleted(const char *)), 0, 0);
	connect(this, SIGNAL(masksEditCompleted(const char *)), receiver, slot);
	KviStr mLabel(KviStr::Format, "<b>%s List</b>", masksLabel);
	m_pLabel->setText(mLabel.ptr());
	setMasks(maskList, masksLabel);
	m_pCommit->setEnabled(canCommit);
	m_pRemoveMask->setEnabled(canCommit && (m_pMaskBox->childCount() > 0));
	m_szMasksRemoved = "";
	show();
	setFocus();
}

void KviMaskEditor::setMasks(QPtrList<KviBanMask> *maskList, const char *masksLabel)
{
	m_pMaskBox->clear();
	m_pMaskBox->setColumnText(0, _CHAR_2_QSTRING(masksLabel));
	KviListViewItem *i = 0;
	for( KviBanMask *b = maskList->first(); b; b = maskList->next() ) {
		i = new KviListViewItem(m_pMaskBox,
			_CHAR_2_QSTRING(b->mask.ptr()), _CHAR_2_QSTRING(b->setBy.ptr()), _CHAR_2_QSTRING(b->setAt.ptr())
		);
	}
}

void KviMaskEditor::setCanCommit(bool bCanCommit)
{
	m_pCommit->setEnabled(bCanCommit);
	m_pRemoveMask->setEnabled(bCanCommit && (m_pMaskBox->childCount() > 0));
}

void KviMaskEditor::removeMaskClicked()
{
	KviListViewItem *it = m_pMaskBox->firstChild();
	while( it ) {
		if( it->isSelected() ) {
			if( m_szMasksRemoved.hasData() )
				m_szMasksRemoved += " ";
			m_szMasksRemoved += it->text(0);
			KviListViewItem *tmp = it;
			it = it->nextSibling();
			delete tmp;
		} else it = it->nextSibling();
	}
	m_pRemoveMask->setEnabled(m_pMaskBox->childCount() > 0);
}

void KviMaskEditor::commitChanges()
{
	emit masksEditCompleted(m_szMasksRemoved.ptr());
}

void KviMaskEditor::cancelClicked()
{
	emit masksEditCompleted("");
}

#include "m_kvi_maskeditor.moc"
