#ifndef _KVI_DCC_SEND_THREAD_H_INCLUDED_
#define _KVI_DCC_SEND_THREAD_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_send_thread.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qdatetime.h>

#include "kvi_dcc_thread.h"
#include "kvi_string.h"

class QFile;

class KviDccSend;
class KviMutex;

typedef struct KviDccSendData
{
	KviStr           nick;
	KviStr           username;
	KviStr           host;
	KviStr           filePath;
	KviStr           originalFileName;
	unsigned long    fileLength;
	unsigned long    uAddress;
	KviStr           szAddress;
	KviStr           tmpBuffer;
	unsigned short   uPort;
	unsigned long    receivedBytes;      // Absolute
	unsigned long    realBytesCount;     // Relative (resume)
	unsigned long    sentBytes;          // Absolute
	unsigned long    realSentBytesCount; // Relative (resume)
	unsigned int     ackedBytes;
	unsigned long    stalledCount;
	int              blockSize;
	QTime            startTime;
	KviDccSend      *parent;
	QFile           *file;
	bool             bListening;
	KviMutex        *resumeMutex;
	bool             bFastSend;
	bool             bGetSession;        // DCC send or get?
	bool             bSendZeroAck;       // Simulate bug in get sessions
	unsigned short   uPortToListenOn;
};

class KviDccSendThread : public KviDccThread
{
public:
	KviDccSendThread(KviDccSendData *);
	~KviDccSendThread();
protected:
	KviDccSendData *m_pData;
};

class KviDccSendAcceptThread : public KviDccSendThread
{
public:
	KviDccSendAcceptThread(KviDccSendData *);
	~KviDccSendAcceptThread();

	virtual void run();

	void eventLoop();

	bool readData();
	void sendAck();

	void getPostStatusEvent();
};

class KviDccSendRequestThread : public KviDccSendThread
{
public:
	KviDccSendRequestThread(KviDccSendData *);
	~KviDccSendRequestThread();

	virtual void run();

	void eventLoop();

	void writeData();
	void receiveAck();

	void sendPostStatusEvent();
	void sendNotifyStalled();
};

#endif // _KVI_DCC_SEND_THREAD_H_INCLUDED_
