#ifndef _KVI_MDI_CHILD_H_INCLUDED_
#define _KVI_MDI_CHILD_H_INCLUDED_

// =============================================================================
//
//      --- kvi_mdi_child.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

class QPixmap;

class KviMdiButton;
class KviMdiManager;

/**
 * A MDI child widget: usually you do not need to derive from this class.
 */
class KviMdiChild : public QFrame
{
	friend class KviMdiManager;
	friend class KviMdiCaption;
	Q_OBJECT
public:
	enum MdiWindowState { Normal, Maximized, Minimized };

	/**
	 * Creates a new KviMdiChild class.
	 */
	KviMdiChild(KviMdiManager *parent, const char *name = 0);

	/**
	 * Warning: destroys this KviMdiChild.
	 * If a child is still here managed (no copy was made), it is destroyed too.
	 */
	~KviMdiChild();
public:
	QWidget *m_pClient;
protected:
	KviMdiManager *m_pManager;
	KviMdiCaption *m_pCaption;

	KviMdiButton  *m_pMinimize;
	KviMdiButton  *m_pMaximize;
	KviMdiButton  *m_pClose;

	MdiWindowState m_state;
	QRect          m_restoredRect;
	int            m_iResizeCorner;
	int            m_iLastCursorCorner;
	bool           m_bResizeMode;
public:
	/**
	 * Reparents the widget w to this KviMdiChild (if this is not already done).<br>
	 * Installs an event filter to catch focus events.<br>
	 * Resizes this MDI child in a way that the child fits in perfectly.
	 */
	void setClient(QWidget *w);

	/**
	 * Reparents the client widget to 0 (desktop)
	 * Removes the event filter.
	 */
	void unsetClient();

	/**
	 * Sets the window icon pointer: assumes 16x16 pixmaps that SHOULD BE NOT DELETED
	 * until this object is destroyed.
	 */
	void setIconPointer(QPixmap *ptr);

	/**
	 * Enables or disables the close button.
	 */
	void enableClose(bool bEnable);
	bool closeEnabled();

	/**
	 * Sets the caption of this window.
	 */
	void setCaption(const char *text);

	/**
	 * Returns the caption of this MDI child.
	 */
	const char *caption();

	/**
	 * Minimizes, maximizes or restores the window.
	 */
	void setState(MdiWindowState state, bool bAnimate = true);

	/**
	 * Returns the current state of the window
	 */
	MdiWindowState state();

	/**
	 * Forces updating the rects of the caption etc...
	 * It may be useful when setting the mdiCaptionFont of the MdiManager
	 */
	void updateRects();
private:
	void   linkChildren(QWidget *);
	void unlinkChildren(QWidget *);
	int getResizeCorner(int ax, int ay);
protected slots:
	void maximizePressed();
	void minimizePressed();
	void closePressed();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual void leaveEvent(QEvent *);
	virtual bool eventFilter(QObject *, QEvent *);
	virtual void focusInEvent(QFocusEvent *);
	virtual void    mouseMoveEvent(QMouseEvent *);
	virtual void   mousePressEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
	void resizeWindow(int resizeCorner);
	void resizeWindowOpaque(int resizeCorner);
	void moveWindow();
	void moveWindowOpaque(QPoint diff);
	void setResizeCursor(int resizeCorner);
	QCursor getResizeCursor(int resizeCorner);
	void calculateResizeRect(int resizeCorner, QPoint mousePos, QRect &resizeRect, int minWidth, int minHeight);
	void calculateMinimumSize(int &minWidth, int &minHeight);
public:
	virtual void activate(bool bSetFocus);
};

#endif // _KVI_MDI_CHILD_H_INCLUDED_
