/*
	confirmation.cpp - A confirmation dialog
	Copyright (C) 2005  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "confirmation.h"
#include "mmainwindow.h"
#include "msystemtray.h"

#include <kdialogbase.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kwin.h>

// public

bool Confirmation::confirm(const Action::Type action)
{
	KWin::setOnDesktop(ks_main->winId(), KWin::currentDesktop());

	QWidget *parent;
	if (ks_main->isVisible())
		parent = ks_main;
	else if (MSystemTray::isInstance() && ks_tray->isVisible())
		parent = ks_tray;
	else
		parent = 0;

	/*
	QWidget *background = new QWidget(0, "QWidget::background", Qt::WType_Popup);
	background->setBackgroundMode(Qt::NoBackground);
	background->setGeometry(kapp->desktop()->geometry());
	// Take screenshot - based on the aKregator's TrayIcon::takeScreenshot() (trayicon.cpp)
	// and "ksmserver/shutdown.cpp".
	QPixmap shot = QPixmap::grabWindow(
		qt_xrootwin(),
		0, 0, // x, y
		kapp->desktop()->width(), kapp->desktop()->height()
	);
	QImage shotImage = shot.convertToImage();
	KImageEffect::flatten(shotImage, Qt::green, Qt::black);
	bitBlt(background, 0, 0, &shotImage);
	background->show();
	*/

	KDialogBase *dialog = new KDialogBase(
		i18n("Confirm"), // caption
		KDialogBase::Yes | KDialogBase::No, // button mask
		KDialogBase::Yes, // default button
		KDialogBase::No, // escape button
		parent,
		"Action::confirm",
		true, // modal
		false, // separator
		KGuiItem(ks_actions->getName(action), ks_actions->getIcon(action)),
		KGuiItem(i18n("&Cancel"), SmallIcon("button_cancel"))
	);
	bool checkboxResultDummy = false;
	bool result = (KMessageBox::createKMessageBox(
		dialog,
		MainBarIcon(ks_actions->getIconName(action), 32),
		i18n("Are you sure?"),
		QStringList(),
		QString::null,
		&checkboxResultDummy,
		KMessageBox::Notify
	) == KDialogBase::Yes);

	return result;
}
