/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../ballistics.h"
#include "../terrain.h"
#include "../aiexterns.h"
#include "../log.h"
#include "dfa.h"

Shellstat_bal
wepDFAGuidance(void *info, struct Projectilepos_bal *prjpos,
	       Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
					      prjpos, void **explosioninfo),
	       void **explosioninfo)
{
    Shellstat_bal res;
    Player_pl *pcur, *plhit = NULL;
    /*Weapon_wep *bs;
    struct Projectilelist_bal *prj; */
    int over_tank = 0, ix, iy;

    prjpos->rox = prjpos->ox = prjpos->x;
    prjpos->roy = prjpos->oy = prjpos->y;
    prjpos->x += prjpos->vx;
    prjpos->y += prjpos->vy;
    prjpos->vy -= bal_grav / bal_lerp_tweak;

    if((res = balEnvironmentAdjustProjPos(prjpos)) != FLYING
       || balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y,
			    &plhit, &ix, &iy))
    {
	if(plLookupPlayer(prjpos->id))
	{
	    logPrintf(DEBUG, "Intersection at (%i, %i) of %s's shot\n", ix,
		      iy, plLookupPlayer(prjpos->id)->name);
	}
	else
	{
	    logPrintf(DEBUG, "Intersection at (%i, %i) of null's shot\n", ix,
		      iy);
	}
	if(plhit != NULL)
	    logPrintf(DEBUG, "and hit %s\n", plhit->name);
	switch (res)
	{
	    case HOLDING:
		/* wtf ??? */
		break;
	    case FLYING:
		prjpos->x = ix;
		prjpos->y = iy;
		/* fall through */
	    case EXPLODING:
		return initexplosion(prjpos, explosioninfo);
		break;
	    case FREEING:
		return FREEING;
		break;
	}
    }

    for(pcur = pl_begin; pcur; pcur = pcur->next)
    {
	if(prjpos->vx > 0)
	{
	    if((pcur->x >= prjpos->ox) && (pcur->x <= prjpos->x)
	       && (pcur->armor > 0))
	    {
		over_tank = 1;
		break;
	    }
	}
	else
	{
	    if((pcur->x >= prjpos->x) && (pcur->x <= prjpos->ox)
	       && (pcur->armor > 0))
	    {
		over_tank = 1;
		break;
	    }
	}
    }
    if(over_tank)
    {
        prjpos->x=pcur->x;
        prjpos->x-=(bal_wind/bal_lerp_tweak); /* fix for wind next time */
        prjpos->vx=0;
        prjpos->vy=-20;
	/*bs = wepLookupWeapon("Large Shell");
	prj = balNewShotXY(prjpos->id, 0, pcur->x, prjpos->y, 0, -20, bs);
	prj->stat = INITSHOT(prj);

	return initexplosion(prjpos, explosioninfo);*/
    }

    return FLYING;
}
