/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../ballistics.h"
#include "../terrain.h"
#include "dirt.h"

Shellstat_bal wepDirtExplosionInit(struct Projectilepos_bal *prjpos, void** explosioninfo)
{
    struct SimpleExplosion_wep *e = (struct SimpleExplosion_wep*)malloc(sizeof(struct SimpleExplosion_wep));

    e->x=prjpos->x;
    e->y=prjpos->y;
    e->r=0;
    e->dx=8;
	e->id=prjpos->id;
    e->max_radius=225;
    
    *((struct SimpleExplosion_wep**)explosioninfo)=e;
    return EXPLODING;
}

Shellstat_bal wepDirtExplosion(void* info)
{
    struct SimpleExplosion_wep *prj = (struct SimpleExplosion_wep *)info;
	
    prj->r+=prj->dx;
    if(prj->r > prj->max_radius)
    {
		return FREEING;
    }
    else /* amazing how much the word "else" looks like the face of Yoda at 4:16 in the morning */
    {
		terAddCircle(prj->x, prj->y, prj->r);
		return EXPLODING;
    }    
}

