
#include <string.h>
#include <kore/version.h>

using namespace kore;

Version::Version()
{
    setVersion();
}
Version::Version(const int major,const int minor,const int revision,const char* version)
{
    setVersion(major, minor, revision, version);
}

//Version::Version(Version& other)
//{
//    _major = other._major;
//    _minor = other._minor;
//    _revision = other._revision;
//    _version = other._version;
//}

Version::~Version()
{
    // let the user deal with allocated memory
//    delete _version;
}

const int Version::major() const
{
    return _major;
}
const int Version::minor() const
{
    return _minor;
}
const int Version::revision() const
{
    return _revision;
}
const char* Version::string() const
{
    return _version;
}
Version::operator const char*() const
{
    return _version;
}
const bool Version::operator ==(const Version& other) const
{
    return (this == &other) || ((_major == other._major) && (_minor == other._minor) && (_revision == other._revision));
}
const bool Version::operator !=(const Version& other) const
{
    return !(*this == other);
}
const bool Version::operator <(const Version& other) const
{
    return (this != &other) && ((_major < other._major) ||
        (( _major == other._major) && (_minor < other._minor)) ||
        (( _major == other._major) && (_minor == other._minor) && (_revision < other._revision)));
}
const bool Version::operator <=(const Version& other) const
{
    return (*this == other) || (*this < other);
}
const bool Version::operator >(const Version& other) const
{
    return !(*this <= other);
}
const bool Version::operator >=(const Version& other) const
{
    return !(*this < other);
}
const bool Version::operator &(const Version& other) const
{
    return true;
}
const bool Version::operator &&(const Version& other) const
{
    return true;
}

void Version::setMajor(const int major)
{
    _major = major;
}
void Version::setMinor(const int minor)
{
    _minor = minor;
}
void Version::setRevision(const int revision)
{
    _revision = revision;
}
void Version::setString(const char* version)
{
    // let the user deal with allocated memory
/*    delete _version;
    _version = 0;
    if( version )
    {
        size_t len = strlen(version);
        _version = new char[len+1];
        strcpy( _version, version );
    }
*/
    _version = version;
}
void Version::setVersion(const int major,const int minor,const int revision,const char* version)
{
    setMajor(major);
    setMinor(minor);
    setRevision(revision);
    setString(version);
}
