
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/pluginloader.h>
#include <kore/modulemanager.h>
#include <kore/pluginmanager.h>

#define KERNEL_MAJOR 0
#define KERNEL_MINOR 0
#define KERNEL_REVISION 1
#define KERNEL_VERSION "0.0.1"
#define KERNEL_NAME "Kernel"
#define KERNEL_TYPE "Kernel"
#define KERNEL_DESCRIPTION "Default Kore Kernel"
#define KERNEL_SERVICE "Kore/Kernel/Kernel"
#define KERNEL_SERVICE_DESCRIPTION "Kore Kernel service"

using namespace kore;

Kernel* Kernel::_instance = 0;

Kernel* Kernel::instance()
{
    if( !_instance )
        setInstance(new Kernel());
    return _instance;
//    return (Kernel*)((ServiceManager*) _instance->_serviceManager->registeredProvider("Kore/Kernel/Service Manager"))->registeredProvider(KERNEL_SERVICE);
}

void Kernel::setInstance(Kernel* inst)
{
    _instance = inst;
}

Kernel::Kernel()
{
    _version = new Version(KERNEL_MAJOR,KERNEL_MINOR,KERNEL_REVISION,KERNEL_VERSION);
    _info = new Info(this, KERNEL_NAME, KERNEL_TYPE, KERNEL_DESCRIPTION, _version, _version);
    setInfo(_info);
    _kernelService = new Service(this, KERNEL_SERVICE, KERNEL_SERVICE_DESCRIPTION);
    addService(_kernelService);

    setServiceManager( new ServiceManager() );
    _serviceManager->registerProvider(_serviceManager);
    _serviceManager->registerProvider(this);

    _moduleManager = new ModuleManager();
    _serviceManager->registerProvider(_moduleManager);
    _moduleManager->registerModule(this);
    _moduleManager->registerModule(_serviceManager);
    _moduleManager->registerModule(_moduleManager);

    _pluginLoader = new PluginLoader();
    _serviceManager->registerProvider(_pluginLoader);
    _moduleManager->registerModule(_pluginLoader);
//    _pluginManager = new PluginManager();
}
Kernel::~Kernel()
{
//    _serviceManager->unregisterProvider(this);
//    _serviceManager->unregisterProvider(_serviceManager);
    _moduleManager->unregisterModule(_serviceManager);
    delete _serviceManager;
    delete _moduleManager;
    delete _pluginLoader;
    delete _info;
    delete _version;
    delete _kernelService;
}

ServiceManager* Kernel::serviceManager() const
{
    return _serviceManager;
}

void Kernel::setServiceManager(ServiceManager* sm)
{
    _serviceManager = sm;
}
