
#ifndef TESTPLUGIN_H
#define TESTPLUGIN_H

#ifdef WIN32
#include <windows.h>
#ifdef KORETEST_EXPORTS
#define KORETEST_API __declspec(dllexport)
#else
#define KORETEST_API __declspec(dllimport)
#endif
#else
#define KORETEST_API
#endif

#include <kore/kore.h>
#include <kore/plugin.h>

using namespace kore;

extern "C"
{
    KORETEST_API PLUGIN_MAIN_HDR(libHandle,libName,libPath,libFlags);
/*
    void _init(void);
    void _fini(void);
*/
}

namespace test
{

class KORETEST_API TestPlugin: public Plugin
{
public:
    TestPlugin(HMODULE libhandle, const char* libname, const char* libpath, int flags);
    ~TestPlugin();
    void pluginLoaded();
    void unloadingPlugin();
private:
    // TestPlugin version
    const Version* _pluginVersion;
    // Kernel API version required by TestPlugin
    const Version* _pluginAPIVersion;
    // TestPlugin info
    const Info* _pluginInfo;
};

};

#endif
