/***************************************************************************
                          knutnewupsdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutnewupsdlg.h"
 
#include <klocale.h>
#include <kmessagebox.h>

#include <qstring.h>
#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qgroupbox.h>
//#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>



KNutNewUpsDlg::KNutNewUpsDlg (KNutUpsData* const upsData, KNutVarData* const analogData, const bool add, QWidget* parent, const char* name, const bool modal)
  : KDialogBase(Plain, i18n("New Ups"),Help|Ok|Cancel,Ok, parent, name, modal, true ), addMember(add), m_myUpsData(upsData) {

  //m_myUpsData = upsData;
  setName( "KupsNewUpsDlg" );

  QFrame *page =plainPage();
  QVBoxLayout *mainLayout = new QVBoxLayout( page, 0, spacingHint(), "mainLayout" );
    QHBoxLayout *dataLayout = new QHBoxLayout(mainLayout, spacingHint(),"dataLayout");

    
        QGroupBox *hostBox = new QGroupBox (page,"hostBox");
        QGridLayout *hostLayout = new QGridLayout (hostBox, 5, 2, spacingHint () );
        hostBox->setFrameStyle(QFrame::NoFrame);
        dataLayout->addWidget(hostBox);

          QHBoxLayout *portLayout = new QHBoxLayout(-1,"portLayout");
          hostLayout->addLayout(portLayout,4,1);

          QHBoxLayout *loginLayout = new QHBoxLayout(-1,"loginLayout");
          hostLayout->addLayout(loginLayout,5,1);

//        QButtonGroup *protocolGroup = new QButtonGroup(i18n("Protocol"),page,"protocolGroup");
//        QGridLayout *protocolLayout = new QGridLayout (protocolGroup, 4 , 1,spacingHint () );

//      dataLayout-> addWidget(protocolGroup);

    QGroupBox* GroupBox1 = new QGroupBox( page, "GroupBox1" );
    QGridLayout *varLayout = new QGridLayout (GroupBox1, 7 , 2,spacingHint ());
    
  QLabel* TextLabel1 = new QLabel( i18n("Name")+":",hostBox, "TextLabel1" );
  hostLayout->addWidget (TextLabel1,1,0);
  m_lineEdit1 = new KLineEdit( hostBox, "LineEdit1" );
  m_lineEdit1->setEnabled( add ); 
  // pokud se nejedna o pridani (add) neni jmeno aktivovani
  // when makes adding name isn;t activated
  hostLayout->addWidget (m_lineEdit1,1,1);

  QLabel* TextLabel2 = new QLabel(i18n("UPS address")+":", hostBox, "TextLabel2" );
  hostLayout->addWidget (TextLabel2,2,0);
  m_lineEdit2 = new KLineEdit( hostBox, "LineEdit2" );
  hostLayout->addWidget (m_lineEdit2,2,1);

// Name of UPS
  QLabel* TextLabel7 = new QLabel(i18n("UPS name")+":", hostBox, "TextLabel7" );
  hostLayout->addWidget (TextLabel7,3,0);
  m_lineEdit7 = new KLineEdit( hostBox, "LineEdit7" );
  hostLayout->addWidget (m_lineEdit7,3,1);

  
  QLabel* TextLabel3 = new QLabel(i18n("Delay (ms):"), hostBox, "TextLabel3" );
  hostLayout->addWidget (TextLabel3,4,0);
  m_lineEdit3 = new KLineEdit( hostBox, "LineEdit3" );
  m_lineEdit3->setText("5000");
  portLayout->addWidget(m_lineEdit3);
  portLayout->addSpacing(10);

  QLabel* TextLabel4 = new QLabel(i18n("Port:"), hostBox, "TextLabel4" );
  m_lineEdit4 = new KLineEdit( hostBox, "LineEdit4" );
  m_lineEdit4->setText(QString("%1").arg(knc::DefaultPort));
  portLayout->addWidget(TextLabel4);
  portLayout->addWidget(m_lineEdit4);

  QLabel* TextLabel5 = new QLabel(i18n("User name:"), hostBox, "TextLabel5" );
  hostLayout->addWidget (TextLabel5,5,0);
  m_lineEdit5 = new KLineEdit( hostBox, "LineEdit5" );
  m_lineEdit5->setText("");
  loginLayout->addWidget(m_lineEdit5);
  loginLayout->addSpacing(10);

  QLabel* TextLabel6 = new QLabel(i18n("Password:"), hostBox, "TextLabel6" );
  m_lineEdit6 = new KLineEdit( hostBox, "LineEdit6" );
  m_lineEdit6->setEchoMode(QLineEdit::Password);
  m_lineEdit6->setText("");
  loginLayout->addWidget(TextLabel6);
  loginLayout->addWidget(m_lineEdit6);

  m_savePassword = new QCheckBox (i18n("Store NUT password in configuration file"),page,"savePassword");
  mainLayout->addWidget(m_savePassword);
  mainLayout->addWidget(GroupBox1);
  mainLayout->addStretch(10);

          
  //RadioButton1 = new QRadioButton(i18n("UDP"), protocolGroup, "RadioButton1" );
  //RadioButton1->setChecked( FALSE );
  //RadioButton2 = new QRadioButton(i18n("TCP"), protocolGroup, "RadioButton2" );
  //RadioButton2->setChecked( TRUE );
  //protocolLayout->addWidget ( RadioButton1,1,0 );
  //protocolLayout->addWidget ( RadioButton2,2,0 );
  //protocolLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  GroupBox1->setTitle( i18n( "UPS Variables" ));
  m_comboBox1 = new KComboBox( FALSE, GroupBox1, "CB1" );
  m_comboBox2 = new KComboBox( FALSE, GroupBox1, "CB2" );
  m_comboBox3 = new KComboBox( FALSE, GroupBox1, "CB3" );
  m_comboBox4 = new KComboBox( FALSE, GroupBox1, "CB4" );
  m_comboBox5 = new KComboBox( FALSE, GroupBox1, "CB5" );
  m_comboBox6 = new KComboBox( FALSE, GroupBox1, "CB6" );
  m_comboBox7 = new KComboBox( FALSE, GroupBox1, "CB7" );
  m_comboBox8 = new KComboBox( FALSE, GroupBox1, "CB8" );
  m_comboBox9 = new KComboBox( FALSE, GroupBox1, "CB9" );
  m_comboBox10 = new KComboBox( FALSE, GroupBox1, "CB10" );


  varLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  varLayout->addWidget ( m_comboBox1,1,0 );
  varLayout->addWidget ( m_comboBox2,2,0 );
  varLayout->addWidget ( m_comboBox3,3,0 );
  varLayout->addWidget ( m_comboBox4,4,0 );
  varLayout->addWidget ( m_comboBox5,5,0 );
  varLayout->addWidget ( m_comboBox6,1,1 );
  varLayout->addWidget ( m_comboBox7,2,1 );
  varLayout->addWidget ( m_comboBox8,3,1 );
  varLayout->addWidget ( m_comboBox9,4,1 );
  varLayout->addWidget ( m_comboBox10,5,1 );
  varLayout->addRowSpacing (6 ,fontMetrics().lineSpacing() );



  for (int i=0; i < knc::NumberOfTypes; i++) {
    m_comboBox1->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox2->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox3->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox4->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox5->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox6->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox7->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox8->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox9->insertItem( analogData->getNameAnalogData(i) );
    m_comboBox10->insertItem( analogData->getNameAnalogData(i) );
    }
//  slotProtocol(RadioButton2->isChecked());// nastavime User name, Password
//  connect (RadioButton2,SIGNAL(toggled(bool)),this,SLOT(slotProtocol(bool)));

  }

  
KNutNewUpsDlg::~KNutNewUpsDlg() {
  }
  

void KNutNewUpsDlg::putData (const upsRecord upsInfo ) {
  m_lineEdit1->setText(upsInfo.name);
  m_lineEdit2->setText(upsInfo.upsAddress);
  m_lineEdit7->setText(upsInfo.upsName);
  QString delay, port;
  delay.setNum(upsInfo.delay);
  m_lineEdit3->setText(delay);
  port.setNum(upsInfo.port);
  m_lineEdit4->setText(port);
  m_lineEdit5->setText(upsInfo.userName);
  m_lineEdit6->setText(upsInfo.password);
//  RadioButton1->setChecked( !upsInfo.tcp );
//  RadioButton2->setChecked( upsInfo.tcp );
  m_savePassword->setChecked(m_savePassword);
  m_comboBox1->setCurrentItem(upsInfo.upsVarCode[0]);
  m_comboBox2->setCurrentItem(upsInfo.upsVarCode[1]);
  m_comboBox3->setCurrentItem(upsInfo.upsVarCode[2]);
  m_comboBox4->setCurrentItem(upsInfo.upsVarCode[3]);
  m_comboBox5->setCurrentItem(upsInfo.upsVarCode[4]);
  m_comboBox6->setCurrentItem(upsInfo.upsVarCode[5]);
  m_comboBox7->setCurrentItem(upsInfo.upsVarCode[6]);
  m_comboBox8->setCurrentItem(upsInfo.upsVarCode[7]);
  m_comboBox9->setCurrentItem(upsInfo.upsVarCode[8]);
  m_comboBox10->setCurrentItem(upsInfo.upsVarCode[9]);
  }


void KNutNewUpsDlg::getData (upsRecord& upsInfo ) {
  upsInfo.name=m_lineEdit1->text();
  upsInfo.upsAddress=m_lineEdit2->text();
  upsInfo.upsName= m_lineEdit7->text();
  upsInfo.delay=m_lineEdit3->text().toLong();
  upsInfo.port=m_lineEdit4->text().toUInt();
//  upsInfo.tcp=RadioButton2->isChecked();
  upsInfo.userName=m_lineEdit5->text();
  upsInfo.password=m_lineEdit6->text();
  upsInfo.savePassword=m_savePassword->isChecked();
  upsInfo.upsVarCode[0]=m_comboBox1->currentItem();
  upsInfo.upsVarCode[1]=m_comboBox2->currentItem();
  upsInfo.upsVarCode[2]=m_comboBox3->currentItem();
  upsInfo.upsVarCode[3]=m_comboBox4->currentItem();
  upsInfo.upsVarCode[4]=m_comboBox5->currentItem();
  upsInfo.upsVarCode[5]=m_comboBox6->currentItem();
  upsInfo.upsVarCode[6]=m_comboBox7->currentItem();
  upsInfo.upsVarCode[7]=m_comboBox8->currentItem();
  upsInfo.upsVarCode[8]=m_comboBox9->currentItem();
  upsInfo.upsVarCode[9]=m_comboBox10->currentItem();
 }

/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE SLOTS                                                     */
/*                                                                                           */
/*********************************************************************************************/
 
 

void KNutNewUpsDlg::slotOk() {
  bool ok;
  // closes window
  m_lineEdit1->setText(m_lineEdit1->text().stripWhiteSpace());
  m_lineEdit2->setText(m_lineEdit2->text().stripWhiteSpace());

  if ((m_lineEdit1->text().length() <1 )
  || (m_lineEdit2->text().length() <1 )) {
    KMessageBox::sorry (0,i18n("No Name or UPS address"));
    return;
    }

  if (addMember) {
    // when UpsName is existed we cannot make new record
    // pokud UpsName jiz existuje nemuzeme vytvorit novy zaznam
    if ( m_myUpsData->findName(m_lineEdit1->text()) != 0L ) {
    KMessageBox::sorry (0,i18n("This Name exist"));
    return;
    }
  }

  long delay = m_lineEdit3->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Delay must be number"));
    return;
    }

  long port = m_lineEdit4->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Port must be number"));
    return;
    }

  if ((port < knc::StartPort) || (port > knc::StopPort)) {
    KMessageBox::sorry (0,i18n("Port must be from 1025 until 65535"));
    return;
    }

  if (delay < knc::MinDelay) {
    KMessageBox::sorry (0,i18n("Delay is too small"));
    return;
    }
  accept ();
  }

  

#include "knutnewupsdlg.moc"
