/* knocker version 0.6.0
 * Release date: 17 February 2002
 *
 * Project homepage: http://knocker.sourceforge.net
 *
 * Copyright 2001,2002 Gabriele Giorgetti <g.gabriele79@genie.it>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _KNOCKER_ARGS_H_
#define _KNOCKER_ARGS_H_

/* COMMAND LINE ARGUMENTS DEFINITION  */
/* ********************************** */
  /* host to scan */
#define HOST_SHORT_OPT "-H"
#define HOST_LONG_OPT  "--host"

  /* single port number */
#define SINGLE_PORT_SHORT_OPT "-P"
#define SINGLE_PORT_LONG_OPT  "--port"

  /* port number to start with */
#define START_PORT_SHORT_OPT "-SP"
#define START_PORT_LONG_OPT  "--start-port"

  /* port number to scan to */
#define END_PORT_SHORT_OPT "-EP"
#define END_PORT_LONG_OPT  "--end-port"

  /* Log scan results to file */
#define ENABLE_LOGFILE_SHORT_OPT "-lf"
#define ENABLE_LOGFILE_LONG_OPT  "--enable-logfile"

  /* disable output to stdout, disable threads */
#define QUIET_MODE_SHORT_OPT "-qm"
#define QUIET_MODE_LONG_OPT "--quiet-mode"

  /* option to disable colored out put */
#define NO_COLORS_SHORT_OPT "-nc"
#define NO_COLORS_LONG_OPT  "--no-colors"

#define HELP_SHORT_OPT    "-h"
#define HELP_LONG_OPT     "--help"

#define VERSION_SHORT_OPT "-v"
#define VERSION_LONG_OPT  "--version"
/* ********************************** */


typedef struct {
  char           *hname;      /* hostname string */
  char           *hip;        /* host IP string  */
  unsigned int   port;        /* Single port number, -P */
  unsigned int   sport;       /* Start port number, -SP */
  unsigned int   eport;       /* End port number, -EP   */
  int logfile;     /* log to file TRUE,FALSE */
  int quiet;       /* quiet mode TRUE,FALSE  */
  int colors;      /* no colors, TRUE,FALSE  */
} knocker_args_t;


knocker_args_t knocker_args; /* command line arguments structure */

/*
 Initialize a knocker_args_t type of structure
*/
int  knocker_args_init  (knocker_args_t *args, int logfile, int quiet, int colors);

/*
 Free a previously initialized knocker_args_t type of strucutre
*/
void knocker_args_free  (knocker_args_t *args);

/*
 Parse passed arguments, fills a previously initialized knocker_args_t type
 of structure, and hanndles some options like --version, and --help.
*/
int  knocker_args_parse (knocker_args_t *args, int argc, char *argv[]);

/*
 This tells (returning TRUE or FALSE) the if an option is enabled or not.
*/
/* int  knocker_args_argument (knocker_args_t *args, unsigned short argument); */

#endif /* _KNOCKER_ARGS_H_ */


