/***************************************************************************
 *
 * knetworkmanager-settings.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_SETTINGS_H
#define KNETWORKMANAGER_SETTINGS_H

#include <qstring.h>
#include <qwidget.h>

#include <kdialogbase.h>
#include <knotifydialog.h>

#include "knetworkmanager.h"
#include "knetworkmanager-ui-networklistview.h"
#include "generalsettings.h"

class KIntSpinBox;
class QGroupBox;
class QCheckBox;

class GeneralSettingsWidget : public GeneralSetting
{
	Q_OBJECT
	public:
	  GeneralSettingsWidget(QWidget* parent = 0, const char* name = 0);
	  ~GeneralSettingsWidget();
	
	public slots:
	  void apply();
	  void discard();

	private:
	  void readConfig();
};

class NetworksConfigWidget : public QWidget
{
	Q_OBJECT
	public:
	  NetworksConfigWidget(KNetworkManager* ctx, QWidget* parent = 0, const char* name = 0);
	  ~NetworksConfigWidget();

	public slots:
	  void apply();
	  void discard();

	private:
	  KNetworkManager* _ctx;
	  KNetworkManagerNetworkListView* _lv;
};

class KNotifyWidget : public KNotifyDialog
{
	Q_OBJECT
	public:
	  KNotifyWidget(QWidget* parent = 0, const char* name = 0);
	  ~KNotifyWidget();

	public slots:
	  void apply();
	  void discard();
};

class DialupConfigWidget : public QWidget
{
	Q_OBJECT
	public:
	  DialupConfigWidget(QWidget* parent = 0, const char* name = 0);
	  ~DialupConfigWidget();

	public slots:
	  void configureDialup();
};

class SettingsDialog : public KDialogBase
{
	Q_OBJECT
	public:
	  SettingsDialog(KNetworkManager* ctx, QWidget* parent, const char* name, WFlags fl = 0, bool modal = false, QString caption = QString::null);
	  ~SettingsDialog();

	private:
	  KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_SETTINGS_H */
