/***************************************************************************
 *
 * knetworkmanager-dialup.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPN_H
#define KNETWORKMANAGER_VPN_H

#include <NetworkManager/NetworkManager.h>
#include <NetworkManager/NetworkManagerVPN.h>

#include <qdir.h>
#include <qobject.h>
#include <kprocess.h>

#include "knetworkmanager.h"

class KNetworkManager;

class VPNConnection : public QObject
{
	Q_OBJECT

	public:
	  VPNConnection( QObject * parent = 0, const char * name = 0);
	  ~VPNConnection ();
	  VPNConnection  (const VPNConnection &);

	  void setName            (const QString &);
	  void setServiceName     (const QString &);
	  void setUser            (const QString &);
	  void addRoute           (const QString &);
	  void addData            (const QString &);
	  void addPasswords       (const QStringList &);
	  void setActivationStage (NMVPNActStage);
	  void setAuthHelper      (const QString &);

	  QString       getName            (void) const;
	  QString       getServiceName     (void) const;
	  QString       getUser            (void) const;
	  QStringList   getRoutes          (void) const;
	  QStringList   getData            (void) const;
	  QStringList   getPasswords       (void) const;
	  NMVPNActStage getActivationStage (void) const;
	  QString       getAuthHelper      (void) const;

	  bool isValid (void);
	
	signals:
	  void activationStateChanged (void);

	private:
	  QString       _name;
	  QString       _serviceName;
	  QString       _user;
	  QStringList   _routes;
	  QStringList   _data;
	  QStringList   _passwords;
	  NMVPNActStage _activationStage;
	  QString       _authHelper;
};

class VPNConnectionHandler : public QObject
{
	Q_OBJECT
		
	public:
	  VPNConnectionHandler  ( QObject * parent = 0, const char * name = 0, VPNConnection* = 0);
	  ~VPNConnectionHandler ();

	public slots:
	  void receiveAuthenticationData (KProcess*, char*, int);
	  void authHelperExited           (KProcess*);

	private:
	  VPNConnection* _vpnConnection;
};

typedef QValueList<VPNConnection*> VPNList;

class VPN : public QObject
{
	Q_OBJECT

	public slots:
	  void receiveKeyringData      (KProcess*, char*, int);
	  void activateVPNConnection   (VPNConnection*);
	  void disconnectVPNConnection (void);
	  void configureVPNConnections (void);
	  void configureVPNExited      (KProcess*);
	
	public:
	  VPN( QObject * parent = 0, const char * name = 0);
	  ~VPN ();

	  VPNConnection* getVPNConnection (const QString &);
	  VPNList*       getVPNList       (void);
	  bool           isActive         (void);
	  bool           isAvailable      (void);
	  
	  void push (KNetworkManager*);

	private:
	  void initKeyring      (void);
	  bool checkForServices (void);
	  void addConnection    (const QString &);
	  void getConnections   (void);

	  VPNList* _vpnList;
	  QString  _confPath;
	  QDir*    _confDir;
	  bool     _available;
};

#endif /* KNETWORKMANAGER_VPN_H */
