/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KITTY_H_
#define _KITTY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kitty_globals.h>
#include "kitten.h"
#include "kitty_feedmodel.h"
#include "kitty_feededit.h"
#include "kitty_articleedit.h"
#include <kapplication.h>
#include <kmainwindow.h>
#include <qdom.h>
#include <qlabel.h>
#include <klistview.h>
#include <kparts/part.h>
#include <qtabwidget.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <ktextbrowser.h>
#include <kurllabel.h>
#include <khtml_part.h>
#include <kprogress.h>
#include <qtimer.h>
#include <ksystemtray.h>
#include <kstatusbar.h>
#include <qtooltip.h>
#include <qvaluestack.h>

/**
 * @short Application Main Window
 * @author KesieV <kesiev@hotmail.com>
 * @version 0.9
 */




class Kitty : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Kitty();

    /**
     * Default Destructor
     */
    virtual ~Kitty();
    bool refreshFeed(int id);
    void updateFeed(int id);
    void viewFeed(int id);
    void saveLocalFeed();
    void startDownload(int feed,int article);
    void doSuggest(int,QString);
    void pickVideo(int feed, int article,QString &url, QString &mime);
    void setEmptyPage();
    void setCollectionPage();
    void disposeVideo();
    KSystemTray *trayIcon;

public:
	void addurl(QString url);
	t_feed feeds[100];
        KParts::ReadOnlyPart *m_video;
	bool loadFile(QString fname,QString &data);
	bool loadSkin(QString skinname);
	bool setDefaultSkin();
	void raw_playVideo(int article);
	void raw_addToMyCollection(int article);
	void raw_openVideo(int article);
	void raw_purgeArticle(int article);
	void raw_removeArticle(int article);
	void raw_cancelDownload(int article);
	void raw_editArticle(int article);
	void raw_editFeed(int feed);
	void raw_deleteFeed(int feed);
	void raw_addArticle(int feed);
	QString htmlReplacer(QString from,int id,int i);
	void applySkin();
	void saveConfig();
	void browseURL(QString url);

private:
	void upDateFeedList(int feed_id);

private slots:
	void clickArticle(QListViewItem* );
	void playVideo();
	void clickFeed(QListViewItem*);
	void addFeed();
	void updateFeedlist();
	void refreshCurrentFeed();
	void refreshAllFeeds();
	void openURLRequest(const KURL &url, const KParts::URLArgs & );
	void detailsOpenURLRequest(const KURL &url, const KParts::URLArgs & );
	void clickHome();
	void removeFeed();
	bool queryExit();
	void feedbox_contextMenuRequested(QListViewItem*, const QPoint&, int );
	void articles_contextMenuRequested(QListViewItem*, const QPoint&, int );
	void showPrefs();
	void addToMyCollection();
	void removeArticle();
	void downloadVideo();
	void updateDownloadStatus();
	void cancelDownload();
	void reallyCloseEvent();
	void readOpt();
	void firstReadOpt();
	void selectGuide(int);
	void suggestFeed();
	void nekotongue();
	void historyBack();
	void submitInProgress(int );
	void firstStart();
	void openVideo();
	void purgeArticle();
	void browserSetValue(int i);
	void publishFeed();
	void editFeed();
	void editArticle();
	void addArticle();
	void yahoo_loaded();
	void page_loaded();
	void raw_stop();

private:
	QString skin_head;
	QString skin_module;
	QString skin_footer;
	QString skin_js;
	QString skin_path;
	int current_interface;
	void restoreSizes();
	KListView *feedbox;
	QLabel *diz;
	KHTMLPart *feed_detail;
	KListView *articles;
	QDomDocument domTree;
	QLabel *lab;
	QLabel *videodetails;
	QPushButton *play;
	QPushButton *historybtn;
	KURLLabel *cururl;
	int feeds_count;
	int selected_feed;
	int selected_article;
	QTabWidget *tabs;
	QTabWidget *alltabs;
	KProgress *progress;
	KProgress *downloading;
	t_settings settings;
	QTimer *refresher;
	QLabel *statusMessages;
	bool reallyClose;
	QValueStack <QString> history;

	int meta_column;
	int refresh_time;

	QSplitter *horz;
	QSplitter *split;	
	QVBox *videobox;
	KListViewItem *special;
	QPixmap nullPixmap;
	Kitten *local_downloader;

	int videoPage;
	int moviePage;
	int guidePage;
	int playingfeed;
	int playingarticle;


protected:
	KHTMLPart *browser;
	KHTMLPart *submitter;
	KHTMLPart *yahoo_link;
	int yahoo_done;
	int page_done;
	QString subscriber_status;
	bool submitter_is_busy;
};
#endif // _KITTY_H_
