.\" $Id: kinput2.man,v 1.19 1999/05/26 03:59:52 ishisone Exp $
.TH KINPUT2 1 "24 March 1999" "X Version 11"
.SH NAME
kinput2 \- kanji input server for X11
.SH SYNOPSIS
\fBkinput2\fP [-options...]
.SH DESCRIPTION
.I Kinput2
is an X window application to input Japanese text.
It acts as a front-end for other applications that want
kana-kanji conversion.
.PP
When invoked, after some initialization (which will take about a few to
30 seconds depending on your machine) \fIkinput2\fP waits quietly for a
Japanese text input request from another client (i.e. no windows
appear).
When \fIkinput2\fP receives a request, it pops up a window and
starts conversion process. It sends the converted text back to the
client when the text is fixed.
.PP
.I Kinput2
has some big improvements over its predecessor, kinput, which
was contributed to X11R4.
.TP 8
\fBOver-the-spot/On-the-spot Input\fP
These features enable conversion process to be done at cursor position,
avoiding unnecessary movement of eyes between cursor position and conversion
window.
.I Kinput2
also supports root window style input and off-the-spot style input.
.TP 8
\fBMultiple Protocol Support\fP
.I Kinput2
supports several conversion protocols between front-end and
client. Supported protocols are:
.nf
	kinput protocol
	kinput2 protocol
	Matsushita jinput protocol
	Sony xlc protocol
	XIMP protocol
	X Input Method Protocol (X Consortium standard)
.fi
.TP 8
\fBMultiple Conversion Engine Support\fP
.I Kinput2
can use 3 different conversion engines, Wnn, Canna and Sj3.
You can choose one at compilation time, or at run time.
.TP 8
\fBKinput Compatibility\fP
.I Kinput2
is fully upward-compatible with kinput, so applications which use
kinput as the front-end can also use \fIkinput2\fP.
In this case, the applications cannot take advantage of over-the-spot
conversion, though.
.SH OPTIONS
.I kinput2
accepts all of the standard X Toolkit command line options.
The following options are accepted as well.
.TP 8
\fB\-wnn\fP
This option specifies that Wnn jserver is used as the conversion engine.
.TP 8
\fB\-jserver\fP
This option specifies the hostname of the jserver to be used for conversion.
.TP 8
\fB\-ccdef\fP
This option specifies the input character conversion rule file.
.TP 8
\fB\-wnnenvrc4\fP
This option specifies the Wnn convertion environment initialization
file (wnnenvrc) for Wnn version 4.
.TP 8
\fB\-wnnenvrc6\fP
This option is similar to \-wnenvrc4, but for Wnn version 6.
.TP 8
\fB\-canna\fP
This option specifies that Canna conversion server (irohaserver) is used as
the conversion engine.
.TP 8
\fB\-cannaserver\fP
This option specifies the hostname of Canna conversion server.
.TP 8
\fB\-cannafile\fP
This option specifies Canna conversion customization file.
.TP 8
\fB\-sj3\fP
This option specifies that Sj3 conversion server (sj3serv) is used as
the conversion engine.
.TP 8
\fB\-sj3serv\fP
This option specifies the hostname of the primary sj3 conversion server.
.TP 8
\fB\-sj3serv2\fP
This option specifies the hostname of the secondary sj3 server. The secondary
server is used when \fIkinput2\fP cannot connect to the primary server.
.TP 8
\fB\-font\fP \fIascii-font\fP
This option specifies the default font to be used for displaying ASCII text.
.TP 8
\fB\-kanjifont\fP \fIkanji-font\fP
This option specifies the default font to be used for displaying Kanji text.
.TP 8
\fB\-kanafont\fP \fIkana-font\fP
This option specifies the default font to be used for displaying Kana text.
.TP 8
\fB\-/+kinput\fP
This option enables/disables use of kinput protocol family (i.e.
kinput protocol, kinput2 protocol, jinput protocol and xlc protocol).
.TP 8
\fB\-/+ximp\fP
This option enables/disables use of XIMP protocol.
.TP 8
\fB\-/+xim\fP
This option enables/disables use of X Input Method Protocol.
.TP 8
\fB\-bc\fP
Kinput protocol, which is one of the communication protocols
\fIkinput2\fP supports,
uses X window's selection mechanism to notify other clients of
front-end's existence.
This option forces \fIkinput2\fP to use selection ``JAPANESE_CONVERSION''
(which is not a standard selection name) as well as ``_JAPANESE_CONVERSION''.
This is for backward compatibility, since many of the applications that
connect with kinput still use this non-standard selection.
.TP 8
\fB\-tbheight\P \fItitle-bar-height\fP
This option specifies the height (in pixels)  of the titlebar
attached to popup shells such as candidate selection window.
.I Kinput2
uses this value to compute the correct popup location of these windows.
.SH WIDGET TREE
Below is the widget hierarchy of \fIkinput2\fP.
.nf
.ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i
	Kinput2  kinput2
		ConversionManager  convmanager
			KinputProtocol  kinputprotocol
			XimpProtocol  ximpprotocol
			IMProtocol  improtocol
			SeparateConversion  converter
				CcWnn  inputObj
				Canna  inputObj
				Sj3  inputObj
				JpWcharDisplay  displayObj
				Form  form
					ICLabel  mode
						JpWcharDisplay  display
					Canvas  text
				TransientShell  selectionShell
					CandidatePanel  selection
						JpWcharDisplay  display
				TransientShell  auxShell
					AuxPanel  aux
						JpWcharDisplay  display
			OffTheSpotConversion  converter
				CcWnn  inputObj
				Canna  inputObj
				Sj3  inputObj
				JpWcharDisplay  displayObj
				AdoptedShell  modeShell
					ICLabel  mode
						JpWcharDisplay display
				CanvasShell  text
				TransientShell  selectionShell
					CandidatePanel  selection
						JpWcharDisplay  display
				TransientShell  auxShell
					AuxPanel  aux
						JpWcharDisplay  display
			OverTheSpotConversion  converter
				CcWnn  inputObj
				Canna  inputObj
				Sj3  inputObj
				JpWcharDisplay  displayObj
				TransientShell  selectionShell
					CandidatePanel  selection
						JpWcharDisplay  display
				TransientShell  auxShell
					AuxPanel  aux
						JpWcharDisplay  display
				AdoptedShell  modeShell
					ICLabel  mode
						JpWcharDisplay  display
				TransientShell  modeShell
					ICLabel  mode
						JpWcharDisplay  display
				CanvasShell  text
.fi
.SH RESOURCES
There are too many resources to describe here, but you don't have to
know most of them.
So here is a brief description of resources which you might want to set.
.PP
\fBKinput2\fP application resource:
.RS 4
.TP 4
\fBconversionEngine\fP
This resource specifies which conversion engine to use.
You can specify one of ``wnn'', ``canna'' and ``sj3''.
.RE
.PP
.B ConversionControl
widget (which is a superclass
of SeparateConversion, OffTheSpotConversion and OverTheSpotConversion)
resource:
.RS 4
.TP 4
\fBsendbackKeyPress\fP
If this resource is ``true'', the KeyPress events intercepted but unused
by \fIkinput2\fP are sent back to the client when there is no conversion text.
Although this feature is convenient, it might confuse some clients
since none of corresponding KeyRelease events are sent.
Also, since the ``send_event'' flag of those events are true, some
clients do not accept events sent back by \fIkinput2\fP.
For example, kterm doesn't accept those events without specifying
.nf
	KTerm*allowSendEvents: true
.fi
in a resource file.
.br
The default of \fBsendbackKeyPress\fP resource is \fBtrue\fP.
.TP 4
\fBtitlebarHeight\fP
This resource specifies the height of a title bar which is attached
to various popup shell windows, such as candicate selection.
When computing the location of these windows,
.I kinput2
uses this value to pop up them at correct position.
.br
The default is \fB0\P.
.RE
.PP
.B OverTheSpotConversion
widget resources:
.RS 4
.TP 4
\fBshrinkWindow\fP
If this resource is ``true'', the width of on-the-spot conversion window
shrinks according to the length of the text on it. Otherwise,
the window never shrinks.
If the performance of Xserver on window resizing is poor,
you may consider setting this resources to false.
The default is \fBtrue\fP.
.TP 4
\fBmodeLocation\fP
This resource specifies the location of status widget in case of 
over-the-spot type conversion.
Unless client specifies the location explicitly, the location of
the status widget is determined by this resource.
If the value of this resource is ``topleft'', the widget is placed at the
top left of the client window. You can also specify 
``topright'', ``bottomleft'' and ``bottomright''.
If the value is ``tracktext'', the widget is placed just under the cursor
position, and moves according to the cursor. However, if the
region available for conversion is too small, status is placed at
the bottom left of the client area.
If the value is ``none'', the status widget will never appear.
.br
The default is ``tracktext''.
.TP 4
\fBmodeBorderForeground\fP
If this resource is ``true'', the color of status widget is forced
to be same as the foreground color of the widget.
.br
The default is \fBfalse\fP.
.TP 4
\fBuseOverrideShellForMode\fP
If this resource is ``true'', the status widget becomes an instance of
OverriddeShell, instead of the default TransientShell.
Turn this resource on if you encounter a strange phenomenon that
the status widget keeps flickering and you cannnot enter any text.
This is caused by (incorrect) focus management of your window manager,
and setting this resource will stop any window management for the widget.
The result is that the widget will be totally ignored by the window manager,
meaning you cannot move, resize, raise nor lower the widget.
.br
The default is \fBfalse\fP.
.RE
.PP
.B OnTheSpotConversion
widget resources:
.RS 4
.TP 4
\fBfeedbackAttributes\fP
This resource specifies the display attributes of preedit string when
on-the-spot input style is used. In on-the-spot style, it is a client's
responsibility to draw preedit string, and kinput2 sends some hints
on how it should be drawn, which is controled by this resource.
The value of this resource should be a comma-separated list of 4 elements,
and each element represents the drawing hint of specific type of string.
They represent the hints for not-yet-converted string,
for converted string, for converted string which belongs to the current
clause, for converted string belonging to the current sub-clause, in that
order.
Each element consists of zero or more drawing attributes, which are `R'
(reverse), `U' (underline), `H' (highlight), `P' (primary), `S' (secondary)
or `T' (tertiary).  You should consult the Xlib document for the meaning
of these attributes (see the section about preedit draw callback).
The default is ``U,,R,H'', which is close to the drawing attributes used
by other input styles.
.RE
.PP
.B CcWnn
(conversion widget using Wnn) resources:
.RS 4
.TP 4
\fBjserver\fP
This resource specifies the hostname of the (primary) jserver to be used
for conversion. If not specified, value of environment variable ``JSERVER''
is used.
.TP 4
\fBjserver2nd\fP
This resource specifies the hostname of the secondary jserver, which is 
used if the primary server is down. If not specified, \fIkinput2\fP doesn't
use secondary server.
.TP 4
\fBwnnEnvrc4\fP
This resource specifies the filename of the Wnn conversion environment
initialization file. This file is used when the Wnn server (jserver) is
version 4. See documents of Wnn for the format of the file.
The default is \fB/usr/local/lib/wnn/wnnenvrc\fP.
.TP 4
\fBwnnEnvrc6\fP
This resource also specifies the filename of the Wnn conversion environment
initialization file. This file is used when the Wnn server (jserver) is
version 6. See documents of Wnn for the format of the file.
.TP 4
\fBwnnEnvrc\fP
This resource is provided for backward compatibility.
Use \fBwnnEnvrc4\fP or \fBwnnEnvrc6\fP instead.
.TP 4
\fBccdef\fP
This resource specifies the input character conversion rule file.
The default is \fB/usr/lib/X11/ccdef/ccdef.kinput2\fP.
.RE
.PP
.B Canna
(conversion widget using Canna) resources:
.RS 4
.TP 4
\fBcannahost\fP
This resource specifies the hostname of the canna server to be used.
.TP 4
\fBcannafile\fP
This resource specifies Canna conversion customization file.
.RE
.PP
.B Sj3
(conversion widget using SJ3) resources:
.RS 4
.TP 4
\fBsj3serv\fP
This resource specifies the hostname of the (primary) sj3serv to be used
for conversion. If not specified, value of environment variable ``SJ3SERV''
is used.
.TP 4
\fBsj3serv2\fP
This resource specifies the hostname of the secondary sj3serv, which is 
used if the primary server is down.
.TP 4
\fBrcfile\fP
This resource specifies the filename of the Sj3 conversion customization
file. The default is \fB/usr/lib/X11/sj3def/sjrc\fP.
.TP 4
\fBrkfile\fP
This resource specifies the Romaji-Kana conversion rule file.
The default is \fB/usr/lib/X11/sj3def/sjrk\fP.
.RE
.PP
.B JpWcharDisplay
(widget for drawing Japanese text) resources:
.RS 4
.TP 4
\fBfont\fP, \fBkanjiFont\fP, \fBkanaFont\fP
These resource specifies the font to be used for displaying ASCII,
Kanji and Kana text, respectively.
Since \fIkinput2\fP changes fonts dynamically by client requests,
the fonts specified by these resources might not be used.
If not specified, the following fonts are used.
.nf
	-*-fixed-medium-r-normal--14-*-*-*-c-*-iso8859-1
	-*-fixed-medium-r-normal--14-*-*-*-c-*-jisx0208.1983-0
	-*-fixed-medium-r-normal--14-*-*-*-c-*-jisx0201.1976-0
.fi
.RE
.PP
.B KinputProtocol
(widget for handling kinput protocol family \- kinput, kinput2,
jinput and xlc protocol) resources:
.RS 4
.TP 4
\fBbackwardCompatible\fP
All of the protocols in kinput protocol family
use X window's selection mechanism to notify other clients of
front-end's existence.
If this resource is ``true'', \fIkinput2\fP uses selection ``JAPANESE_CONVERSION''
(which is not a standard selection name) as well as ``_JAPANESE_CONVERSION''.
This is for backward compatibility, since many of the applications
using these protocols still use this non-standard selection.
.br
The default is \fBtrue\fP.
.TP 4
\fBxlcConversionStartKey\fP
This resource specifies the key that starts the conversion.
The key is a hint for the clients using xlc protocol to determine when
they should request conversion to \fIkinput2\fP.
The syntax of the specification is a subset of the translation table syntax:
.nf
	\fImodifier-names\fP<Key>\fIkeysym-name\fP
.fi
where modifier-names is a combination of \fBShift\fP, \fBLock\fP, \fBMeta\fP,
\fBAlt\fP and \fBMod[1-5]\fP.
.br
The default is \fBShift<Key>space\fP.
.RE
.PP
\fBXimpProtocol\fP and \fBIMProtocol\fP
(which handle XIMP protocol and X Input Method Protocol) resources:
.RS 4
.TP 4
\fBconversionStartKeys\fP
This resource specifies the keys that start the conversion.
The syntax of the specification is a subset of the translation table syntax:
.nf
	\fImodifier-names\fP<Key>\fIkeysym-name\fP
.fi
where modifier-names is a combination of \fBCtrl\fP, \fBShift\fP, \fBLock\fP,
\fBMeta\fP, \fBAlt\fP and \fBMod[1-5]\fP. A '~' can precede each modifier
name, meaning the modifier must not be asserted.
For example, if the conversion start key is ``Kanji'' key with shift key
pressed and control key not pressed (other modifier keys may be pressed or 
not), the specification is:
.nf
	Shift ~Ctrl<Key>Kanji
.fi
Multiple keys can be specified by separating them with newlines.
.br
The default is as follows:
.nf
	Shift<Key>space \en\e
	Ctrl<Key>Kanji
.fi
.TP 4
\fBdefaultFontList\fP
This resource specifies the default fonts to be used if the client
does not specify fonts to be used.
The default is \fB-*-fixed-medium-r-normal--14-*-*-*-c-*\fP.
.RE
.SH "CLIENT SETUP"
When using X Input Method Protocol, you have to specify the
name of the input server you want to use.
This can be done by setting ``\fBinputMethod\fP'' resource
or setting \fBXMODIFIERS\fP environment variable.
Since some clients don't regard inputMethod resource while other
clients ignore XMODIFIERS variable, so it is a good idea to set both of
them.
.PP
To use kinput2, you should add the following line to your
resource file (such as .Xresources or .Xdefaults):
.nf
	*inputMethod: kinput2
.fi
and, set XMODIFIERS to ``@im=kinput2''.
.nf
	setenv XMODIFIERS "@im=kinput2"\ \ \ (for csh)
	XMODIFIERS="@im=kinput2"; export XMODIFIERS\ \ \ (for sh)
.fi
.SH "SEE ALSO"
Wnn documents, Canna documents, Sj3 documents,
XIMP protocol specification,
The Input Method Protocol
.SH COPYRIGHT
.nf
Copyright 1988, 1989, 1990, 1991, 1992, 1994 Software Research Associates, Inc.
Copyright 1991 NEC Corporation, Tokyo, Japan.
Copyright 1991 Sony Corporation 
Copyright 1998 MORIBE, Hideyuki
Copyright 1999 Kazuki YASUMATSU
.fi
.SH AUTHORS
.nf
Makoto Ishisone, Software Research Associates, Inc.
Akira Kon, NEC Corporation
Naoshi Suzuki, Sony Corporation
MORIBE, Hideyuki
Kazuki YASUMATSU
.fi
