\ serial.4th
\
\ kForth interface words for Linux serial communcations.
\
\ Copyright (c) 2000 David P. Wallace
\ Provided under the terms of the GNU General Public License
\
\ Requires:
\
\	strings.4th
\
\ Revisions:
\
\	3-13-2000  first working version
\

\ termios structure

create termios 4 4 + 4 + 4 + 2 + 64 + 4 + 4 + allot

0 constant C_IFLAG
4 constant C_OFLAG
8 constant C_CFLAG
12 constant C_LFLAG
16 constant C_LINE
18 constant C__CC
82 constant C_ISPEED
86 constant C_OSPEED

\ com port constants

0 constant COM1
1 constant COM2
2 constant COM3
3 constant COM4

\ baud rates constants

4111 constant CBAUD
0 constant B0
7 constant B300
9 constant B1200
11 constant B2400
12 constant B4800
13 constant B9600
14 constant B19200
15 constant B38400
4097 constant B57600
4098 constant B115200

\ character size constants

48 constant CSIZE
0 constant CS5
16 constant CS6
32 constant CS7
48 constant CS8

\ parity constants

768 constant CPARITY
0 constant PARNONE
256 constant PAREVEN
768 constant PARODD

\ stop bits constants

64 constant CSTOPB
0 constant ONESTOPB
64 constant TWOSTOPB

\ ioctl request constants

hex
5401 constant TCGETS
5402 constant TCSETS
540B constant TCFLSH
541B constant FIONREAD
decimal

\ file control constants

hex
800 constant O_NDELAY
100 constant O_NOCTTY
002 constant O_RDWR
decimal


: serial_getoptions ( handle -- | read serial port options into termios )
	TCGETS termios ioctl drop ;
	
: serial_setoptions ( handle -- | write termios into serial port options )
	TCSETS termios ioctl drop ;
	
: serial_open ( port -- handle | opens the serial port for communcation )
	\ port is the serial port to open
	\ 0 = ttyS0 (COM1)
	\ 1 = ttyS1 (COM2)
	\ 2 = ttyS2 (COM3)
	\ 3 = ttyS3 (COM4)
	\ handle is a handle to the open serial port
	\ if handle < 0 there was an error opening the port
	dup
	0 >=
	if
		s>string count
		s" /dev/ttyS"
		2swap
		strcat
		strpck
		O_RDWR O_NOCTTY  O_NDELAY or or
		open
		dup
		dup
		serial_getoptions
		termios C_LFLAG + @
		1 2 or 8 or 16 or not
		and
		termios C_LFLAG + !
		termios C_OFLAG + @
		1 not
		and
		termios C_OFLAG + !
		serial_setoptions
	then ;
	
: serial_close ( handle -- | closes the port )
	\ handle = serial port handle received from serial_open
	
	close ;

: serial_write ( handle buf num_to_write -- num_written )
	\ handle = serial port handle received from serial_open
	\ buf = address to buffer that holds chars to be written
	\ num_to_write = number of chars to write
	\ num_written = number of chars actually written
	write ;
	
: serial_read ( handle buf num_to_read -- num_read )
	\ handle = serial port handle received from serial_open
	\ buf = address to buffer to hold chars to being read
	\ num_to_read = number of chars to read
	\ num_read = number of chars actually read
	read ;
	
: serial_setbaud ( handle baud -- )
	\ handle = serial port handle received from serial_open
	\ baud = desired baud rate ( use constants defined above )
	swap
	dup
	serial_getoptions
	\ set the baud rate
	swap
	termios C_CFLAG + @
	CBAUD not and
	or
	termios C_CFLAG + !
	serial_setoptions ;

: serial_setparity ( handle parity -- )
	\ handle = serial port handle received from serial_open
	\ parity = desired parity ( use constants defined above )
 	swap
	dup
	serial_getoptions
	\ set the parity
	swap
	termios C_CFLAG + @
	CPARITY not and
	or
	termios C_CFLAG + !
	serial_setoptions ;

: serial_setstopbits ( handle stopbits -- )
	\ handle = serial port handle received from serial_open
	\ stopbits = desired number of stopbits ( constants above )
 	swap
	dup
	serial_getoptions
	\ set the stop_bit
	swap
	termios C_CFLAG + @
	CSTOPB not and
	or
	termios C_CFLAG + !
	serial_setoptions ;

: serial_setdatabits ( handle databits -- )
	\ handle = serial port handle received from serial_open
	\ databits = desired number of databits ( constants above )
	swap
	dup
	serial_getoptions
	\ set the data size
	swap
	termios C_CFLAG + @
	CSIZE not and
	or
	termios C_CFLAG + !
	serial_setoptions ;

: serial_flush ( handle -- )
	\ handle = serial port handle received from serial_open
	TCFLSH 2 ioctl drop ;

variable inque
	
: serial_lenrx ( handle -- rx_len)
	\ handle = serial port handle received from serial_open
	\ rx_len = number of chars in recieve que
	FIONREAD inque ioctl drop
	inque @ ;	 	

: serial_setparams ( handle ^str -- )
	\ ^str examples are 8N1, 7E1, etc.
	dup
	1 +
	c@
	dup
	[char] 8 =
	if
		2 pick
		CS8
		serial_setdatabits
		drop
		\ s" 8 data bits" type cr
	else
		[char] 7 =
		if
			1 pick
			CS7
			serial_setdatabits
			\ s" 7 data bits" type cr
		then
	then
	dup
	2+
	c@
	dup
	[char] N =
	if
		2 pick
		PARNONE
		serial_setparity
		drop
		\ s" NO PARITY" type cr
	else
		dup
		[char] E =
		if
			2 pick
			PAREVEN
			serial_setparity
			drop
			\ s" EVEN PARITY" type cr
		else
			[char] O =
			if	
				1 pick
				PARODD
				serial_setparity
				\ s" ODD Parity" type cr			
			then
		then
	then
	3 +
	c@
	dup
	[char] 1 =
	if
		drop
		ONESTOPB
		serial_setstopbits
		\ s" 1 stop bit" type cr
	else
		[char] 2 =
		if
			TWOSTOPB
			serial_setstopbits
			\ s" 2 stop bits" type cr
		then
	then ;
	

		
			
		
		
