\ zmatrix.4th
\
\ Complex matrix words
\
\ Copyright (c) 2002 Krishna Myneni, April 5, 2002
\ Provided under the GNU General Public License
\
\ Requires:
\	matrix.4th
\	complex.4th
\

: zmatrix ( nrows ncols -- | allot space for complex matrix and initialize)
	create 2dup * 2* dfloats 8 + ?allot mat_size! ;

: zmat_addr ( i j a -- a2 | returns address of the i j element of a )
	>r 1- 2* dfloats swap 1- r@ @ * 2* dfloats + r> + 8 + ;

: zmat@ ( i j a -- z | returns the i j element of a )
	zmat_addr z@ ;

: zmat! ( z i j a -- | store z as the i j element of a )
	zmat_addr z! ; 

: zmat_zero ( a -- | zero all entries in complex matrix )
	dup mat_size@ * >r 1 1 rot zmat_addr r>
	0 do dup >r z=0 r> z! dfloat+ dfloat+ loop drop ; 

: zrow@ ( i a -- zrc | fetch row i of zmatrix a as an zrc )
	dup @ >r 1 swap zmat_addr r> dup
	0 do over z@ frot swap dfloat+ dfloat+ swap loop nip ;

: zcol@ ( j a -- zrc | fetch column j of zmatrix a )
	dup mat_size@ 2* dfloats 2>r 1 -rot zmat_addr 2r>
	swap dup >r
	0 do over z@ frot swap over + swap loop 2drop r> ;

: zrow! ( zrc i a -- | store zrc as row i of zmatrix a )
	dup @ dup >r swap zmat_addr r>
	0 do 2>r r@ z! 2r> 2 dfloats - loop 2drop ;	

: zcol! ( zrc j a -- | store zrc as column j of zmatrix a )
	rot drop dup mat_size@ 2* dfloats >r dup >r -rot zmat_addr r> r>
	swap
	0 do >r >r r@ z! r> r@ - r> loop 2drop ; 

: zrow_swap ( i j a -- | interchange rows i and j for zmatrix a )
	tuck 2dup 2>r 2over 2>r
	2>r zrow@ 2r> zrow@
	2r> zrow! 2r> zrow! ;

: zcol_swap ( i j a -- | interchange columns i and j for a )
	tuck 2dup 2>r 2over 2>r
	2>r zcol@ 2r> zcol@
	2r> zcol! 2r> zcol! ; 
	
: zmat. ( a -- | print out the complex matrix )
	dup mat_size@ 1+
	swap 1+
	1 do
	  dup
	  1 do
	    over j i rot zmat@ z. 9 emit 
	  loop
	  cr
	loop
	2drop
;


