#!/bin/sh
set -e

CMD='cp -p'
#CMD='diff -u'

## Extract docs

rm -rf tmp
mkdir tmp

for patch in "$@"
do
    (cd tmp && patch -p1 -f) < $patch
done

case $1 in
*-2.4.*) KV=2.4 ;;
*-2.6.*) KV=2.6 ;;
*) echo >&2 "Cannot guess version for $1"; exit 1 ;;
esac

## Get changelogs

$CMD tmp/kdb/ChangeLog ChangeLogs-$KV/ChangeLog

for ARCH in $(cd tmp/arch && echo *)
do
    $CMD tmp/arch/$ARCH/kdb/ChangeLog ChangeLogs-$KV/ChangeLog-$ARCH
done
