package kdocParsePy;

use kdocAstGen;
use kdocAstUtil;
use File::Basename;

use strict;

use vars qw/$expecteddepth $rootNode $ident $params $class $method
$cSourceNode $striphpath $docexpected $newNode/;

=head2 Parsing python

1 clear buffer
2 read a line and append to buffer
	ends in \ -> 2
syntax:

decl:	"def"
		
=cut

sub recursePairs
{
	my( $ochr, $cchr, $depth ) = @_;

	return "[^$ochr$cchr]" if $depth <= 0;

	my $text = recursePairs( $ochr, $cchr, $depth - 1 );
	my $frep = $depth > 1 ? "" : "+";
	my $rep = $depth > 1 ? "?" : "*";

	return "(?:(?>$text$frep)|$ochr$text$rep$cchr)*";
}

sub BEGIN {
	$ident = "[\\w\\._]+";
	$params = recursePairs( "(", ")", 2 );
	$class= "class\\s+($ident)\\s*((:?\\($params\\))?)\\s*:";
	$method= "def\\s+($ident)\\s*\\(($params)\\)\\s*:";
	$striphpath = 1;
}

sub parseStream
{
	( $rootNode, $cSourceNode, *INPUT ) = @_;
	my( $currentfile ) = @_;
	$expecteddepth = 0;
	$docexpected = 0;
	$newNode = undef;

	my $buffer = "";
	my $defunfinished = 0;
	
	while( <INPUT> ) {
		chop;
		next if /^\s*(?:#.*)?$/;
		
		if ( /\\$/ ){
			$buffer .= $`;
			next;
		}
		$buffer = $_;
		parseDecl( $buffer );
		$buffer = "";
	}
}



sub parseDecl
{
	my $decl = shift;
	/^(\s*)/;

	print $decl, "\n" if $main::debug;

	
	my $ndepth = length( $1 );

	if( $ndepth > $expecteddepth ) {
#		warn "Parse error: depth $ndepth unexpected\n";
	}
	elsif( $ndepth < $expecteddepth ) {
		my $up = $expecteddepth - ( 1 + $ndepth );

		while( $up > 0  ) {
			kdocAstGen::popDecl() if $kdocAstGen::cNode->{Compound};
			$up--;
		}
		$expecteddepth = $ndepth;
	}

	if( $decl =~ /$class/o ) {
		my $rest = $';
		$newNode = kdocAstGen::newClass( "", "class", $1, 0 );
		$newNode->{KidAccess} = "public";
		my $inlist = $2;
		$inlist =~ s/[\(\)\s]//g;
		
		foreach my $in ( split( /\s*,\s*/, $inlist ) ){
			my $in = kdocAstGen::newInherit( $newNode, $in, "public" );
			$in->{Type} = "public";
		}
		if( $rest =~ /\s*(?:#.*)?$/  ){
			$expecteddepth++;
		}

		postInitNode( $newNode );
		$docexpected = 1;
	}
	elsif( $decl =~ /$method/o ) {
		my $rest = $';
		$newNode = kdocAstGen::newMethod( "", $1, $2, "", "", "" );
		postInitNode( $newNode );

		if( $rest =~ /\s*(?:#.*)?$/  ){
			$expecteddepth++;
		}
		$docexpected = 1;
	}
	elsif( $docexpected && $decl =~ /^\s*(['"]+)/) {
		my $tag = $1;
		my $text = $';
		$docexpected = 0;
		print "Node: $newNode->{astNodeName}:\n";
		$newNode->{DocNode} = parseDoc( $text, $tag );
	}
	else {
		$docexpected = 0;
	}
}


sub postInitNode
{
	my $newNode = shift;
	$newNode->{Source} = $cSourceNode ;
}

sub parseDoc
{
	my( $text, $endtag  ) = @_;
	my $done = 0;
	my $buffer = "";


	while( !$done ){
		if( $text =~ /$endtag\s*$/ ) {
			$text = $`;
			$done = 1;
		}
		$buffer .= $text;

		if( !$done ) {
			$text = <INPUT>;
		}
	}

	$buffer =~ s/\@arg\s+/\@p /g;

	my $node = Ast::New( "Doc" );
	$node->{NodeType} = "DocNode";

	foreach my $para ( split( "\n\n", $buffer ) ){
		my $tnode = Ast::New( $para );
		$tnode->{NodeType} = "DocText";
		$node->AddPropList( "Text", $tnode );
	}

	return $node;
}

1;
