/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kcmdlineargs.h>

#include "kscribble.h"


static KCmdLineOptions options[] =
{
   { "+[file]", I18N_NOOP("The file to open"), 0 },
   { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "kscribble", I18N_NOOP("KScribble"),
    VERSION,
    I18N_NOOP("The KDE 2 Scribble Tutorial"),
    KAboutData::License_GPL,
    "(c) 2000, The KDevelop Team");
  aboutData.addAuthor("Ralf Nolden","Programmer", "Ralf.Nolden@post.rwth-aachen.de");

  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication::addCmdLineOptions();
  KApplication app(argc, argv, "kscribble");

  if (app.isRestored())
  {
    RESTORE(KScribbleApp);
  }
  else 
  {
    KScribbleApp *kscribble = new KScribbleApp();
    kscribble->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    // open an empty document window
    if(args->count()==0)
  	  kscribble->openDocumentFile();

  	else
      // Arguments (e.g. files to open)
      for(int i = 0; i < args->count(); i++) // Counting start at 0!
      {
        // don't forget to convert to Unicode!
        kscribble->openDocumentFile( QFile::decodeName(args->arg(i)) );
      }
    args->clear(); // Free up some memory.
  }	

  return app.exec();
}  
