/***************************************************************************
                                  main.cpp
                             -------------------                                         
    begin                : Fri Aug  6 20:23:27 GMT+1 1999
                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kcpuload.h"

static const char *description = I18N_NOOP("A Small CPU usage Diagram meter for Kicker.");
static const char *version = VERSION;

int main(int argc, char **argv)
{
	KAboutData aboutData("kcpuload", I18N_NOOP("KCPULoad"), version, description, KAboutData::License_GPL,
		"(c) 2000, Markus Gustavsson", "KCPULoad was first released on the 8'th Aug -99.",
		"http://kde.quakenet.eu.org", "mighty@fragzone.se");

	aboutData.addAuthor("Markus Gustavsson", "KCPULoad Developer", "mighty@fragzone.se");

	aboutData.addCredit("Njaard, Charles Samuels", "Support and help with KDE", "charles@kde.org");
	aboutData.addCredit("rikkus, Rik Hemsley", "Support and help with KDE", "rik@kde.org");
	aboutData.addCredit("Thanks to everyone in #KDE OpenProjects for being supportive and helpfull!");

	KCmdLineArgs::init(argc, argv, &aboutData);

	KApplication a;

	KCPULoad *kcpuload = 0;

	if(a.isRestored()) {
		if(KTMainWindow::canBeRestored(1))
			(new KCPULoad)->restore(1, 0);
	} else {
		kcpuload = new KCPULoad;
		a.setMainWidget(kcpuload);
	}

	if(!kapp->dcopClient()->isAttached())
		kapp->dcopClient()->attach();

	QByteArray params;
	QDataStream d(params, IO_WriteOnly);
	d << (int) getpid();

	kapp->dcopClient()->send("kicker", "TaskbarApplet", "clientDied(pid_t)", params);

	return a.exec();
}












