
/*
 * background.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_BACKGROUND_C
#define DIALOGS_BACKGROUND_C

#include <stdlib.h>
#include <string.h>

#include "typedefs.h"
#include "background.h"

Background::Background ()
{
   status = NULL;
}

Background::~Background ()
{
   StatusType *tmp;
   while (status != NULL)
	 {
		if (status->next == NULL)
		  {
			 free (status->keyname);
			 free (status->description);
			 free (status);
			 status = NULL;
		  }
		else
		  {
			 tmp = status;
			 while (tmp->next->next != NULL) tmp = tmp->next;
			 free (tmp->next->keyname);
			 free (tmp->next->description);
			 free (tmp->next);
			 tmp->next = NULL;
		  }
	 }
}

void Background::CreateBackground (const char *progname,const char *version,const char *author)
{
   int i;
   char *credits,*title;
   setcolor (YELLOW,BLUE,A_BOLD);
   for (i = 0; i < COLS; i++) addch (' ');
   title = (char *) malloc (strlen (progname) + strlen (version) + 14);
   strcpy (title,progname);
   strcat (title," - Version ");
   strcat (title,version);
   move (0,(COLS - strlen (title)) / 2);
   addstr (title);
   free (title);
   setcolor (BLUE,BLUE,A_BOLD);
   move (1,0);
   for (i = 0; i < (LINES - 2) * COLS; i++) addch (sc_brick);
   for (i = 0; i < COLS; i++) addch (' ');
   credits = (char *) malloc (strlen (author) + 13);
   strcpy (credits,"Written by ");
   strcat (credits,author);
   setcolor (YELLOW,BLUE,A_BOLD);
   move (LINES - 1,COLS - strlen (credits) - 4);
   addstr (credits);
   free (credits);
}

void Background::AddHotkeyStatus (const char *keyname,const char *description)
{
   int x = 4;
   StatusType *nw,*tmp = status;
   nw = (StatusType *) malloc (sizeof (StatusType));
   nw->keyname = (char *) malloc (strlen (keyname) + 1);
   strcpy (nw->keyname,keyname);
   nw->description = (char *) malloc (strlen (description) + 1);
   strcpy (nw->description,description);
   nw->next = NULL;
   move (LINES - 1,x);
   while (tmp != NULL)
	 {
		x += strlen (tmp->keyname) + strlen (tmp->description) + 3;
		tmp = tmp->next;
	 }
   if (status == NULL)
	 status = nw;
   else
	 {
		tmp = status;
		while (tmp->next != NULL) tmp = tmp->next;
		tmp->next = nw;
	 }
   move (LINES - 1,x);
   setcolor (RED,BLUE,A_BOLD);
   addstr (keyname);
   setcolor (YELLOW,BLUE,A_BOLD);
   addch (' ');
   addstr (description);
}

void Background::RemoveHotkeyStatus (const char *keyname)
{
   int i;
   StatusType *previous,*current = status;
   bool finished = FALSE;
   move (LINES - 1,4);
   while (current != NULL)
	 {
		for (i = 0; i < (int) (strlen (current->keyname) + strlen (current->description)) + 3; i++)
		  addch (' ');
		current = current->next;
	 }
   current = status;
   previous = NULL;
   while ((current != NULL) && (!finished))
	 {
		if (strcmp (current->keyname,keyname) == 0)
		  {
			 if ((previous != NULL) && (current->next != NULL)) previous->next = current->next;
			 else if (previous == NULL) status = current->next;
			 else previous->next = NULL;
			 free (current->keyname);
			 free (current->description);
			 free (current);
			 finished = TRUE;
		  }
		else
		  {
			 previous = current;
			 current = current->next;
		  }
	 }
   move (LINES - 1,4);
   current = status;
   while (current != NULL)
	 {
		setcolor (RED,BLUE,A_BOLD);
		addstr (current->keyname);
		setcolor (YELLOW,BLUE,A_BOLD);
		addch (' ');
		addstr (current->description);
		current = current->next;
	 }
}

#endif BACKGROUND_C
