/* This is a module which is used for setting 
 * the NFC_TRACE flag in the nfcache field of an skb. 
 */
#include <linux/module.h>
#include <linux/skbuff.h>

#include <linux/netfilter_ipv4/ip_tables.h>

static unsigned int
target(struct sk_buff **pskb,
       const struct net_device *in,
       const struct net_device *out,
       unsigned int hooknum,
       const void *targinfo,
       void *userinfo)
{
	(*pskb)->nfcache |= NFC_TRACE;
	return IPT_CONTINUE;
}

static int
checkentry(const char *tablename,
	   const struct ipt_entry *e,
           void *targinfo,
           unsigned int targinfosize,
           unsigned int hook_mask)
{
	if (targinfosize != 0) {
		printk(KERN_WARNING "TRACE: targinfosize %u != 0\n",
		       targinfosize);
		return 0;
	}

	if (strcmp(tablename, "raw") != 0) {
		printk(KERN_WARNING "TRACE: can only be called from \"raw\" table, not \"%s\"\n", tablename);
		return 0;
	}

	return 1;
}

static struct ipt_target ipt_trace_reg = { 
	.name = "TRACE", 
	.target = target, 
	.checkentry = checkentry, 
	.me = THIS_MODULE
};

static int __init init(void)
{
	if (ipt_register_target(&ipt_trace_reg))
		return -EINVAL;

	return 0;
}

static void __exit fini(void)
{
	ipt_unregister_target(&ipt_trace_reg);
}

module_init(init);
module_exit(fini);
MODULE_LICENSE("GPL");
