// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Thread for writing data.
// ****************************************************************************


#ifndef __THREADWRITE_H__
#define __THREADWRITE_H__

#include <QThread>   //lint !e537 Repeated include

#ifndef __DEVICE_H__
  #include "device.h"
#endif


class t_ThreadWriteLocal;

class t_ThreadWrite: public QThread
{
   Q_OBJECT

   public:
      t_ThreadWrite ();
      t_ThreadWrite (t_pDevice pDevice, bool *pSlowDownRequest);
     ~t_ThreadWrite ();

      APIRET GetpFileHandle0 (void **ppHandle);
      APIRET GetpFileHandle  (void **ppHandle);

   protected:
      void run (void);

   private:
      APIRET DeleteImageFiles (bool AlsoDeleteInfoFile);

   signals:
      void SignalEnded (t_pDevice pDevice);

   private slots:
      void SlotFinished (void);

   private:
      t_ThreadWriteLocal *pOwn;
};

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_THREADWRITE_OPEN_FAILED = ERROR_BASE_THREADWRITE + 1,
   ERROR_THREADWRITE_WRITE_FAILED,
   ERROR_THREADWRITE_CLOSE_FAILED,
   ERROR_THREADWRITE_NOT_OPENED,
   ERROR_THREADWRITE_INVALID_FORMAT,
   ERROR_THREADWRITE_CONSTRUCTOR_NOT_SUPPORTED,
   ERROR_THREADWRITE_WRONG_BLOCK,
   ERROR_THREADWRITE_OUT_OF_SEQUENCE_BLOCK,
   ERROR_THREADWRITE_HANDLE_NOT_YET_AVAILABLE,
   ERROR_THREADWRITE_HANDLE_TIMEOUT,
   ERROR_THREADWRITE_LIBEWF_FAILED
};

#endif

