// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Thread for reading data.
// ****************************************************************************


#ifndef __THREADREAD_H__
#define __THREADREAD_H__

#include <QThread>

#ifndef __DEVICE_H__
   #include "device.h"
#endif

class t_ThreadReadLocal;

class t_ThreadRead: public QThread
{
   Q_OBJECT

   public:
      t_ThreadRead ();
      t_ThreadRead (t_pDevice pDevice, bool *pSlowDownRequest);
     ~t_ThreadRead ();

   protected:
      void   run             (void);
      APIRET ThreadReadBlock (t_pFifoBlock &pFifoBlock);

   signals:
      void SignalEnded (t_pDevice pDevice);

   private slots:
      void SlotFinished (void);

   private:
      t_ThreadReadLocal *pOwn;
};

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_THREADREAD_FILESRC_ALREADY_OPEN = ERROR_BASE_THREADREAD + 1,
   ERROR_THREADREAD_FILESRC_NOT_OPEN,
   ERROR_THREADREAD_NO_DATA,
   ERROR_THREADREAD_DEVICE_DISCONNECTED,
   ERROR_THREADREAD_UNEXPECTED_FAILURE,
   ERROR_THREADREAD_CONSTRUCTOR_NOT_SUPPORTED,
   ERROR_THREADREAD_BLOCKSIZE,
   ERROR_THREADREAD_DEVICE_ABORTED,
   ERROR_THREADREAD_LIBEWF_FAILED,
   ERROR_THREADREAD_BAD_FILE_HANDLE
};

#endif

