// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Standard include file
// ****************************************************************************

#ifndef __COMMON_H__
#define __COMMON_H__

// GNU C lib definitions
// ---------------------
#ifndef _LARGEFILE_SOURCE
   #define _LARGEFILE_SOURCE 1
#endif

#ifndef _FILE_OFFSET_BITS
   #define _FILE_OFFSET_BITS 64
#endif

#ifndef _GNU_SOURCE
   #define _GNU_SOURCE 1
#endif

#ifndef _THREAD_SAFE
   #define _THREAD_SAFE 1
#endif

#ifndef _STDIO_H
   #include <stdio.h>
#endif

#include "toolglobalid.h"
#include "error/toolerror.h"
#include "log/toollog.h"
#include "tooltypes.h"

#include "modules.h"
#include "error.h"

#define QSTR_TO_PSZ(QStr) (QStr).toAscii().constData()


extern void *pOffsetOfNullPointer;
#define OFFSET_OF(Type, Element)                            \
   ((unsigned int) &(((Type*)pOffsetOfNullPointer)->Element))

#endif


class t_Device;                      // As t_Device is the core structure of guymager and as it is needed
typedef t_Device       *t_pDevice;   // all the time, it is easiest to declare it here (eventhough I don't
typedef t_Device const *t_pcDevice;  // like that style too much, but we won't change C++ at this time).


#define EWF_MULTITHREADED_COMPRESSION_CHUNK_SIZE       32768

