/*
 * Merge widget header
 *
 * This is one of components in merge-view widget.
 * Show the files on one text widget coloring the different portions.
 * Derived from onepane-widget.
 * Some interfaces such as show line numbers, are provided by basepane-widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_MERGE_H__
#define __GDIFF_MERGE_H__

#include "onepane-widget.h"

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_MERGE				(gdiff_merge_get_type())
#define GDIFF_MERGE(obj)				GTK_CHECK_CAST(obj, gdiff_merge_get_type(), GdiffMerge)
#define GDIFF_MERGE_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_merge_get_type(), GdiffMergeClass)
#define GDIFF_IS_MERGE(obj)			GTK_CHECK_TYPE(obj, gdiff_merge_get_type())
#define GDIFF_IS_MERGE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_MERGE))

	
typedef struct _GdiffMerge       GdiffMerge;
typedef struct _GdiffMergeClass  GdiffMergeClass;

struct _GdiffMerge {
	GdiffOnePane onepane;

	GSList **adl_array;	/* Array of GSList of AddDispL.
						   The number of array is the number of diff portions.
						   Each GSList manages the DispLines added. */
};

struct _GdiffMergeClass {
	GdiffOnePaneClass parent_class;
};


GtkType gdiff_merge_get_type(void);
GtkWidget* gdiff_merge_new(DiffDir *diffdir, DiffFiles *dfiles);

/* insert or remove the all dlines */
void gdiff_merge_insert_all(GdiffMerge *merge, WhichFile whichfile);
void gdiff_merge_remove_all(GdiffMerge *merge, WhichFile whichfile);

/* insert or remove the current dlines */
void gdiff_merge_insert(GdiffMerge *merge, WhichFile whichfile);
void gdiff_merge_remove(GdiffMerge *merge, WhichFile whichfile);

void gdiff_merge_output_file(GdiffMerge *merge, const char *filename);


#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_MERGE_H__ */
