/*
 * Mergeview menu definitions
 * This is not a usual header file.
 * This is included by both menu-tool-bar.c and merge-rmenu.c as a common definition.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */

/* Keys for gtk_object_[get|set]_data() */
#define MENUITEM_MERGE_KEY		"m"

/* I'm using the same callback function for multiple menu items.
   So I use object data to identify the selected menu items. */
enum {
	MERGE_FIRST_FILE = 1 << 0,
	MERGE_SECOND_FILE = 1 << 1,
	MERGE_THIRD_FILE = 1 << 2,

	MERGE_INSERT_FILE = 1 << 8,
	MERGE_REMOVE_FILE = 1 << 9,

	MERGE_ALL_FILE = 1 << 10
};

static GnomeUIInfo merge_action_menu[] = {
#define MENUITEM_MERGE_INSERT_1		0
	{GNOME_APP_UI_ITEM, N_("_Insert first file"),
	 N_("Insert the portion from first file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_1, GDK_CONTROL_MASK, NULL},
#define MENUITEM_MERGE_INSERT_2		1
	{GNOME_APP_UI_ITEM, N_("I_nsert second file"),
	 N_("Insert the portion from second file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_2, GDK_CONTROL_MASK, NULL},
#define MENUITEM_MERGE_INSERT_3		2		
	{GNOME_APP_UI_ITEM, N_("In_sert third file"),
	 N_("Insert the portion from third file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_3, GDK_CONTROL_MASK, NULL},
#define MENUITEM_MERGE_REMOVE_1		3
	{GNOME_APP_UI_ITEM, N_("_Remove first file"),
	 N_("Remove the portion from first file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_9, GDK_CONTROL_MASK, NULL},
#define MENUITEM_MERGE_REMOVE_2		4
	{GNOME_APP_UI_ITEM, N_("R_emove second file"),
	 N_("Remove the portion from second file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_8, GDK_CONTROL_MASK, NULL},
#define MENUITEM_MERGE_REMOVE_3		5
	{GNOME_APP_UI_ITEM, N_("Re_move third file"),
	 N_("Remove the portion from third file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_7, GDK_CONTROL_MASK, NULL},

	GNOMEUIINFO_SEPARATOR,

#define MENUITEM_MERGE_INSERT_1_ALL		7
	{GNOME_APP_UI_ITEM, N_("Inser_t all first file"),
	 N_("Insert the all portions from first file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define MENUITEM_MERGE_INSERT_2_ALL		8
	{GNOME_APP_UI_ITEM, N_("Insert _all second file"),
	 N_("Insert the all portion from second file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define MENUITEM_MERGE_INSERT_3_ALL		9
	{GNOME_APP_UI_ITEM, N_("Insert a_ll third file"),
	 N_("Insert the all portion from third file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define MENUITEM_MERGE_REMOVE_1_ALL		10
	{GNOME_APP_UI_ITEM, N_("Remove all _first file"),
	 N_("Remove the all portion from first file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define MENUITEM_MERGE_REMOVE_2_ALL		11
	{GNOME_APP_UI_ITEM, N_("Remove all se_cond file"),
	 N_("Remove the all portion from second file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
#define MENUITEM_MERGE_REMOVE_3_ALL		12
	{GNOME_APP_UI_ITEM, N_("Remove all t_hird file"),
	 N_("Remove the all portion from third file"),
	 insert_remove_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},

	GNOMEUIINFO_SEPARATOR,

	{GNOME_APP_UI_ITEM, N_("_Output file"),
	 N_("Output the merged file to file"),
	 merge_output_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	GNOMEUIINFO_END
};

#define merge_menu_set_data()	G_STMT_START {							\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_1].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_FIRST_FILE | MERGE_INSERT_FILE));			\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_2].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_SECOND_FILE | MERGE_INSERT_FILE));		\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_3].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_THIRD_FILE | MERGE_INSERT_FILE));			\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_1].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_FIRST_FILE | MERGE_REMOVE_FILE));			\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_2].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_SECOND_FILE | MERGE_REMOVE_FILE));		\
	gtk_object_set_data(												\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_3].widget),	\
		MENUITEM_MERGE_KEY,												\
		GINT_TO_POINTER(MERGE_THIRD_FILE | MERGE_REMOVE_FILE));			\
																		\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_1_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_FIRST_FILE | MERGE_INSERT_FILE | MERGE_ALL_FILE));\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_2_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_SECOND_FILE | MERGE_INSERT_FILE | MERGE_ALL_FILE));\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_INSERT_3_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_THIRD_FILE | MERGE_INSERT_FILE | MERGE_ALL_FILE));\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_1_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_FIRST_FILE | MERGE_REMOVE_FILE | MERGE_ALL_FILE));\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_2_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_SECOND_FILE | MERGE_REMOVE_FILE | MERGE_ALL_FILE));\
	gtk_object_set_data(														\
		GTK_OBJECT(merge_action_menu[MENUITEM_MERGE_REMOVE_3_ALL].widget),		\
		MENUITEM_MERGE_KEY,														\
		GINT_TO_POINTER(MERGE_THIRD_FILE | MERGE_REMOVE_FILE | MERGE_ALL_FILE));\
} G_STMT_END


#ifndef show_menu_item
#define show_menu_item(w)	G_STMT_START {	\
	gtk_widget_set_sensitive(w, TRUE);		\
	gtk_widget_show(w);						\
} G_STMT_END
#endif

#ifndef hide_menu_item
#define hide_menu_item(w)	G_STMT_START {	\
	gtk_widget_hide(w);						\
	gtk_widget_set_sensitive(w, FALSE);		\
} G_STMT_END
#endif

#define merge_menu_show3()	G_STMT_START {	\
	show_menu_item(merge_action_menu[MENUITEM_MERGE_INSERT_3].widget);	\
	show_menu_item(merge_action_menu[MENUITEM_MERGE_REMOVE_3].widget);	\
	show_menu_item(merge_action_menu[MENUITEM_MERGE_INSERT_3_ALL].widget);	\
	show_menu_item(merge_action_menu[MENUITEM_MERGE_REMOVE_3_ALL].widget);	\
} G_STMT_END

#define merge_menu_hide3()	G_STMT_START {	\
	hide_menu_item(merge_action_menu[MENUITEM_MERGE_INSERT_3].widget);	\
	hide_menu_item(merge_action_menu[MENUITEM_MERGE_REMOVE_3].widget);	\
	hide_menu_item(merge_action_menu[MENUITEM_MERGE_INSERT_3_ALL].widget);	\
	hide_menu_item(merge_action_menu[MENUITEM_MERGE_REMOVE_3_ALL].widget);	\
} G_STMT_END
