/*
 * GTK text widget(GtkText) support header
 * All interfaces of GtkText are wrapped here for a future replacement of it.
 *
 * Naming convention:
 * int ln;		line number
 * int total;	total number of lines
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_GTKTEXT_SUPPORT_H__
#define __GDIFF_GTKTEXT_SUPPORT_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */


/* Forward declarations of types. */
typedef struct _FontProp FontProp;

/* 
 * Data structure definitions
 */
/* Font property.
   Used to reduce the number of arguments. */
struct _FontProp {
	GdkFont *font;
	GdkColor *fg;
	GdkColor *bg;
};

/* Global function declarations */
extern guint gtext_insert_buf(GtkWidget *text, const FontProp *fprop, const char *buf_pt, int lenb);
extern gint gtext_forward_delete(GtkWidget *text, guint len);
extern gint gtext_forward_delete_b(GtkWidget *text, const char *buf_pt, guint lenb);
extern int gtext_line_from_index(GtkWidget *text, int index);
extern void gtext_gotoline_nonwrap(GtkWidget *text, int ln, int total);
extern void gtext_gotoline_wrap(GtkWidget *text, int ln, int total);
extern int gtext_guess_visible_top_line(GtkWidget *text, int total);
extern int gtext_guess_visible_center_line(GtkWidget *text, int total);
extern int gtext_guess_visible_bottom_line(GtkWidget *text, int total);
extern gboolean gtext_search_string(GtkWidget *text, const char *string, int lenb, int ln, int cached_ln, int *cached_point, int *cached_index);

/* Some are just direct replacements */
#define gtext_set_point(text, index)	gtk_text_set_point(GTK_TEXT(text), index)
#define gtext_set_editable(text, editable)	gtk_text_set_editable(GTK_TEXT(text), editable)
#define gtext_set_word_wrap(text, word_wrap)	gtk_text_set_word_wrap(GTK_TEXT(text), word_wrap)
#define gtext_set_line_wrap(text, line_wrap)	gtk_text_set_line_wrap(GTK_TEXT(text), line_wrap)
#define gtext_freeze(text)	gtk_text_freeze(GTK_TEXT(text))
#define gtext_thaw(text)	gtk_text_thaw(GTK_TEXT(text))
#define gtext_get_cursor_pos(text)	gtk_editable_get_position(GTK_EDITABLE(text))
	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_GTKTEXT_SUPPORT_H__ */
