/**
* Copyright 2005-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "grib_api_internal.h"
/* 
   This is used by make_class.pl

   START_CLASS_DEF
   CLASS      = accessor
   SUPER      = grib_accessor_class_long
   IMPLEMENTS = pack_long;unpack_long
   IMPLEMENTS = init
   MEMBERS    = const char* table
   MEMBERS    = const char* parameter 
   END_CLASS_DEF

 */

/* START_CLASS_IMP */

/*

Don't edit anything between START_CLASS_IMP and END_CLASS_IMP
Instead edit values between START_CLASS_DEF and END_CLASS_DEF
or edit "accessor.class" and rerun ./make_class.pl

*/

static int pack_long(grib_accessor*, const long* val,size_t *len);
static int unpack_long(grib_accessor*, long* val,size_t *len);
static void init(grib_accessor*,const long, grib_arguments* );
static void init_class(grib_accessor_class*);

typedef struct grib_accessor_g1param {
    grib_accessor          att;
/* Members defined in gen */
/* Members defined in long */
/* Members defined in g1param */
	const char* table;
	const char* parameter;
} grib_accessor_g1param;

extern grib_accessor_class* grib_accessor_class_long;

static grib_accessor_class _grib_accessor_class_g1param = {
    &grib_accessor_class_long,                      /* super                     */
    "g1param",                      /* name                      */
    sizeof(grib_accessor_g1param),  /* size                      */
    0,                           /* inited */
    &init_class,                 /* init_class */
    &init,                       /* init                      */
    0,                  /* post_init                      */
    0,                    /* free mem                       */
    0,                       /* describes himself         */
    0,                /* get length of section     */
    0,                /* get number of values      */
    0,                 /* get number of bytes      */
    0,                /* get offset to bytes           */
    0,            /* get native type               */
    0,                /* get sub_section                */
    0,               /* grib_pack procedures long      */
    0,               /* grib_pack procedures long      */
    &pack_long,                  /* grib_pack procedures long      */
    &unpack_long,                /* grib_unpack procedures long    */
    0,                /* grib_pack procedures double    */
    0,              /* grib_unpack procedures double  */
    0,                /* grib_pack procedures string    */
    0,              /* grib_unpack procedures string  */
    0,                 /* grib_pack procedures bytes     */
    0,               /* grib_unpack procedures bytes   */
    0,            /* pack_expression */
    0,              /* notify_change   */
    0,                /* update_size   */
    0,            /* preferred_size   */
    0,                    /* resize   */
    0,      /* nearest_smaller_value */
    0,                       /* next accessor    */
    0,                    /* compare vs. another accessor   */
    0,     /* unpack only ith value          */
    0,     /* unpack a subarray         */
    0,             		/* clear          */
};


grib_accessor_class* grib_accessor_class_g1param = &_grib_accessor_class_g1param;


static void init_class(grib_accessor_class* c)
{
	c->dump	=	(*(c->super))->dump;
	c->next_offset	=	(*(c->super))->next_offset;
	c->value_count	=	(*(c->super))->value_count;
	c->byte_count	=	(*(c->super))->byte_count;
	c->byte_offset	=	(*(c->super))->byte_offset;
	c->get_native_type	=	(*(c->super))->get_native_type;
	c->sub_section	=	(*(c->super))->sub_section;
	c->pack_missing	=	(*(c->super))->pack_missing;
	c->is_missing	=	(*(c->super))->is_missing;
	c->pack_double	=	(*(c->super))->pack_double;
	c->unpack_double	=	(*(c->super))->unpack_double;
	c->pack_string	=	(*(c->super))->pack_string;
	c->unpack_string	=	(*(c->super))->unpack_string;
	c->pack_bytes	=	(*(c->super))->pack_bytes;
	c->unpack_bytes	=	(*(c->super))->unpack_bytes;
	c->pack_expression	=	(*(c->super))->pack_expression;
	c->notify_change	=	(*(c->super))->notify_change;
	c->update_size	=	(*(c->super))->update_size;
	c->preferred_size	=	(*(c->super))->preferred_size;
	c->resize	=	(*(c->super))->resize;
	c->nearest_smaller_value	=	(*(c->super))->nearest_smaller_value;
	c->next	=	(*(c->super))->next;
	c->compare	=	(*(c->super))->compare;
	c->unpack_double_element	=	(*(c->super))->unpack_double_element;
	c->unpack_double_subarray	=	(*(c->super))->unpack_double_subarray;
	c->clear	=	(*(c->super))->clear;
}

/* END_CLASS_IMP */

static void init(grib_accessor* a,const long l, grib_arguments* c)
{
	grib_accessor_g1param* self = (grib_accessor_g1param*)a; 
	int n = 0;
	self->parameter = grib_arguments_get_name(a->parent->h,c,n++);
	self->table     = grib_arguments_get_name(a->parent->h,c,n++);
}

static int pack_long(grib_accessor* a, const long* val, size_t *len)
{
	grib_accessor_g1param* self = (grib_accessor_g1param*)a;
	long parameter = *val % 1000;
	long table =     *val / 1000;
	int err = 0;

	if(table == 0) table = 128;

	err = grib_set_long_internal(a->parent->h,self->parameter,parameter);
	if(err) return err;

	err = grib_set_long_internal(a->parent->h,self->table,table);
	return err;
}

static int unpack_long(grib_accessor* a, long* val, size_t *len)
{   
	grib_accessor_g1param* self = (grib_accessor_g1param*)a;
	int err = GRIB_SUCCESS;
	/* size_t l = 0; */
	long parameter = 0;
	long table = 0;

	err = grib_get_long_internal(a->parent->h,self->parameter,&parameter);
	if(err) return err;

	err = grib_get_long_internal(a->parent->h,self->table,&table);
	if(err) return err;

	if(*len < 1)
		return GRIB_BUFFER_TOO_SMALL;


	*len = 1;


	if(table == 128)
		*val  = parameter;
	else
		*val = table * 1000 + parameter;


	return GRIB_SUCCESS;
}
