/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satpref-satlist.c: List preferences (widgets and funcs).

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "satlist.h"
#include "satlog.h"
#include "satpref.h"
#include "satpref-satlist.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


/* these values are passed to "reset to default"
   callback to keep track of which button was pressed.
*/
enum default_buttons {
	DEF_BUT_AHOR = 0,      /* above horizon */
	DEF_BUT_BHOR,          /* below horizon */
	DEF_BUT_GEO_A,         /* geostat. above hor. */
	DEF_BUT_GEO_B,         /* geostat. below hor. */
	DEF_BUT_DEC,           /* decayed */
	DEF_BUT_NOAOS          /* no AOS */
};


GtkWidget *hcp,*ncp,*ghcp,*gncp,*dcp,*nocp;        /* color pickers */
GtkObject *listadj;
GtkWidget *listspin;

GdkColor norm,high,geoh,geon,dec,noaos;  /* satlist.c */


extern GConfClient *client; /* main.c */

/* private function prototypes */
static void def_butt_cb (GtkWidget *,gpointer);


GtkWidget *satpref_satlist (void)
{
	/* This function creates the satlist property page. */

	GtkWidget *hcb,*ncb,*ghcb,*gncb,*dcb,*nocb;  /* default color buttons */
	GtkWidget *table,*label;
	GtkTooltips *kooltip;
	gchar *rgb;
	gchar **rgbv;
	gint delay;

	/* create table */
	table = gtk_table_new (4, 7, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (table), 2);

	/* satlist timer */
	label = gtk_label_new (_("Update interval"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 0, 1);
	delay = gconf_client_get_int (client, SATLIST_TIMER_PATH, NULL);
	if (!delay)
		delay = SATLIST_DEF_TIMER;
	listadj = gtk_adjustment_new (delay, 100, 60000, 10, 100, 5);
	listspin = gtk_spin_button_new (GTK_ADJUSTMENT (listadj), 0.5, 0);
	gtk_signal_connect (GTK_OBJECT (listspin), "changed",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (listspin), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), listspin, 2, 3, 0, 1);
	label = gtk_label_new (_(" [msec]") );
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 3, 4, 0, 1);
	/***************************************/
	/* color picker for sats above horizon */
	/***************************************/

	/** FIRST READ IN THE COLORS!         **/
	/* color for satellites above horizon */
        if ( (rgb = gconf_client_get_string (client, SATLIST_HRGB_PATH, NULL)) ) {
		rgbv = g_strsplit ( rgb, ",", 3);
		high.red = (gushort) g_strtod (rgbv[0], NULL);
		high.green = (gushort)g_strtod (rgbv[1], NULL);
		high.blue = (gushort)g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		high.red = SATLIST_DEF_HIGH_RED;
		high.green = SATLIST_DEF_HIGH_GREEN;
		high.blue = SATLIST_DEF_HIGH_BLUE;
	}
	/* color for satellites below horizon */
	if ( (rgb = gconf_client_get_string (client, SATLIST_NRGB_PATH, NULL)) ) {
		rgbv = g_strsplit (rgb, ",", 3);
		norm.red = (gushort) g_strtod (rgbv[0], NULL);
		norm.green = (gushort) g_strtod (rgbv[1], NULL);
		norm.blue = (gushort) g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		norm.red = SATLIST_DEF_NORM_RED;
		norm.green = SATLIST_DEF_NORM_GREEN;
		norm.blue = SATLIST_DEF_NORM_BLUE;
	}
	/* Get geostationary below hor color */
	if ( (rgb = gconf_client_get_string (client, SATLIST_GNRGB_PATH, NULL)) ) {
		rgbv = g_strsplit (rgb, ",", 3);
		geon.red = (gushort) g_strtod (rgbv[0], NULL);
		geon.green = (gushort) g_strtod(rgbv[1], NULL);
		geon.blue = (gushort) g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		geon.red = SATLIST_DEF_NORM_RED;
		geon.green = SATLIST_DEF_NORM_GREEN;
		geon.blue = SATLIST_DEF_NORM_BLUE;
	}
	/* Get geostationary above hor color */
	if ( (rgb = gconf_client_get_string (client, SATLIST_GHRGB_PATH, NULL)) ) {
		rgbv = g_strsplit (rgb, ",", 3);
		geoh.red = (gushort) g_strtod (rgbv[0], NULL);
		geoh.green = (gushort) g_strtod (rgbv[1], NULL);
		geoh.blue = (gushort) g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		geoh.red = SATLIST_DEF_HIGH_RED;
		geoh.green = SATLIST_DEF_HIGH_GREEN;
		geoh.blue = SATLIST_DEF_HIGH_BLUE;
	}
	/* Get decayed color */
	if ( (rgb = gconf_client_get_string (client, SATLIST_DRGB_PATH, NULL)) ) {
		rgbv = g_strsplit (rgb, ",", 3);
		dec.red = (gushort) g_strtod (rgbv[0], NULL);
		dec.green = (gushort) g_strtod (rgbv[1], NULL);
		dec.blue = (gushort) g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		dec.red = SATLIST_DEF_NORM_RED;
		dec.green = SATLIST_DEF_NORM_GREEN;
		dec.blue = SATLIST_DEF_NORM_BLUE;
	}
	/* Get no AOS color */
	if ( (rgb = gconf_client_get_string (client, SATLIST_NARGB_PATH, NULL)) ) {
		rgbv = g_strsplit (rgb, ",", 3);
		noaos.red = (gushort) g_strtod (rgbv[0], NULL);
		noaos.green = (gushort) g_strtod (rgbv[1], NULL);
		noaos.blue = (gushort) g_strtod (rgbv[2], NULL);
		g_free (rgb);
		g_strfreev (rgbv);
	} else {
		noaos.red = SATLIST_DEF_NORM_RED;
		noaos.green = SATLIST_DEF_NORM_GREEN;
		noaos.blue = SATLIST_DEF_NORM_BLUE;
	}


	label = gtk_label_new (_("Satellites above horizon"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 1, 2);
	/* color picker */
	hcp = gnome_color_picker_new ();
	gtk_signal_connect (GTK_OBJECT (hcp), "color-set",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL);
	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (hcp),
				    high.red, high.green, high.blue, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), hcp, 2, 3, 1, 2);
	/* "reset to default" button */
	hcb = gtk_button_new_with_label (_("Default"));
	gtk_signal_connect (GTK_OBJECT (hcb), "clicked",
			    GTK_SIGNAL_FUNC (def_butt_cb), GUINT_TO_POINTER (DEF_BUT_AHOR));
	gtk_table_attach_defaults (GTK_TABLE (table), hcb, 3, 4, 1, 2);
	/* add some tooltips */
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (GTK_TOOLTIPS (kooltip), GTK_WIDGET (hcp),
			      _("Click to change the color"), NULL);
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (GTK_TOOLTIPS (kooltip), GTK_WIDGET (hcb),
			      _("Reset to the default color"), NULL);
	/***************************************/
	/* color picker for sats below horizon */
	/***************************************/
	label = gtk_label_new (_("Satellites below horizon"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE(table), label, 1, 2, 2, 3);
	/* color picker */
	ncp = gnome_color_picker_new ();
	gtk_signal_connect (GTK_OBJECT (ncp), "color-set",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL);
	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (ncp),
				    norm.red, norm.green, norm.blue, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), ncp, 2, 3, 2, 3);
	/* "reset to default" button */
	ncb = gtk_button_new_with_label(_("Default"));
	gtk_signal_connect (GTK_OBJECT (ncb), "clicked",
			    GTK_SIGNAL_FUNC (def_butt_cb), GUINT_TO_POINTER (DEF_BUT_BHOR));
	gtk_table_attach_defaults (GTK_TABLE (table), ncb, 3, 4, 2, 3);
	/* add some tooltips */
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (GTK_TOOLTIPS (kooltip), GTK_WIDGET (ncp),
			      _("Click to change the color"), NULL);
	kooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip (GTK_TOOLTIPS(kooltip), GTK_WIDGET (ncb),
			      _("Reset to the default color"), NULL);
	/*****************************************************/
	/* color picker for geostationary sats above horizon */
	/*****************************************************/
	label = gtk_label_new(_("Geostationary above horizon"));
	gtk_misc_set_alignment( GTK_MISC(label), 0.0f, 0.5f );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 3, 4 );
	/* color picker */
	ghcp = gnome_color_picker_new();
	gtk_signal_connect( GTK_OBJECT(ghcp), "color-set",
			    GTK_SIGNAL_FUNC(satpref_changed), NULL );
	gnome_color_picker_set_i16( GNOME_COLOR_PICKER(ghcp),
				    geoh.red, geoh.green, geoh.blue, 0 );
	gtk_table_attach_defaults( GTK_TABLE(table), ghcp, 2, 3, 3, 4 );
	/* "reset to default" button */
	ghcb = gtk_button_new_with_label(_("Default"));
	gtk_signal_connect( GTK_OBJECT(ghcb), "clicked",
			    GTK_SIGNAL_FUNC(def_butt_cb), GUINT_TO_POINTER( DEF_BUT_GEO_A ) );
	gtk_table_attach_defaults( GTK_TABLE(table), ghcb, 3, 4, 3, 4 );
	/* add some tooltips */
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(ghcp),
			      _("Click to change the color"), NULL );
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(ghcb),
			      _("Reset to the default color"), NULL );
	/*****************************************************/
	/* color picker for geostationary sats below horizon */
	/*****************************************************/
	label = gtk_label_new(_("Geostationary below horizon"));
	gtk_misc_set_alignment( GTK_MISC(label), 0.0f, 0.5f );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 4, 5 );
	/* color picker */
	gncp = gnome_color_picker_new();
	gtk_signal_connect( GTK_OBJECT(gncp), "color-set",
			    GTK_SIGNAL_FUNC(satpref_changed), NULL );
	gnome_color_picker_set_i16( GNOME_COLOR_PICKER(gncp),
				    geon.red, geon.green, geon.blue, 0 );
	gtk_table_attach_defaults( GTK_TABLE(table), gncp, 2, 3, 4, 5 );
	/* "reset to default" button */
	gncb = gtk_button_new_with_label(_("Default"));
	gtk_signal_connect( GTK_OBJECT(gncb), "clicked",
			    GTK_SIGNAL_FUNC(def_butt_cb), GUINT_TO_POINTER( DEF_BUT_GEO_B ) );
	gtk_table_attach_defaults( GTK_TABLE(table), gncb, 3, 4, 4, 5 );
	/* add some tooltips */
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(gncp),
			      _("Click to change the color"), NULL );
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(gncb),
			      _("Reset to the default color"), NULL );
	/*************************************/
	/* color picker for sats with NO AOS */
	/*************************************/
	label = gtk_label_new(_("Satellites with no AOS"));
	gtk_misc_set_alignment( GTK_MISC(label), 0.0f, 0.5f );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 5, 6 );
	/* color picker */
	nocp = gnome_color_picker_new();
	gtk_signal_connect( GTK_OBJECT(nocp), "color-set",
			    GTK_SIGNAL_FUNC(satpref_changed), NULL );
	gnome_color_picker_set_i16( GNOME_COLOR_PICKER(nocp),
				    noaos.red, noaos.green, noaos.blue, 0 );
	gtk_table_attach_defaults( GTK_TABLE(table), nocp, 2, 3, 5, 6 );
	/* "reset to default" button */
	nocb = gtk_button_new_with_label(_("Default"));
	gtk_signal_connect( GTK_OBJECT(nocb), "clicked",
			    GTK_SIGNAL_FUNC(def_butt_cb), GUINT_TO_POINTER( DEF_BUT_NOAOS ) );
	gtk_table_attach_defaults( GTK_TABLE(table), nocb, 3, 4, 5, 6 );
	/* add some tooltips */
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(nocp),
			      _("Click to change the color"), NULL );
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(nocb),
			      _("Reset to the default color"), NULL );
	/*********************************/
	/* color picker for decayed sats */
	/*********************************/
	label = gtk_label_new(_("Satellites that have decayed"));
	gtk_misc_set_alignment( GTK_MISC(label), 0.0f, 0.5f );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 6, 7 );
	/* color picker */
	dcp = gnome_color_picker_new();
	gtk_signal_connect( GTK_OBJECT(dcp), "color-set",
			    GTK_SIGNAL_FUNC(satpref_changed), NULL );
	gnome_color_picker_set_i16( GNOME_COLOR_PICKER(dcp),
				    dec.red, dec.green, dec.blue, 0 );
	gtk_table_attach_defaults( GTK_TABLE(table), dcp, 2, 3, 6, 7 );
	/* "reset to default" button */
	dcb = gtk_button_new_with_label(_("Default"));
	gtk_signal_connect( GTK_OBJECT(dcb), "clicked",
			    GTK_SIGNAL_FUNC(def_butt_cb), GUINT_TO_POINTER( DEF_BUT_DEC ) );
	gtk_table_attach_defaults( GTK_TABLE(table), dcb, 3, 4, 6, 7 );
	/* add some tooltips */
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(dcp),
			      _("Click to change the color"), NULL );
	kooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( GTK_TOOLTIPS(kooltip), GTK_WIDGET(dcb),
			      _("Reset to the default color"), NULL );

	return table;
}


void satpref_satlist_apply (void)
{
	gushort r,g,b,a;
	gchar *buff;


	/* sats below horizon */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (ncp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_NRGB_PATH, buff, NULL);
	g_free (buff);
	/* sats above horizon */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (hcp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_HRGB_PATH, buff, NULL);
	g_free (buff);
	/* geostationary sats below horizon */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (gncp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_GNRGB_PATH, buff, NULL);
	g_free (buff);
	/* geostationary sats above horizon */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (ghcp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_GHRGB_PATH, buff, NULL);
	g_free (buff);
	/* decayed sats */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (dcp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_DRGB_PATH, buff, NULL);
	g_free (buff);
	/* sats with no AOS */
	gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (nocp),
				    &r, &g, &b, &a );
	buff = g_strdup_printf ("%d,%d,%d",r,g,b);
	gconf_client_set_string (client, SATLIST_NARGB_PATH, buff, NULL);
	g_free (buff);

	/* timer value */
	gconf_client_set_int (client, SATLIST_TIMER_PATH,
			      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (listspin)),
			      NULL);

}


static void
def_butt_cb (GtkWidget *but, gpointer data)
{
	switch ( GPOINTER_TO_UINT(data) ) {
	case DEF_BUT_AHOR:
		high.red   = SATLIST_DEF_HIGH_RED;
		high.green = SATLIST_DEF_HIGH_GREEN;
		high.blue  = SATLIST_DEF_HIGH_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(hcp),
					    high.red, high.green, high.blue, 0 );
		break;
	case DEF_BUT_BHOR:
		norm.red   = SATLIST_DEF_NORM_RED;
		norm.green = SATLIST_DEF_NORM_GREEN;
		norm.blue  = SATLIST_DEF_NORM_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(ncp),
					    norm.red, norm.green, norm.blue, 0 );
		break;
	case DEF_BUT_GEO_A:
		geoh.red   = SATLIST_DEF_HIGH_RED;
		geoh.green = SATLIST_DEF_HIGH_GREEN;
		geoh.blue  = SATLIST_DEF_HIGH_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(ghcp),
					    geoh.red, geoh.green, geoh.blue, 0 );
		break;
	case DEF_BUT_GEO_B:
		geon.red   = SATLIST_DEF_NORM_RED;
		geon.green = SATLIST_DEF_NORM_GREEN;
		geon.blue  = SATLIST_DEF_NORM_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(gncp),
					    geon.red, geon.green, geon.blue, 0 );
		break;
	case DEF_BUT_DEC:
		dec.red   = SATLIST_DEF_NORM_RED;
		dec.green = SATLIST_DEF_NORM_GREEN;
		dec.blue  = SATLIST_DEF_NORM_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(dcp),
					    dec.red, dec.green, dec.blue, 0 );
		break;
	case DEF_BUT_NOAOS:
		noaos.red   = SATLIST_DEF_NORM_RED;
		noaos.green = SATLIST_DEF_NORM_GREEN;
		noaos.blue  = SATLIST_DEF_NORM_BLUE;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(nocp),
					    noaos.red, noaos.green, noaos.blue, 0 );
		break;
	default:
		satlog_log (SAT_LOG_CRITICAL, _("Internal error pressing default button:"));
		satlog_log (SAT_LOG_CRITICAL, _("PRESSED BUTTON DOES NOT EXIST!"));
		break;
	}

	satpref_changed();
}
