/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _CharBoxPrivate CharBoxPrivate;

#define TYPE_DIGIT_BOX (digit_box_get_type ())
#define DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGIT_BOX, DigitBox))
#define DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGIT_BOX, DigitBoxClass))
#define IS_DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGIT_BOX))
#define IS_DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGIT_BOX))
#define DIGIT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGIT_BOX, DigitBoxClass))

typedef struct _DigitBox DigitBox;
typedef struct _DigitBoxClass DigitBoxClass;
typedef struct _DigitBoxPrivate DigitBoxPrivate;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;

#define TYPE_CANVAS_MODE (canvas_mode_get_type ())

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _CharBox {
	GtkEventBox parent_instance;
	CharBoxPrivate * priv;
};

struct _CharBoxClass {
	GtkEventBoxClass parent_class;
};

/*
    Multiplication Puzzle
    Copyright (C) 2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _DigitBox {
	CharBox parent_instance;
	DigitBoxPrivate * priv;
};

struct _DigitBoxClass {
	CharBoxClass parent_class;
};

struct _DigitBoxPrivate {
	Canvas* _canvas;
};

/*
    Multiplication Puzzle
    Copyright (C) 2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef enum  {
	CANVAS_MODE_NONE,
	CANVAS_MODE_DIGIT,
	CANVAS_MODE_CHAR
} CanvasMode;



GType char_box_get_type (void);
GType digit_box_get_type (void);
GType canvas_get_type (void);
#define DIGIT_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIGIT_BOX, DigitBoxPrivate))
enum  {
	DIGIT_BOX_DUMMY_PROPERTY,
	DIGIT_BOX_CANVAS
};
static void digit_box_set_canvas (DigitBox* self, Canvas* value);
void char_box_set_letter (CharBox* self, const char* value);
DigitBox* digit_box_new (Canvas* canvas, const char* letter);
DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter);
DigitBox* digit_box_new (Canvas* canvas, const char* letter);
Canvas* digit_box_get_canvas (DigitBox* self);
GType canvas_mode_get_type (void);
void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box);
static void digit_box_handle_drag_begin (DigitBox* self, DigitBox* box, GdkDragContext* context);
static void digit_box_handle_drag_end (DigitBox* self, DigitBox* box, GdkDragContext* context);
const char* char_box_get_letter (CharBox* self);
static void digit_box_handle_drag_get (DigitBox* self, DigitBox* box, GdkDragContext* context, GtkSelectionData* data, guint info, guint time_);
void char_box_set_border (CharBox* self, GtkShadowType value);
static void _digit_box_handle_drag_get_gtk_widget_drag_data_get (DigitBox* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void _digit_box_handle_drag_begin_gtk_widget_drag_begin (DigitBox* _sender, GdkDragContext* context, gpointer self);
static void _digit_box_handle_drag_end_gtk_widget_drag_end (DigitBox* _sender, GdkDragContext* context, gpointer self);
static GObject * digit_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer digit_box_parent_class = NULL;
static void digit_box_finalize (GObject* obj);
static void digit_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void digit_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter) {
	GParameter * __params;
	GParameter * __params_it;
	DigitBox * self;
	g_return_val_if_fail (canvas != NULL, NULL);
	g_return_val_if_fail (letter != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "canvas";
	g_value_init (&__params_it->value, TYPE_CANVAS);
	g_value_set_object (&__params_it->value, canvas);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	char_box_set_letter ((CharBox*) self, letter);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DigitBox* digit_box_new (Canvas* canvas, const char* letter) {
	return digit_box_construct (TYPE_DIGIT_BOX, canvas, letter);
}


static void digit_box_handle_drag_begin (DigitBox* self, DigitBox* box, GdkDragContext* context) {
	gint width;
	gint height;
	gint min_width;
	gint min_height;
	gint _tmp0_;
	gint twidth;
	gint _tmp1_;
	gint theight;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp2_;
	gint x;
	gint y;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	/* Set mode, immediately invalidate/redraw ourselves to get new highlight*/
	canvas_set_mode (self->priv->_canvas, CANVAS_MODE_DIGIT, (CharBox*) box);
	gdk_window_invalidate_region (gtk_widget_get_window ((GtkWidget*) box), gdk_drawable_get_visible_region ((GdkDrawable*) gtk_widget_get_window ((GtkWidget*) box)), TRUE);
	gdk_window_process_updates (gtk_widget_get_window ((GtkWidget*) box), TRUE);
	/* Make drag icon be identical to this widget*/
	width = 0;
	height = 0;
	gdk_drawable_get_size ((GdkDrawable*) gtk_widget_get_window ((GtkWidget*) self), &width, &height);
	/* Determine maximum X cursor size.  We always want to be larger than this
	 to force GDK to use a window for the cursor.  Using X's cursor causes
	 issues.  See bug http://bugzilla.gnome.org/show_bug.cgi?id=544475.*/
	min_width = 0;
	min_height = 0;
	gdk_display_get_maximal_cursor_size (gtk_widget_get_display ((GtkWidget*) self), &min_width, &min_height);
	min_width = min_width + 1;
	min_height = min_height + 1;
	_tmp0_ = 0;
	if (width > min_width) {
		_tmp0_ = width;
	} else {
		_tmp0_ = min_width;
	}
	twidth = _tmp0_;
	_tmp1_ = 0;
	if (height > min_height) {
		_tmp1_ = height;
	} else {
		_tmp1_ = min_height;
	}
	theight = _tmp1_;
	pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, gdk_rgb_get_visual ()->bits_per_rgb, twidth, theight);
	gdk_pixbuf_fill (pixbuf, (guint32) 0);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	pixbuf = (_tmp3_ = (_tmp2_ = gdk_pixbuf_get_from_drawable (pixbuf, (GdkDrawable*) gtk_widget_get_window ((GtkWidget*) self), NULL, 0, 0, 0, 0, width, height), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_)), (pixbuf == NULL) ? NULL : (pixbuf = (g_object_unref (pixbuf), NULL)), _tmp3_);
	x = 0;
	y = 0;
	gtk_widget_get_pointer ((GtkWidget*) self, &x, &y);
	/* Sometimes, if pointer has moved a lot since it started moving with drag,
	 x or y can be out of range.  This causes the drag icon to not show.
	 So we clamp values to be safe.*/
	x = CLAMP (x, 0, width);
	y = CLAMP (y, 0, height);
	gtk_drag_set_icon_pixbuf (context, pixbuf, x, y);
	gtk_widget_hide ((GtkWidget*) self);
	(pixbuf == NULL) ? NULL : (pixbuf = (g_object_unref (pixbuf), NULL));
}


static void digit_box_handle_drag_end (DigitBox* self, DigitBox* box, GdkDragContext* context) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	gtk_widget_show ((GtkWidget*) self);
}


static void digit_box_handle_drag_get (DigitBox* self, DigitBox* box, GdkDragContext* context, GtkSelectionData* data, guint info, guint time_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	gtk_selection_data_set_text (data, char_box_get_letter ((CharBox*) self), (gint) strlen (char_box_get_letter ((CharBox*) self)));
}


Canvas* digit_box_get_canvas (DigitBox* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_canvas;
}


static void digit_box_set_canvas (DigitBox* self, Canvas* value) {
	Canvas* _tmp2_;
	Canvas* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_canvas = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)), (self->priv->_canvas == NULL) ? NULL : (self->priv->_canvas = (g_object_unref (self->priv->_canvas), NULL)), _tmp2_);
	g_object_notify ((GObject *) self, "canvas");
}


static void _digit_box_handle_drag_get_gtk_widget_drag_data_get (DigitBox* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	digit_box_handle_drag_get (self, _sender, context, selection_data, info, time_);
}


static void _digit_box_handle_drag_begin_gtk_widget_drag_begin (DigitBox* _sender, GdkDragContext* context, gpointer self) {
	digit_box_handle_drag_begin (self, _sender, context);
}


static void _digit_box_handle_drag_end_gtk_widget_drag_end (DigitBox* _sender, GdkDragContext* context, gpointer self) {
	digit_box_handle_drag_end (self, _sender, context);
}


static GObject * digit_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DigitBoxClass * klass;
	GObjectClass * parent_class;
	DigitBox * self;
	klass = DIGIT_BOX_CLASS (g_type_class_peek (TYPE_DIGIT_BOX));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DIGIT_BOX (obj);
	{
		GtkTargetEntry* _tmp0_;
		gint entries_size;
		gint entries_length1;
		GtkTargetEntry* entries;
		char_box_set_border ((CharBox*) self, GTK_SHADOW_OUT);
		_tmp0_ = NULL;
		entries = (_tmp0_ = g_new0 (GtkTargetEntry, 1), entries_length1 = 1, entries_size = entries_length1, _tmp0_);
		entries[0].target = "STRING";
		entries[0].flags = (guint) GTK_TARGET_SAME_APP;
		entries[0].info = (guint) 0;
		gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, entries, entries_length1, GDK_ACTION_MOVE);
		g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) _digit_box_handle_drag_get_gtk_widget_drag_data_get, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) _digit_box_handle_drag_begin_gtk_widget_drag_begin, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) _digit_box_handle_drag_end_gtk_widget_drag_end, self, 0);
		/* Translators: If there's a better alternative to Arabic numerals for
		 your language, please use it instead of these digits.  Note
		 that it still has to make sense when used as part of the math puzzle.*/
		N_ ("0");
		N_ ("1");
		N_ ("2");
		N_ ("3");
		N_ ("4");
		N_ ("5");
		N_ ("6");
		N_ ("7");
		N_ ("8");
		N_ ("9");
		entries = (g_free (entries), NULL);
	}
	return obj;
}


static void digit_box_class_init (DigitBoxClass * klass) {
	digit_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DigitBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = digit_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = digit_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = digit_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = digit_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGIT_BOX_CANVAS, g_param_spec_object ("canvas", "canvas", "canvas", TYPE_CANVAS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void digit_box_instance_init (DigitBox * self) {
	self->priv = DIGIT_BOX_GET_PRIVATE (self);
}


static void digit_box_finalize (GObject* obj) {
	DigitBox * self;
	self = DIGIT_BOX (obj);
	(self->priv->_canvas == NULL) ? NULL : (self->priv->_canvas = (g_object_unref (self->priv->_canvas), NULL));
	G_OBJECT_CLASS (digit_box_parent_class)->finalize (obj);
}


GType digit_box_get_type (void) {
	static GType digit_box_type_id = 0;
	if (digit_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DigitBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) digit_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DigitBox), 0, (GInstanceInitFunc) digit_box_instance_init, NULL };
		digit_box_type_id = g_type_register_static (TYPE_CHAR_BOX, "DigitBox", &g_define_type_info, 0);
	}
	return digit_box_type_id;
}


static void digit_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DigitBox * self;
	gpointer boxed;
	self = DIGIT_BOX (object);
	switch (property_id) {
		case DIGIT_BOX_CANVAS:
		g_value_set_object (value, digit_box_get_canvas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void digit_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DigitBox * self;
	self = DIGIT_BOX (object);
	switch (property_id) {
		case DIGIT_BOX_CANVAS:
		digit_box_set_canvas (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




